/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc;

import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.IlrResourceProviderDescriptorReader;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import ilog.rules.res.util.classloader.IlrClassLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Map;

public class IlrDAOConfigurator {
    public static final String REPOSITORY_DESCRIPTOR = "RepositoryDAODescriptor.xml";
    private final IlrJDBCConnectionProvider connectionProvider;
    private final DAOInfo daoInfo;
    private final ConnectionInfo connInfo;

    public IlrDAOConfigurator(IlrJDBCConnectionProvider connectionProvider, ConnectionInfo connInfo, DAOInfo daoInfo) throws IlrDAOException {
        this.connectionProvider = connectionProvider;
        this.daoInfo = daoInfo;
        this.connInfo = connInfo;
    }

    public static IlrDAOConfigurator createInstance(String descriptor, IlrJDBCConnectionProvider connectionProvider) throws IlrDAOException {
        Connection conn = connectionProvider.getConnection();
        ConnectionInfo connInfo = IlrDAOConfigurator.getConnectionInfo(conn);
        DAOInfo daoInfo = IlrDAOConfigurator.readDAOInfoFromDescriptor(descriptor, connInfo.getDatabaseProductName());
        return new IlrDAOConfigurator(connectionProvider, connInfo, daoInfo);
    }

    private static ConnectionInfo getConnectionInfo(Connection conn) throws IlrDAOException {
        ConnectionInfo connInfo;
        try {
            DatabaseMetaData metadata = conn.getMetaData();
            if (metadata == null) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.METADATA_UNAVAILABLE_ERROR);
            }
            String databaseProductName = metadata.getDatabaseProductName();
            String databaseProductVersion = metadata.getDatabaseProductVersion();
            String url = metadata.getURL();
            String user = metadata.getUserName();
            connInfo = new ConnectionInfo(databaseProductName, databaseProductVersion, url, user);
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.METADATA_CONNECTION_ERROR, e);
        }
        finally {
            IlrDatabaseUtility.closeConnection(conn);
        }
        return connInfo;
    }

    public static DAOInfo readDAOInfoFromDescriptor(final String descriptor, String databaseProductName) throws IlrDAOException {
        DAOInfo daoInfo;
        InputStream inputStream = null;
        try {
            inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    InputStream stream = this.getClass().getResourceAsStream(descriptor);
                    if (stream != null) {
                        return stream;
                    }
                    return IlrClassLoaderUtil.getThreadClassLoader().getResourceAsStream(descriptor);
                }
            });
            IlrResourceProviderDescriptorReader descriptorReader = new IlrResourceProviderDescriptorReader(inputStream, databaseProductName);
            String daoClassName = descriptorReader.getResourceProviderClassName();
            Map<String, String> sqlStatements = descriptorReader.getSQLStatements();
            Map<String, IlrResourceProviderDescriptorReader.Table> sqlTables = descriptorReader.getSQLTables();
            daoInfo = new DAOInfo(daoClassName, sqlStatements, sqlTables);
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.XML_DESCRIPTOR_ERROR, new String[]{descriptor}, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return daoInfo;
    }

    public IlrJDBCConnectionProvider getJDBCConnectionProvider() {
        return this.connectionProvider;
    }

    public Object createDAO() throws IlrDAOException {
        try {
            Class<?> resourceProviderClass = Class.forName(this.daoInfo.getDaoClassName());
            Constructor<?> resourceProviderConstructor = resourceProviderClass.getConstructor(this.getClass(), IlrJDBCConnectionProvider.class);
            return resourceProviderConstructor.newInstance(this, this.connectionProvider);
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.DAO_CREATION_ERROR, new String[]{this.daoInfo.getDaoClassName()}, e);
        }
    }

    public String getSQLStatement(String key) {
        return this.daoInfo.getSqlStatements().get(key);
    }

    public IlrResourceProviderDescriptorReader.Table getSQLTable(String key) {
        return this.daoInfo.getSqlTables().get(key);
    }

    public String getDatabaseURL() {
        return this.connInfo.getUrl();
    }

    public String getUserName() {
        return this.connInfo.getUser();
    }

    public String getDatabaseProductName() {
        return this.connInfo.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() {
        return this.connInfo.getDatabaseProductVersion();
    }

    public static class ConnectionInfo {
        private final String databaseProductName;
        private final String databaseProductVersion;
        private final String url;
        private final String user;

        public ConnectionInfo(String databaseProductName, String databaseProductVersion, String url, String user) {
            this.databaseProductName = databaseProductName;
            this.databaseProductVersion = databaseProductVersion;
            this.url = url;
            this.user = user;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUser() {
            return this.user;
        }

        public String getDatabaseProductName() {
            return this.databaseProductName;
        }

        public String getDatabaseProductVersion() {
            return this.databaseProductVersion;
        }
    }

    public static class DAOInfo {
        private final String daoClassName;
        private final Map<String, String> sqlStatements;
        private final Map<String, IlrResourceProviderDescriptorReader.Table> sqlTables;

        public DAOInfo(String daoClassName, Map<String, String> sqlStatements, Map<String, IlrResourceProviderDescriptorReader.Table> sqlTables) {
            this.daoClassName = daoClassName;
            this.sqlStatements = sqlStatements;
            this.sqlTables = sqlTables;
        }

        public String getDaoClassName() {
            return this.daoClassName;
        }

        public Map<String, String> getSqlStatements() {
            return this.sqlStatements;
        }

        public Map<String, IlrResourceProviderDescriptorReader.Table> getSqlTables() {
            return this.sqlTables;
        }
    }
}

