/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc;

import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class IlrDataSourceConnectionProvider
implements IlrJDBCConnectionProvider {
    private final DataSource datasource;
    private final boolean transacted;
    private boolean underWebsphere7GlobalTransaction = false;
    private Object transaction;
    private Method transactionStatusMethod;
    private Integer noTransactionFieldValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrDataSourceConnectionProvider(DataSource datasource, boolean transacted) {
        this.datasource = datasource;
        this.transacted = transacted;
        if (transacted) {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                this.transaction = IlrDataSourceConnectionProvider.getUserTransaction(ctx, "java:comp/UserTransaction");
                if (this.transaction == null) {
                    this.transaction = IlrDataSourceConnectionProvider.getUserTransaction(ctx, "java:UserTransaction");
                }
                if (this.transaction == null) {
                    this.transaction = IlrDataSourceConnectionProvider.getUserTransaction(ctx, "UserTransaction");
                }
                if (this.transaction == null) {
                    this.transaction = this.getOngoingTransactionForWebsphereAppServer();
                }
                if (this.transaction != null) {
                    Field noTransactionField;
                    this.transactionStatusMethod = this.transaction.getClass().getMethod("getStatus", null);
                    Class<?> statusClass = Class.forName("javax.transaction.Status");
                    if (statusClass != null && (noTransactionField = statusClass.getField("STATUS_NO_TRANSACTION")) != null) {
                        this.noTransactionFieldValue = noTransactionField.getInt(null);
                    }
                } else {
                    this.underWebsphere7GlobalTransaction = this.isUnderGlobalTransactionOnWebsphere7AppServer(ctx);
                }
            }
            catch (Exception e) {
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private Object getOngoingTransactionForWebsphereAppServer() {
        Method factoryMethod;
        Class<?> factoryClass;
        try {
            factoryClass = Class.forName("com.ibm.ws.Transaction.TransactionManagerFactory");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            factoryMethod = factoryClass.getMethod("getTransactionManager", null);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return factoryMethod.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isUnderGlobalTransactionOnWebsphere7AppServer(InitialContext ctx) {
        try {
            Object uowManager = IlrDataSourceConnectionProvider.getUserTransaction(ctx, "java:comp/websphere/UOWManager");
            Class<?> uowManagerClass = uowManager.getClass();
            Class<?> uowSynchronizationRegistryClass = uowManager.getClass().getClassLoader().loadClass("com.ibm.websphere.uow.UOWSynchronizationRegistry");
            int UOW_STATUS_NONE = uowSynchronizationRegistryClass.getField("UOW_STATUS_NONE").getInt(null);
            int UOW_TYPE_LOCAL_TRANSACTION = uowSynchronizationRegistryClass.getField("UOW_TYPE_LOCAL_TRANSACTION").getInt(null);
            int uowStatus = (Integer)uowManagerClass.getMethod("getUOWStatus", new Class[0]).invoke(uowManager, new Object[0]);
            int uowType = (Integer)uowManagerClass.getMethod("getUOWType", new Class[0]).invoke(uowManager, new Object[0]);
            return uowStatus != UOW_STATUS_NONE && uowType != UOW_TYPE_LOCAL_TRANSACTION;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Connection getConnection() throws IlrDAOException {
        Connection connection = null;
        try {
            connection = this.datasource.getConnection();
        }
        catch (SQLException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.CONNECT_ERROR, e);
        }
        if (connection == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.CONNECT_ERROR);
        }
        return connection;
    }

    @Override
    public boolean isUnderTransaction() {
        if (!this.transacted) {
            return true;
        }
        if (this.underWebsphere7GlobalTransaction) {
            return true;
        }
        try {
            Object status;
            if (this.transaction != null && this.transactionStatusMethod != null && (status = this.transactionStatusMethod.invoke(this.transaction, (Object[])null)) != null) {
                return !status.equals(this.noTransactionFieldValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Object getUserTransaction(InitialContext ctx, String jndiName) {
        try {
            return ctx.lookup(jndiName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

