/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc;

import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.IlrDataSourceConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class IlrDataSourceDAOFactory {
    private static final String DEFAULT_JNDINAME = "jdbc/resdatasource";
    private static final String APPLICATION_SCOPE_LOOKUP = "java:comp/env/";
    private static final String APPLICATION_SCOPE_LOOKUP_TOMCAT = "java:/comp/env/";
    private static final String APPLICATION_SCOPE_LOOKUP_JAVA = "java:/";

    public static Object getDAO(String descriptor, String jndiName, boolean transactionSupport) throws IlrDAOException {
        IlrJDBCConnectionProvider connectionProvider = IlrDataSourceDAOFactory.createJDBCConnectionProvider(jndiName, transactionSupport);
        IlrDAOConfigurator configurator = IlrDAOConfigurator.createInstance(descriptor, connectionProvider);
        return configurator.createDAO();
    }

    public static IlrJDBCConnectionProvider createJDBCConnectionProvider(String jndiName, boolean transactionSupport) throws IlrDAOException {
        DataSource datasource;
        if (jndiName == null) {
            jndiName = DEFAULT_JNDINAME;
        }
        if (jndiName.length() > 6 && jndiName.startsWith(APPLICATION_SCOPE_LOOKUP_JAVA)) {
            jndiName = jndiName.substring(6);
        }
        try {
            datasource = IlrDataSourceDAOFactory.getDataSource(APPLICATION_SCOPE_LOOKUP + jndiName);
        }
        catch (NamingException ne1) {
            try {
                datasource = IlrDataSourceDAOFactory.getDataSource(APPLICATION_SCOPE_LOOKUP_TOMCAT + jndiName);
            }
            catch (NamingException ne2) {
                try {
                    datasource = IlrDataSourceDAOFactory.getDataSource(APPLICATION_SCOPE_LOOKUP_JAVA + jndiName);
                }
                catch (NamingException ne3) {
                    try {
                        datasource = IlrDataSourceDAOFactory.getDataSource(jndiName);
                    }
                    catch (NamingException ne4) {
                        throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.LOOKUP_ERROR, new String[]{String.valueOf(APPLICATION_SCOPE_LOOKUP + jndiName), String.valueOf(APPLICATION_SCOPE_LOOKUP_TOMCAT + jndiName), String.valueOf(jndiName)}, ne4);
                    }
                }
            }
        }
        return new IlrDataSourceConnectionProvider(datasource, transactionSupport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSource getDataSource(String jndiName) throws NamingException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            DataSource dataSource = (DataSource)ctx.lookup(jndiName);
            return dataSource;
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }
}

