/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc;

import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;

public class IlrDriverConnectionProvider
implements IlrJDBCConnectionProvider {
    private final Driver driver;
    private final String url;
    private final Properties connProps;

    public IlrDriverConnectionProvider(Driver driver, String url, Properties connProps) {
        this.driver = driver;
        this.url = url;
        this.connProps = connProps;
    }

    @Override
    public synchronized Connection getConnection() throws IlrDAOException {
        Connection connection = null;
        try {
            connection = this.driver.connect(this.url, this.connProps);
        }
        catch (SQLException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.CONNECT_ERROR, e);
        }
        if (connection == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.CONNECT_ERROR);
        }
        return connection;
    }

    @Override
    public boolean isUnderTransaction() {
        return false;
    }
}

