/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc;

import com.ibm.rules.res.persistence.internal.PersistencePropertiesConverter;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.IlrDriverConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import java.sql.Driver;
import java.util.Properties;

public class IlrDriverDAOFactory {
    public static Object getDAO(String descriptor, ClassLoader classLoader, String driverName, String url, Properties connProps) throws IlrDAOException {
        IlrJDBCConnectionProvider connectionProvider = IlrDriverDAOFactory.createJDBCConnectionProvider(classLoader, driverName, url, connProps);
        IlrDAOConfigurator configurator = IlrDAOConfigurator.createInstance(descriptor, connectionProvider);
        IlrRepositoryDAO repoDAO = (IlrRepositoryDAO)configurator.createDAO();
        repoDAO.setClassLoader(classLoader);
        return repoDAO;
    }

    private static IlrJDBCConnectionProvider createJDBCConnectionProvider(ClassLoader classLoader, String driverName, String url, Properties connProps) throws IlrDAOException {
        if (driverName == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.DRIVER_NAME_ERROR);
        }
        if (url == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.URL_ERROR);
        }
        try {
            Class<?> driverClass = null;
            driverClass = classLoader != null ? Class.forName(driverName, true, classLoader) : Class.forName(driverName);
            Driver driver = (Driver)driverClass.newInstance();
            return new IlrDriverConnectionProvider(driver, url, connProps);
        }
        catch (Exception e) {
            Properties props = PersistencePropertiesConverter.obfuscate(connProps);
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.DRIVER_CREATION_ERROR, new String[]{String.valueOf(classLoader), driverName, url, String.valueOf(props)}, e);
        }
    }
}

