/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc;

import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrTransaction;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.IlrGenericDAOBase;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCTransaction;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.Statement;

public abstract class IlrGenericDAO
extends IlrGenericDAOBase {
    protected IlrGenericDAO(IlrDAOConfigurator configurator, IlrJDBCConnectionProvider connectionProvider, String schemaPrefix) {
        super(configurator, connectionProvider, schemaPrefix);
    }

    public IlrTransaction beginTransaction() throws IlrDAOException {
        IlrJDBCTransaction transaction = new IlrJDBCTransaction(this.connectionProvider);
        try {
            transaction.begin();
        }
        catch (IlrDAOException e) {
            transaction.close();
            throw e;
        }
        return transaction;
    }

    @Override
    public void executeSQL(String sqlStatement) throws IlrDAOException {
        IlrJDBCTransaction tr = (IlrJDBCTransaction)this.beginTransaction();
        Statement statement = null;
        try {
            statement = tr.getConnection().createStatement();
            statement.execute(sqlStatement);
            tr.commit();
        }
        catch (Exception e) {
            tr.rollback();
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.EXECUTE_SQL_ERROR, new String[]{sqlStatement}, e);
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
            tr.close();
        }
    }
}

