/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import com.ibm.rules.res.persistence.internal.DAOLoader;
import com.ibm.rules.res.persistence.internal.XOMClassLoader;
import com.ibm.rules.res.persistence.internal.XOMClassLoaderFactory;
import com.ibm.rules.res.persistence.internal.file.FileXOMRepositoryDAO;
import com.ibm.rules.res.persistence.internal.jdbc.DAOConfigurator;
import com.ibm.rules.res.persistence.internal.jdbc.GenericXOMRepositoryDAO;
import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrDERulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrDiagnosticResult;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.IlrResourceNotFoundDAOException;
import ilog.rules.res.persistence.IlrTransaction;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.IlrDiagnosticResultImpl;
import ilog.rules.res.persistence.impl.IlrRulesetArchiveData;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.IlrGenericDAO;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCTransaction;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDiagnostic;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrRuleAppPropertiesTable;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrRuleAppsTable;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrRulesetPropertiesTable;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrRulesetResourcesTable;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrRulesetsEnabledView;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrRulesetsTable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class IlrGenericRepositoryDAO
extends IlrGenericDAO
implements IlrRepositoryDAO {
    private final transient RESLogger logger = RESLogger.getRESLogger("com.ibm.rules.res.persistence", "ilog.rules.res.persistence.impl.messages");
    protected XOMRepositoryDAO xomRepository;
    protected ClassLoader classLoader;

    public IlrGenericRepositoryDAO(IlrDAOConfigurator configurator, IlrJDBCConnectionProvider connectionProvider) {
        super(configurator, connectionProvider, "repository_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IlrDiagnosticResult executeDiagnostic() {
        Connection connection = null;
        try {
            connection = this.connectionProvider.getConnection();
            DatabaseMetaData metadata = connection.getMetaData();
            Properties props = IlrDiagnostic.fillMetaData(this.getClass(), metadata);
            boolean c1 = IlrDiagnostic.checkRuleAppsTable(this.configurator, metadata, props);
            boolean c2 = IlrDiagnostic.checkRulesetsTable(this.configurator, metadata, props);
            boolean c3 = IlrDiagnostic.checkRuleAppPropertiesTable(this.configurator, metadata, props);
            boolean c4 = IlrDiagnostic.checkRulesetPropertiesTable(this.configurator, metadata, props);
            boolean c5 = IlrDiagnostic.checkRulesetResourcesTable(this.configurator, metadata, props);
            boolean c6 = IlrDiagnostic.checkRulesetEnabledView(this.configurator, metadata, props);
            IlrDiagnosticResultImpl ilrDiagnosticResultImpl = new IlrDiagnosticResultImpl(props, c1 && c2 && c3 && c4 && c5 && c6);
            return ilrDiagnosticResultImpl;
        }
        catch (Exception e) {
            IlrDiagnosticResultImpl ilrDiagnosticResultImpl = new IlrDiagnosticResultImpl(e);
            return ilrDiagnosticResultImpl;
        }
        finally {
            IlrDatabaseUtility.closeConnection(connection);
        }
    }

    @Override
    public String getSchema(String schemaName) throws IOException {
        String repositorySchema = super.getSchema(schemaName);
        return repositorySchema;
    }

    @Override
    public Set<IlrMutableRuleAppInformation> load(IlrRepositoryFactory repositoryFactory) throws IlrDAOException {
        IlrJDBCTransaction tr = (IlrJDBCTransaction)this.beginTransaction();
        try {
            Map<Integer, IlrMutableRuleAppInformation> ruleAppsById = IlrRuleAppsTable.load(this.configurator, tr.getConnection(), repositoryFactory);
            List<IlrRulesetsTable.RulesetItem> rulesetItems = IlrRulesetsTable.load(this.configurator, tr.getConnection(), repositoryFactory);
            for (IlrRulesetsTable.RulesetItem rulesetItem : rulesetItems) {
                IlrMutableRuleAppInformation ruleApp = ruleAppsById.get(rulesetItem.getRuleAppId());
                if (ruleApp == null) continue;
                ruleApp.addRuleset(rulesetItem.getRuleset());
            }
            tr.commit();
            HashSet<IlrMutableRuleAppInformation> hashSet = new HashSet<IlrMutableRuleAppInformation>(ruleAppsById.values());
            return hashSet;
        }
        catch (Exception e) {
            tr.rollback();
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.LOAD_REPOSITORY_ERROR, e);
        }
        finally {
            tr.close();
        }
    }

    @Override
    public void setDisplayName(IlrPath path, String displayName) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!path.isCanonical()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(path)});
        }
        IlrJDBCTransaction tr = (IlrJDBCTransaction)this.beginTransaction();
        try {
            if (path.isRuleAppPath()) {
                if (!IlrRuleAppsTable.setDisplayName(this.configurator, tr.getConnection(), path, displayName)) {
                    throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND, new String[]{String.valueOf(path)});
                }
            } else if (!IlrRulesetsTable.setDisplayName(this.configurator, tr.getConnection(), path, displayName)) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND, new String[]{String.valueOf(path)});
            }
            tr.commit();
        }
        catch (IlrResourceNotFoundDAOException e) {
            tr.rollback();
            throw e;
        }
        catch (Exception e) {
            tr.rollback();
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_DISPLAY_NAME_ERROR, new String[]{String.valueOf(path), displayName}, e);
        }
        finally {
            tr.close();
        }
    }

    @Override
    public void setDescription(IlrPath path, String description) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!path.isCanonical()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(path)});
        }
        IlrJDBCTransaction transaction = (IlrJDBCTransaction)this.beginTransaction();
        try {
            if (path.isRuleAppPath()) {
                if (!IlrRuleAppsTable.setDescription(this.configurator, transaction.getConnection(), path, description)) {
                    throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND, new String[]{String.valueOf(path)});
                }
            } else if (!IlrRulesetsTable.setDescription(this.configurator, transaction.getConnection(), path, description)) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND, new String[]{String.valueOf(path)});
            }
            transaction.commit();
        }
        catch (IlrResourceNotFoundDAOException e) {
            transaction.rollback();
            throw e;
        }
        catch (Exception e) {
            transaction.rollback();
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_DESCRIPTION_ERROR, new String[]{String.valueOf(path), description}, e);
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public IlrRESRulesetArchive getRESRulesetArchive(IlrPath rulesetPath) throws IlrDAOException, IlrResourceNotFoundDAOException {
        try {
            IlrRulesetArchiveData archiveData = this.getRulesetArchiveData(rulesetPath);
            return IlrRESArchiveUtil.getRESRulesetArchive(archiveData.getEngineType(), StreamUtil.toStream(archiveData.getData()));
        }
        catch (IOException e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_RULESET_ARCHIVE_ERROR, new String[]{String.valueOf(rulesetPath)}, e);
        }
    }

    @Override
    public void setRESRulesetArchive(IlrPath rulesetPath, IlrEngineType engineType, InputStream stream) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!rulesetPath.isCanonical() || !rulesetPath.isRulesetPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(rulesetPath)});
        }
        if (stream == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.RULESET_ARCHIVE_NULL, new String[]{String.valueOf(rulesetPath)});
        }
        IlrJDBCTransaction transaction = (IlrJDBCTransaction)this.beginTransaction();
        try {
            int rulesetId = IlrRulesetsTable.getId(this.configurator, transaction.getConnection(), rulesetPath);
            if (rulesetId == -1) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND, new String[]{String.valueOf(rulesetPath)});
            }
            this.setProperty(rulesetPath, "ruleset.engine", engineType.toString(), transaction);
            IlrRulesetResourcesTable.delete(this.configurator, transaction.getConnection(), rulesetId);
            IlrRulesetResourcesTable.insert(this.configurator, transaction.getConnection(), rulesetId, stream);
            transaction.commit();
        }
        catch (IlrResourceNotFoundDAOException e) {
            transaction.rollback();
            throw e;
        }
        catch (Exception e) {
            transaction.rollback();
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_RULESET_ARCHIVE_ERROR, new String[]{String.valueOf(rulesetPath)}, e);
        }
        finally {
            transaction.close();
        }
    }

    protected Map<String, String> getProperties(IlrPath path, IlrJDBCTransaction tr) throws IlrDAOException, IlrResourceNotFoundDAOException, SQLException {
        Map<String, String> result = null;
        if (path.isRuleAppPath()) {
            int ruleAppId = IlrRuleAppsTable.getId(this.configurator, tr.getConnection(), path);
            if (ruleAppId == -1) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND, new String[]{String.valueOf(path)});
            }
            result = IlrRuleAppPropertiesTable.get(this.configurator, tr.getConnection(), ruleAppId);
        } else {
            int rulesetId = IlrRulesetsTable.getId(this.configurator, tr.getConnection(), path);
            if (rulesetId == -1) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND, new String[]{String.valueOf(path)});
            }
            result = IlrRulesetPropertiesTable.get(this.configurator, tr.getConnection(), rulesetId);
        }
        return result;
    }

    @Override
    public Map<String, String> getProperties(IlrPath path) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!path.isCanonical()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(path)});
        }
        IlrJDBCTransaction tr = (IlrJDBCTransaction)this.beginTransaction();
        try {
            Map<String, String> result = this.getProperties(path, tr);
            tr.commit();
            Map<String, String> map = result;
            return map;
        }
        catch (IlrResourceNotFoundDAOException e) {
            tr.rollback();
            throw e;
        }
        catch (Exception e) {
            tr.rollback();
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_PROPERTIES_ERROR, new String[]{String.valueOf(path)}, e);
        }
        finally {
            tr.close();
        }
    }

    public void setProperty(IlrPath path, String key, String value, IlrJDBCTransaction transaction) throws IlrDAOException, IlrResourceNotFoundDAOException, SQLException {
        if (path.isRuleAppPath()) {
            int ruleAppId = IlrRuleAppsTable.getId(this.configurator, transaction.getConnection(), path);
            if (ruleAppId == -1) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND, new String[]{String.valueOf(path)});
            }
            IlrRuleAppPropertiesTable.delete(this.configurator, transaction.getConnection(), key, ruleAppId);
            if (value != null) {
                IlrRuleAppPropertiesTable.insert(this.configurator, transaction.getConnection(), ruleAppId, key, value);
            }
        } else {
            int rulesetId = IlrRulesetsTable.getId(this.configurator, transaction.getConnection(), path);
            if (rulesetId == -1) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND, new String[]{String.valueOf(path)});
            }
            IlrRulesetPropertiesTable.delete(this.configurator, transaction.getConnection(), key, rulesetId);
            if (value != null) {
                IlrRulesetPropertiesTable.insert(this.configurator, transaction.getConnection(), rulesetId, key, value);
            }
        }
    }

    @Override
    public void setProperty(IlrPath path, String key, String value) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!path.isCanonical()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(path)});
        }
        IlrJDBCTransaction transaction = (IlrJDBCTransaction)this.beginTransaction();
        try {
            this.setProperty(path, key, value, transaction);
            transaction.commit();
        }
        catch (IlrResourceNotFoundDAOException e) {
            transaction.rollback();
            throw e;
        }
        catch (Exception e) {
            transaction.rollback();
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.SET_PROPERTY_ERROR, new String[]{String.valueOf(path), key, value}, e);
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public IlrPath getCanonicalRulesetPath(IlrPath path) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!path.isRulesetPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(path)});
        }
        IlrPath result = null;
        IlrJDBCTransaction tr = (IlrJDBCTransaction)this.beginTransaction();
        try {
            result = path.getRuleAppVersion() != null && path.getRulesetVersion() != null ? IlrRulesetsEnabledView.getCanonicalRulesetPath(this.configurator, tr.getConnection(), path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName(), path.getRulesetVersion()) : (path.getRuleAppVersion() != null && path.getRulesetVersion() == null ? IlrRulesetsEnabledView.getCanonicalRulesetPath(this.configurator, tr.getConnection(), path.getRuleAppName(), path.getRuleAppVersion(), path.getRulesetName()) : (path.getRuleAppVersion() == null && path.getRulesetVersion() != null ? IlrRulesetsEnabledView.getCanonicalRulesetPath(this.configurator, tr.getConnection(), path.getRuleAppName(), path.getRulesetName(), path.getRulesetVersion()) : IlrRulesetsEnabledView.getCanonicalRulesetPath(this.configurator, tr.getConnection(), path.getRuleAppName(), path.getRulesetName())));
            tr.commit();
        }
        catch (Exception e) {
            tr.rollback();
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_CANONICAL_RULESETPATH_ERROR, new String[]{String.valueOf(path)}, e);
        }
        finally {
            tr.close();
        }
        if (result == null) {
            throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND, new String[]{String.valueOf(path)});
        }
        return result;
    }

    @Override
    public void addRuleApp(IlrMutableRuleAppInformation ruleApp) throws IlrDAOException, IlrResourceNotFoundDAOException {
        IlrTransaction transaction = this.beginTransaction();
        try {
            this.addRuleApp(ruleApp, transaction);
            transaction.commit();
        }
        catch (IlrDAOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public void addRuleApp(IlrMutableRuleAppInformation ruleApp, IlrTransaction transaction) throws IlrDAOException, IlrResourceNotFoundDAOException {
        IlrJDBCTransaction tr = (IlrJDBCTransaction)transaction;
        try {
            this.removeRuleApp(ruleApp.getName(), ruleApp.getVersion(), transaction);
            IlrRuleAppsTable.insert(this.configurator, tr.getConnection(), ruleApp);
            int ruleAppId = IlrRuleAppsTable.getId(this.configurator, tr.getConnection(), ruleApp.getName(), ruleApp.getVersion());
            if (ruleAppId == -1) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND, new String[]{String.valueOf(ruleApp)});
            }
            IlrRuleAppPropertiesTable.insert(this.configurator, tr.getConnection(), ruleAppId, ruleApp.getProperties());
            for (IlrMutableRulesetArchiveInformation ruleset : ruleApp.getRulesets()) {
                IlrRESRulesetArchive resArchive = ruleset.getRESRulesetArchive();
                if (resArchive == null) {
                    throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.RULESET_ARCHIVE_NULL, new String[]{String.valueOf(ruleset)});
                }
                IlrEngineType engineType = ruleset.getProperties().getEngineType();
                IlrRulesetsTable.insert(this.configurator, tr.getConnection(), ruleset.getName(), ruleset.getVersion(), ruleAppId, ruleset);
                int rulesetId = IlrRulesetsTable.getId(this.configurator, tr.getConnection(), ruleset.getName(), ruleset.getVersion(), ruleAppId);
                if (rulesetId == -1) {
                    throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND, new String[]{String.valueOf(ruleset)});
                }
                IlrRulesetPropertiesTable.insert(this.configurator, tr.getConnection(), rulesetId, ruleset.getProperties());
                if (engineType == IlrEngineType.CRE) {
                    IlrRulesetResourcesTable.insert(this.configurator, tr.getConnection(), rulesetId, IlrRESArchiveUtil.getRulesetArchiveAsStream(((IlrCRERulesetArchive)resArchive).getRulesetArchive()));
                    continue;
                }
                if (engineType != IlrEngineType.DE) continue;
                IlrRulesetResourcesTable.insert(this.configurator, tr.getConnection(), rulesetId, ((IlrDERulesetArchive)resArchive).getContentStream());
            }
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.ADD_RULEAPP_ERROR, new String[]{String.valueOf(ruleApp)}, e);
        }
    }

    @Override
    public void addRuleset(IlrPath rulesetPath, IlrMutableRulesetArchiveInformation ruleset) throws IlrDAOException, IlrResourceNotFoundDAOException {
        IlrTransaction transaction = this.beginTransaction();
        try {
            this.addRuleset(rulesetPath, ruleset, transaction);
            transaction.commit();
        }
        catch (IlrDAOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public void addRuleset(IlrPath rulesetPath, IlrMutableRulesetArchiveInformation ruleset, IlrTransaction transaction) throws IlrDAOException, IlrResourceNotFoundDAOException {
        if (!rulesetPath.isCanonical() || !rulesetPath.isRulesetPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(rulesetPath)});
        }
        IlrRESRulesetArchive archive = ruleset.getRESRulesetArchive();
        if (archive == null) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.RULESET_ARCHIVE_NULL, new String[]{String.valueOf(rulesetPath)});
        }
        if (IlrRESArchiveUtil.isEmpty(archive)) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.RULESET_ARCHIVE_EMPTY, new String[]{String.valueOf(rulesetPath)});
        }
        IlrJDBCTransaction tr = (IlrJDBCTransaction)transaction;
        try {
            this.removeRuleset(rulesetPath, transaction);
            int ruleAppId = IlrRuleAppsTable.getId(this.configurator, tr.getConnection(), rulesetPath);
            if (ruleAppId == -1) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND, new String[]{"/" + rulesetPath.getRuleAppName() + "/" + rulesetPath.getRuleAppVersion()});
            }
            IlrEngineType engineType = ruleset.getProperties().getEngineType();
            if (engineType == null) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_ENGINE_TYPE_ERROR, new String[]{String.valueOf(ruleset.getProperties().get("ruleset.engine"))}, null);
            }
            IlrRulesetsTable.insert(this.configurator, tr.getConnection(), rulesetPath.getRulesetName(), rulesetPath.getRulesetVersion(), ruleAppId, ruleset);
            int rulesetId = IlrRulesetsTable.getId(this.configurator, tr.getConnection(), rulesetPath.getRulesetName(), rulesetPath.getRulesetVersion(), ruleAppId);
            if (rulesetId == -1) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND, new String[]{String.valueOf(rulesetPath)});
            }
            IlrRulesetPropertiesTable.insert(this.configurator, tr.getConnection(), rulesetId, ruleset.getProperties());
            IlrRESRulesetArchive resArchive = ruleset.getRESRulesetArchive();
            if (engineType == IlrEngineType.CRE) {
                IlrRulesetResourcesTable.insert(this.configurator, tr.getConnection(), rulesetId, IlrRESArchiveUtil.getRulesetArchiveAsStream(((IlrCRERulesetArchive)resArchive).getRulesetArchive()));
            } else if (engineType == IlrEngineType.DE) {
                IlrRulesetResourcesTable.insert(this.configurator, tr.getConnection(), rulesetId, ((IlrDERulesetArchive)resArchive).getContentStream());
            }
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.ADD_RULESET_ERROR, new String[]{String.valueOf(rulesetPath)}, e);
        }
    }

    @Override
    public void removeRuleApp(IlrPath ruleAppPath) throws IlrDAOException {
        IlrTransaction transaction = this.beginTransaction();
        try {
            this.removeRuleApp(ruleAppPath, transaction);
            transaction.commit();
        }
        catch (IlrDAOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public void removeRuleApp(IlrPath ruleAppPath, IlrTransaction transaction) throws IlrDAOException {
        if (!ruleAppPath.isCanonical() || !ruleAppPath.isRuleAppPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(ruleAppPath)});
        }
        this.removeRuleApp(ruleAppPath.getRuleAppName(), ruleAppPath.getRuleAppVersion(), transaction);
    }

    @Override
    public void removeRuleset(IlrPath rulesetPath) throws IlrDAOException {
        IlrTransaction transaction = this.beginTransaction();
        try {
            this.removeRuleset(rulesetPath, transaction);
            transaction.commit();
        }
        catch (IlrDAOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public void removeRuleset(IlrPath rulesetPath, IlrTransaction transaction) throws IlrDAOException {
        if (!rulesetPath.isCanonical() || !rulesetPath.isRulesetPath()) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.WRONG_PATH_FORMAT, new String[]{String.valueOf(rulesetPath)});
        }
        IlrJDBCTransaction tr = (IlrJDBCTransaction)transaction;
        try {
            IlrRulesetsTable.delete(this.configurator, tr.getConnection(), rulesetPath);
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.REMOVE_RULESET_ERROR, new String[]{String.valueOf(rulesetPath)}, e);
        }
    }

    @Override
    public void updateRuleApp(IlrMutableRuleAppInformation ruleApp) throws IlrDAOException, IlrResourceNotFoundDAOException {
        IlrTransaction transaction = this.beginTransaction();
        try {
            this.updateRuleApp(ruleApp, transaction);
            transaction.commit();
        }
        catch (IlrDAOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public void updateRuleApp(IlrMutableRuleAppInformation ruleApp, IlrTransaction transaction) throws IlrDAOException, IlrResourceNotFoundDAOException {
        IlrJDBCTransaction tr = (IlrJDBCTransaction)transaction;
        try {
            int ruleAppId = IlrRuleAppsTable.getId(this.configurator, tr.getConnection(), ruleApp.getName(), ruleApp.getVersion());
            if (ruleAppId == -1) {
                throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND, new String[]{String.valueOf(ruleApp)});
            }
            IlrRuleAppsTable.setDisplayNameDescription(this.configurator, tr.getConnection(), ruleAppId, ruleApp.getDisplayName(), ruleApp.getDescription());
            IlrRuleAppPropertiesTable.delete(this.configurator, tr.getConnection(), ruleAppId);
            IlrRuleAppPropertiesTable.insert(this.configurator, tr.getConnection(), ruleAppId, ruleApp.getProperties());
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.UPDATE_RULEAPP_ERROR, new String[]{String.valueOf(ruleApp)}, e);
        }
    }

    private void removeRuleApp(String name, IlrVersion version, IlrTransaction transaction) throws IlrDAOException {
        IlrJDBCTransaction tr = (IlrJDBCTransaction)transaction;
        try {
            IlrRuleAppsTable.delete(this.configurator, tr.getConnection(), name, version);
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.REMOVE_RULEAPP_ERROR, new String[]{"/" + name + "/" + version}, e);
        }
    }

    @Override
    public byte[] getRESRulesetArchiveAsBytes(IlrPath rulesetPath) throws IlrDAOException, IlrResourceNotFoundDAOException {
        return this.getRulesetArchiveData(rulesetPath).getData();
    }

    protected IlrRulesetArchiveData getRulesetArchiveData(IlrPath rulesetPath) throws IlrDAOException, IlrResourceNotFoundDAOException {
        byte[] result = null;
        IlrJDBCTransaction tr = (IlrJDBCTransaction)this.beginTransaction();
        IlrEngineType engineType = null;
        try {
            try {
                Map<String, String> properties = null;
                if (rulesetPath.isRuleAppPath()) {
                    int ruleAppId = IlrRuleAppsTable.getId(this.configurator, tr.getConnection(), rulesetPath);
                    if (ruleAppId == -1) {
                        throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULEAPP_NOT_FOUND, new String[]{String.valueOf(rulesetPath)});
                    }
                    properties = IlrRuleAppPropertiesTable.get(this.configurator, tr.getConnection(), ruleAppId);
                } else {
                    int rulesetId = IlrRulesetsTable.getId(this.configurator, tr.getConnection(), rulesetPath);
                    if (rulesetId == -1) {
                        throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND, new String[]{String.valueOf(rulesetPath)});
                    }
                    properties = IlrRulesetPropertiesTable.get(this.configurator, tr.getConnection(), rulesetId);
                }
                engineType = IlrEngineType.toEngineType(properties.get("ruleset.engine"));
            }
            catch (Exception e) {
                engineType = IlrEngineType.CRE;
            }
            result = IlrRulesetResourcesTable.get(this.configurator, tr.getConnection(), rulesetPath);
            tr.commit();
        }
        catch (Exception e) {
            tr.rollback();
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_RULESET_ARCHIVE_ERROR, new String[]{String.valueOf(rulesetPath)}, e);
        }
        finally {
            tr.close();
        }
        if (result == null) {
            throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.RULESET_NOT_FOUND, new String[]{String.valueOf(rulesetPath)});
        }
        return new IlrRulesetArchiveData(engineType, result);
    }

    @Override
    public XOMRepositoryDAO getXOMRepositoryDAO() {
        return this.xomRepository;
    }

    @Override
    public ClassLoader getManagedXOMClassLoader(IlrPath canonicalPath, ClassLoader xomcl, boolean clientFirst, boolean lazyLoading) throws IlrDAOException, IlrResourceNotFoundDAOException {
        try {
            XOMClassLoader cl = (XOMClassLoader)new XOMClassLoaderFactory().getManagedXOMClassLoader(canonicalPath, this, this.xomRepository, xomcl, clientFirst, lazyLoading);
            XOMClassLoaderFactory.displayInfoTrace(clientFirst, canonicalPath, cl.getDependencyTree());
            return cl;
        }
        catch (DAOException e) {
            throw new IlrDAOException(e);
        }
    }

    @Override
    public void setConfigParameters(Map<String, String> parameters) throws IlrDAOException {
        DAOLoader xomPersistenceLoader = new DAOLoader();
        xomPersistenceLoader.setClassLoader(this.classLoader);
        try {
            this.xomRepository = (XOMRepositoryDAO)xomPersistenceLoader.getDAO("xomPersistence", DAOLoader.XOM_PERSISTENCE_ALIAS, DAOLoader.XOM_PERSISTENCE_PROPERTY_ALIAS, parameters);
            if (this.xomRepository instanceof FileXOMRepositoryDAO) {
                this.logger.info(IlrDAOLocalization.FILE_XOM_PERSISTENCE, new Object[]{this.xomRepository.getDetails()});
            } else if (this.xomRepository instanceof GenericXOMRepositoryDAO) {
                this.logger.info(IlrDAOLocalization.DB_XOM_PERSISTENCE, new Object[]{this.xomRepository.getDetails()});
            }
        }
        catch (Throwable t) {
            this.logger.warning(IlrDAOLocalization.XOM_PERSISTENCE_NOT_SET, new Object[]{t.getMessage()}, t);
            this.xomRepository = new GenericXOMRepositoryDAO(new DAOConfigurator("XOMRepositoryDAODescriptor.xml", this.configurator.getJDBCConnectionProvider()), this.configurator.getJDBCConnectionProvider());
            this.logger.warning(IlrDAOLocalization.DEFAULT_XOM_REPOSITORY, new Object[]{"database", this.xomRepository.getDetails()}, null);
        }
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

