/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc;

import ilog.rules.res.util.xml.IlrDOMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IlrResourceProviderDescriptorReader {
    private static final String TAG_GENERIC = "generic";
    private static final String TAG_CLASS_NAME = "class-name";
    private static final String TAG_SQL_TABLES = "sql-tables";
    private static final String TAG_SQL_TABLE = "sql-table";
    private static final String TAG_COLUMN = "column";
    private static final String TAG_SQL_STATEMENTS = "sql-statements";
    private static final String TAG_SQL_STATEMENT = "sql-statement";
    private static final String TAG_SPECIFIC = "specific";
    private static final String TAG_DATABASE_PRODUCT_NAMES = "database-product-names";
    private static final String TAG_DATABASE_PRODUCT_NAME = "database-product-name";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private final Element elementGeneric;
    private final Element elementSpecific;

    public IlrResourceProviderDescriptorReader(InputStream inputStream, String databaseProductName) throws ParserConfigurationException, SAXException, IOException, NullPointerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        Document xmlDocument = docBuilder.parse(inputStream);
        this.elementGeneric = IlrResourceProviderDescriptorReader.searchElementGeneric(xmlDocument);
        this.elementSpecific = databaseProductName != null ? IlrResourceProviderDescriptorReader.searchElementSpecific(xmlDocument, databaseProductName.trim()) : null;
    }

    public String getResourceProviderClassName() {
        String specificClassName = this.getClassName(this.elementSpecific);
        if (specificClassName != null) {
            return specificClassName;
        }
        return this.getClassName(this.elementGeneric);
    }

    public Map<String, Table> getSQLTables() {
        HashMap<String, Table> sqlTables = new HashMap<String, Table>();
        this.fillSQLTables(this.elementGeneric, sqlTables);
        this.fillSQLTables(this.elementSpecific, sqlTables);
        return sqlTables;
    }

    public Map<String, String> getSQLStatements() {
        HashMap<String, String> sqlSatements = new HashMap<String, String>();
        this.fillSQLStatements(this.elementGeneric, sqlSatements);
        this.fillSQLStatements(this.elementSpecific, sqlSatements);
        return sqlSatements;
    }

    private static Element searchElementGeneric(Document xmlDocument) {
        return IlrDOMUtil.getFirstElementByTagName(xmlDocument.getDocumentElement(), TAG_GENERIC);
    }

    private static Element searchElementSpecific(Document xmlDocument, String databaseProductName) {
        NodeList specifics = IlrDOMUtil.getChildElementsByTagName(xmlDocument.getDocumentElement(), TAG_SPECIFIC);
        for (int i = 0; i < specifics.getLength(); ++i) {
            Element elementSpecific = (Element)specifics.item(i);
            Element elementDatabaseProductNames = IlrDOMUtil.getFirstElementByTagName(elementSpecific, TAG_DATABASE_PRODUCT_NAMES);
            if (elementDatabaseProductNames == null) continue;
            NodeList productNames = IlrDOMUtil.getChildElementsByTagName(elementDatabaseProductNames, TAG_DATABASE_PRODUCT_NAME);
            for (int j = 0; j < productNames.getLength(); ++j) {
                Element elementDatabaseProductName = (Element)productNames.item(j);
                String productName = elementDatabaseProductName.getAttribute(ATTR_NAME);
                if (productName == null || !productName.equalsIgnoreCase(databaseProductName)) continue;
                return elementSpecific;
            }
        }
        return null;
    }

    private String getClassName(Element database) {
        if (database == null) {
            return null;
        }
        Element elementClassName = IlrDOMUtil.getFirstElementByTagName(database, TAG_CLASS_NAME);
        if (elementClassName != null) {
            return elementClassName.getAttribute(ATTR_NAME);
        }
        return null;
    }

    private void fillSQLStatements(Element database, Map<String, String> sqlStatementsMap) {
        if (database == null) {
            return;
        }
        Element elementSQLStatements = IlrDOMUtil.getFirstElementByTagName(database, TAG_SQL_STATEMENTS);
        if (elementSQLStatements != null) {
            NodeList sqlStatements = IlrDOMUtil.getChildElementsByTagName(elementSQLStatements, TAG_SQL_STATEMENT);
            for (int i = 0; i < sqlStatements.getLength(); ++i) {
                Element elementSQLStatement = (Element)sqlStatements.item(i);
                String name = elementSQLStatement.getAttribute(ATTR_NAME);
                if (name == null || name.length() <= 0) continue;
                String value = elementSQLStatement.getAttribute(ATTR_VALUE);
                if (value != null && value.length() > 0) {
                    sqlStatementsMap.put(name, value);
                    continue;
                }
                sqlStatementsMap.remove(name);
            }
        }
    }

    private void fillSQLTables(Element database, Map<String, Table> sqlTablesMap) {
        if (database == null) {
            return;
        }
        Element elementSQLTables = IlrDOMUtil.getFirstElementByTagName(database, TAG_SQL_TABLES);
        if (elementSQLTables != null) {
            NodeList sqlTables = IlrDOMUtil.getChildElementsByTagName(elementSQLTables, TAG_SQL_TABLE);
            for (int i = 0; i < sqlTables.getLength(); ++i) {
                Element elementSQLTable = (Element)sqlTables.item(i);
                String key = elementSQLTable.getAttribute(ATTR_KEY);
                if (key == null || key.length() <= 0) continue;
                String name = elementSQLTable.getAttribute(ATTR_NAME);
                if (name != null && name.length() > 0) {
                    HashSet<String> columnsSet = new HashSet<String>();
                    NodeList columns = IlrDOMUtil.getChildElementsByTagName(elementSQLTable, TAG_COLUMN);
                    for (int j = 0; j < columns.getLength(); ++j) {
                        Element column = (Element)columns.item(j);
                        columnsSet.add(column.getAttribute(ATTR_NAME));
                    }
                    sqlTablesMap.put(key, new Table(name, columnsSet));
                    continue;
                }
                sqlTablesMap.remove(key);
            }
        }
    }

    public static class Table {
        private final String name;
        private final Set<String> columns;

        public Table(String name, Set<String> columns) {
            this.name = name;
            this.columns = columns;
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getColumns() {
            return this.columns;
        }

        public Table toUpperCase() {
            HashSet<String> resColumns = new HashSet<String>(this.columns.size());
            for (String column : this.columns) {
                resColumns.add(column.toUpperCase());
            }
            return new Table(this.name.toUpperCase(), resColumns);
        }

        public Table toLowerCase() {
            HashSet<String> resColumns = new HashSet<String>(this.columns.size());
            for (String column : this.columns) {
                resColumns.add(column.toLowerCase());
            }
            return new Table(this.name.toLowerCase(), resColumns);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Table)) {
                return false;
            }
            Table table = (Table)obj;
            return this.name.equals(table.name) && ((Object)this.columns).equals(table.columns);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.name.hashCode();
            result = 37 * result + ((Object)this.columns).hashCode();
            return result;
        }
    }
}

