/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc.helper;

import com.ibm.rules.res.logging.internal.RESLogger;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;

public class IlrDatabaseUtility {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");

    public static ResultSet executeQuery(PreparedStatement statement, String queryToLog, List<String> parameterValues) {
        boolean isFinestLoggable = LOGGER.isLoggable(Level.FINEST);
        ResultSet rs = null;
        long startTime = 0L;
        long endTime = 0L;
        try {
            if (isFinestLoggable) {
                for (String value : parameterValues) {
                    if (value != null) {
                        String literalizedValue = Matcher.quoteReplacement(value);
                        queryToLog = queryToLog.replaceFirst("\\?", literalizedValue);
                        continue;
                    }
                    queryToLog = queryToLog.replaceFirst("\\?", "null");
                }
                LOGGER.log(Level.FINEST, IlrDAOLocalization.EXECUTIONG_SQL_QUERY, new String[]{queryToLog}, null);
                startTime = System.currentTimeMillis();
            }
            rs = statement.executeQuery();
            if (isFinestLoggable) {
                endTime = System.currentTimeMillis();
                LOGGER.log(Level.FINEST, IlrDAOLocalization.PASSED_EXECUTION_TIME_ON_SUCCESS, new String[]{String.valueOf(endTime - startTime)}, null);
            }
        }
        catch (SQLException e) {
            if (isFinestLoggable) {
                endTime = System.currentTimeMillis();
                LOGGER.log(Level.FINEST, IlrDAOLocalization.PASSED_EXECUTION_TIME_ON_FAIL, new String[]{String.valueOf(endTime - startTime)}, e);
            }
            LOGGER.log(Level.WARNING, IlrDAOLocalization.ERROR_SQL_EXCEPTION, null, e);
        }
        return rs;
    }

    public static int executeUpdate(PreparedStatement statement, String queryToLog, List<String> parameterValues) {
        boolean isFinestLoggable = LOGGER.isLoggable(Level.FINEST);
        int rs = 0;
        long startTime = 0L;
        long endTime = 0L;
        try {
            if (isFinestLoggable) {
                for (String value : parameterValues) {
                    if (value != null) {
                        String literalizedValue = Matcher.quoteReplacement(value);
                        queryToLog = queryToLog.replaceFirst("\\?", literalizedValue);
                        continue;
                    }
                    queryToLog = queryToLog.replaceFirst("\\?", "null");
                }
                LOGGER.log(Level.FINEST, IlrDAOLocalization.EXECUTIONG_SQL_QUERY, new String[]{queryToLog}, null);
                startTime = System.currentTimeMillis();
            }
            rs = statement.executeUpdate();
            if (isFinestLoggable) {
                endTime = System.currentTimeMillis();
                LOGGER.log(Level.FINEST, IlrDAOLocalization.PASSED_EXECUTION_TIME_ON_SUCCESS, new String[]{String.valueOf(endTime - startTime)}, null);
            }
        }
        catch (SQLException e) {
            if (isFinestLoggable) {
                endTime = System.currentTimeMillis();
                LOGGER.log(Level.FINEST, IlrDAOLocalization.PASSED_EXECUTION_TIME_ON_FAIL, new String[]{String.valueOf(endTime - startTime)}, e);
            }
            LOGGER.log(Level.WARNING, IlrDAOLocalization.ERROR_SQL_EXCEPTION, null, e);
        }
        return rs;
    }

    public static int[] executeBatch(PreparedStatement statement, String queryToLog, Map<Integer, List<String>> parameterValues) {
        boolean isFinestLoggable = LOGGER.isLoggable(Level.FINEST);
        StringBuilder batchQuery = new StringBuilder();
        int[] updateCounts = null;
        long startTime = 0L;
        long endTime = 0L;
        try {
            if (isFinestLoggable) {
                for (Integer line : parameterValues.keySet()) {
                    String lineQuery = queryToLog;
                    for (String value : parameterValues.get(line)) {
                        if (value != null) {
                            String literalizedValue = Matcher.quoteReplacement(value);
                            lineQuery = lineQuery.replaceFirst("\\?", literalizedValue);
                            continue;
                        }
                        lineQuery = lineQuery.replaceFirst("\\?", "null");
                    }
                    batchQuery.append(lineQuery);
                    batchQuery.append("\n");
                }
                LOGGER.log(Level.FINEST, IlrDAOLocalization.EXECUTIONG_SQL_QUERY, new String[]{batchQuery.toString()}, null);
                startTime = System.currentTimeMillis();
            }
            updateCounts = statement.executeBatch();
            if (isFinestLoggable) {
                endTime = System.currentTimeMillis();
                LOGGER.log(Level.FINEST, IlrDAOLocalization.PASSED_EXECUTION_TIME_ON_SUCCESS, new String[]{String.valueOf(endTime - startTime)}, null);
            }
        }
        catch (SQLException e) {
            if (isFinestLoggable) {
                endTime = System.currentTimeMillis();
                LOGGER.log(Level.FINEST, IlrDAOLocalization.PASSED_EXECUTION_TIME_ON_FAIL, new String[]{String.valueOf(endTime - startTime)}, e);
            }
            LOGGER.log(Level.WARNING, IlrDAOLocalization.ERROR_SQL_EXCEPTION, null, e);
        }
        return updateCounts;
    }

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, IlrDAOLocalization.ERROR_CLOSE_CONNECTION, null, e);
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, IlrDAOLocalization.ERROR_CLOSE_STATEMENT, null, e);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, IlrDAOLocalization.ERROR_CLOSE_RESULTSET, null, e);
            }
        }
    }
}

