/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc.helper;

import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.IlrResourceProviderDescriptorReader;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class IlrDiagnostic {
    private static final String SQLTABLE_TRACES = "execution_traces";
    private static final String SQLTABLE_CONFIG_PARAMS = "configuration_parameters";
    private static final String SQLTABLE_RULEAPPS = "ruleapps_table";
    private static final String SQLTABLE_RULESETS = "rulesets_table";
    private static final String SQLTABLE_RULEAPP_PROPERTIES = "ruleapp_properties_table";
    private static final String SQLTABLE_RULESET_PROPERTIES = "ruleset_properties_table";
    private static final String SQLTABLE_RULESET_RESOURCES = "ruleset_resources_table";
    private static final String SQLTABLE_RS_ENABLED_VIEW = "rs_enabled_view";
    public static final String DIAG_CLASSNAME = "daoClassName";
    public static final String DIAG_DATABASE_PRODUCT_NAME = "databaseProductName";
    public static final String DIAG_DATABASE_PRODUCT_VERSION = "databaseProductVersion";
    public static final String DIAG_DRIVER_NAME = "driverName";
    public static final String DIAG_DRIVER_VERSION = "driverVersion";
    public static final String DIAG_URL = "url";
    public static final String DIAG_USERNAME = "username";
    public static final String DIAG_EXISTING_SCHEMAS = "existingSchemas";
    public static final String DIAG_SUPPORTS_TRANSACTIONS = "supportsTransactions";

    public static Properties fillMetaData(Class<?> daoClass, DatabaseMetaData metadata) throws SQLException {
        String username;
        String url;
        String driverVersion;
        String driverName;
        String databaseProductVersion;
        Properties props = new Properties();
        props.setProperty(DIAG_CLASSNAME, daoClass.getName());
        String databaseProductName = metadata.getDatabaseProductName();
        if (databaseProductName != null) {
            props.setProperty(DIAG_DATABASE_PRODUCT_NAME, databaseProductName);
        }
        if ((databaseProductVersion = metadata.getDatabaseProductVersion()) != null) {
            props.setProperty(DIAG_DATABASE_PRODUCT_VERSION, databaseProductVersion);
        }
        if ((driverName = metadata.getDriverName()) != null) {
            props.setProperty(DIAG_DRIVER_NAME, driverName);
        }
        if ((driverVersion = metadata.getDriverVersion()) != null) {
            props.setProperty(DIAG_DRIVER_VERSION, driverVersion);
        }
        if ((url = metadata.getURL()) != null) {
            props.setProperty(DIAG_URL, url);
        }
        if ((username = metadata.getUserName()) != null) {
            props.setProperty(DIAG_USERNAME, username);
        }
        StringBuffer existingSchemas = new StringBuffer();
        ResultSet schemas = metadata.getSchemas();
        int index = 0;
        while (schemas.next()) {
            if (index++ > 0) {
                existingSchemas.append(", ");
            }
            existingSchemas.append(schemas.getString(1));
        }
        if (index > 0) {
            props.setProperty(DIAG_EXISTING_SCHEMAS, existingSchemas.toString());
        }
        props.put(DIAG_SUPPORTS_TRANSACTIONS, (Object)metadata.supportsTransactions());
        return props;
    }

    public static boolean checkTracesTable(IlrDAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table tracesTable = configurator.getSQLTable(SQLTABLE_TRACES);
        boolean isCreated = IlrDiagnostic.checkTable(metadata, "TABLE", tracesTable, metadata.getUserName());
        props.put(SQLTABLE_TRACES, (Object)isCreated);
        return isCreated;
    }

    public static boolean checkConfigParametersTable(IlrDAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table configParamsTable = configurator.getSQLTable(SQLTABLE_CONFIG_PARAMS);
        boolean isCreated = IlrDiagnostic.checkTable(metadata, "TABLE", configParamsTable, metadata.getUserName());
        props.put(SQLTABLE_TRACES, (Object)isCreated);
        return isCreated;
    }

    public static boolean checkRuleAppsTable(IlrDAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table ruleAppsTable = configurator.getSQLTable(SQLTABLE_RULEAPPS);
        boolean isCreated = IlrDiagnostic.checkTable(metadata, "TABLE", ruleAppsTable, metadata.getUserName());
        props.put(SQLTABLE_RULEAPPS, (Object)isCreated);
        return isCreated;
    }

    public static boolean checkRulesetsTable(IlrDAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table rulesetsTable = configurator.getSQLTable(SQLTABLE_RULESETS);
        boolean isCreated = IlrDiagnostic.checkTable(metadata, "TABLE", rulesetsTable, metadata.getUserName());
        props.put(SQLTABLE_RULESETS, (Object)isCreated);
        return isCreated;
    }

    public static boolean checkRuleAppPropertiesTable(IlrDAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table ruleAppPropertiesTable = configurator.getSQLTable(SQLTABLE_RULEAPP_PROPERTIES);
        boolean isCreated = IlrDiagnostic.checkTable(metadata, "TABLE", ruleAppPropertiesTable, metadata.getUserName());
        props.put(SQLTABLE_RULEAPP_PROPERTIES, (Object)isCreated);
        return isCreated;
    }

    public static boolean checkRulesetPropertiesTable(IlrDAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table rulesetPropertiesTable = configurator.getSQLTable(SQLTABLE_RULESET_PROPERTIES);
        boolean isCreated = IlrDiagnostic.checkTable(metadata, "TABLE", rulesetPropertiesTable, metadata.getUserName());
        props.put(SQLTABLE_RULESET_PROPERTIES, (Object)isCreated);
        return isCreated;
    }

    public static boolean checkRulesetResourcesTable(IlrDAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table rulesetResourcesTable = configurator.getSQLTable(SQLTABLE_RULESET_RESOURCES);
        boolean isCreated = IlrDiagnostic.checkTable(metadata, "TABLE", rulesetResourcesTable, metadata.getUserName());
        props.put(SQLTABLE_RULESET_RESOURCES, (Object)isCreated);
        return isCreated;
    }

    public static boolean checkRulesetEnabledView(IlrDAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table rsEnabledView = configurator.getSQLTable(SQLTABLE_RS_ENABLED_VIEW);
        if (rsEnabledView != null) {
            boolean isCreated = IlrDiagnostic.checkTable(metadata, "VIEW", rsEnabledView, metadata.getUserName());
            props.put(SQLTABLE_RS_ENABLED_VIEW, (Object)isCreated);
            return isCreated;
        }
        return true;
    }

    private static boolean checkTable(DatabaseMetaData metadata, String type, IlrResourceProviderDescriptorReader.Table table, String username) throws SQLException {
        if (IlrDiagnostic.checkTableCreated(metadata, type, username, table)) {
            return true;
        }
        IlrResourceProviderDescriptorReader.Table tableUpperCase = table.toUpperCase();
        String usernameUpperCase = username.toUpperCase();
        IlrResourceProviderDescriptorReader.Table tableLowerCase = table.toLowerCase();
        String usernameLowerCase = username.toLowerCase();
        if (IlrDiagnostic.checkTableCreated(metadata, type, username, tableUpperCase)) {
            return true;
        }
        if (IlrDiagnostic.checkTableCreated(metadata, type, usernameLowerCase, tableUpperCase)) {
            return true;
        }
        if (IlrDiagnostic.checkTableCreated(metadata, type, usernameUpperCase, tableUpperCase)) {
            return true;
        }
        if (IlrDiagnostic.checkTableCreated(metadata, type, username, tableLowerCase)) {
            return true;
        }
        if (IlrDiagnostic.checkTableCreated(metadata, type, usernameLowerCase, tableLowerCase)) {
            return true;
        }
        if (IlrDiagnostic.checkTableCreated(metadata, type, usernameUpperCase, tableLowerCase)) {
            return true;
        }
        String productName = metadata.getDatabaseProductName();
        if (productName == null || !productName.toLowerCase().contains("derby")) {
            if (IlrDiagnostic.checkTableCreated(metadata, type, null, tableLowerCase)) {
                return true;
            }
            if (IlrDiagnostic.checkTableCreated(metadata, type, null, tableUpperCase)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkTableCreated(DatabaseMetaData metadata, String type, String username, IlrResourceProviderDescriptorReader.Table table) throws SQLException {
        ResultSet rs;
        block4: {
            block5: {
                boolean bl;
                String[] tableType = new String[]{type};
                rs = null;
                try {
                    rs = metadata.getTables(null, username, table.getName(), tableType);
                    if (!rs.next()) break block4;
                    String resTableName = rs.getString("TABLE_NAME");
                    if (resTableName == null || !resTableName.equalsIgnoreCase(table.getName())) break block5;
                    boolean columnsChecked = true;
                    for (String columnName : table.getColumns()) {
                        columnsChecked = columnsChecked && IlrDiagnostic.checkColumnCreated(metadata, username, table, columnName);
                    }
                    bl = columnsChecked;
                }
                catch (Throwable throwable) {
                    IlrDatabaseUtility.closeResultSet(rs);
                    throw throwable;
                }
                IlrDatabaseUtility.closeResultSet(rs);
                return bl;
            }
            boolean bl = false;
            IlrDatabaseUtility.closeResultSet(rs);
            return bl;
        }
        IlrDatabaseUtility.closeResultSet(rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkColumnCreated(DatabaseMetaData metadata, String username, IlrResourceProviderDescriptorReader.Table table, String columnName) throws SQLException {
        ResultSet rs;
        block3: {
            block4: {
                boolean bl;
                rs = null;
                try {
                    rs = metadata.getColumns(null, username, table.getName(), columnName);
                    if (!rs.next()) break block3;
                    String resColumnName = rs.getString("COLUMN_NAME");
                    if (resColumnName == null || !resColumnName.equalsIgnoreCase(columnName)) break block4;
                    bl = true;
                }
                catch (Throwable throwable) {
                    IlrDatabaseUtility.closeResultSet(rs);
                    throw throwable;
                }
                IlrDatabaseUtility.closeResultSet(rs);
                return bl;
            }
            boolean bl = false;
            IlrDatabaseUtility.closeResultSet(rs);
            return bl;
        }
        IlrDatabaseUtility.closeResultSet(rs);
        return false;
    }
}

