/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc.helper;

import com.ibm.rules.res.logging.internal.RESLogger;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class IlrRuleAppsTable {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");
    private static final String SQLST_SELECT_RULEAPPS = "select_ruleapps";
    private static final String SQLST_DELETE_RULEAPP = "delete_ruleapp";
    private static final String SQLST_INSERT_RULEAPP = "insert_ruleapp";
    private static final String SQLST_SELECT_RULEAPP_ID = "select_ruleapp_id";
    private static final String SQLST_UPDATE_RULEAPP_DISPLAY_NAME = "update_ruleapp_display_name";
    private static final String SQLST_UPDATE_RULEAPP_DESCRIPTION = "update_ruleapp_description";
    private static final String SQLST_UPDATE_RULEAPP_DISPLAY_NAME_DESCRIPTION_WITH_ID = "update_ruleapp_display_name_description_with_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, IlrMutableRuleAppInformation> load(IlrDAOConfigurator configurator, Connection connection, IlrRepositoryFactory repositoryFactory) throws SQLException, IlrFormatException {
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RULEAPPS);
        TreeMap<Integer, IlrMutableRuleAppInformation> ruleAppsById = new TreeMap<Integer, IlrMutableRuleAppInformation>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, new ArrayList<String>());
            while (rs != null && rs.next()) {
                int id = rs.getInt(1);
                IlrMutableRuleAppInformation ruleApp = repositoryFactory.createRuleApp(rs.getString(2), new IlrVersion(rs.getInt(3), rs.getInt(4)), new Date(rs.getLong(5)));
                ruleApp.setDisplayName(rs.getString(6));
                ruleApp.setDescription(rs.getString(7));
                ruleAppsById.put(id, ruleApp);
            }
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return ruleAppsById;
    }

    public static int getId(IlrDAOConfigurator configurator, Connection connection, IlrPath path) throws SQLException {
        return IlrRuleAppsTable.getId(configurator, connection, path.getRuleAppName(), path.getRuleAppVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getId(IlrDAOConfigurator configurator, Connection connection, String name, IlrVersion version) throws SQLException {
        ResultSet rs;
        PreparedStatement statement;
        block4: {
            int n;
            String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RULEAPP_ID);
            statement = null;
            rs = null;
            try {
                statement = connection.prepareStatement(sqlStatement);
                statement.setString(1, name);
                statement.setInt(2, version.getMajor());
                statement.setInt(3, version.getMinor());
                ArrayList<String> parameterValues = new ArrayList<String>();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    parameterValues.add(name);
                    parameterValues.add(String.valueOf(version.getMajor()));
                    parameterValues.add(String.valueOf(version.getMinor()));
                }
                if (!(rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues)).next()) break block4;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                IlrDatabaseUtility.closeStatement(statement);
                IlrDatabaseUtility.closeResultSet(rs);
                throw throwable;
            }
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            return n;
        }
        int n = -1;
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insert(IlrDAOConfigurator configurator, Connection connection, IlrMutableRuleAppInformation ruleApp) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_RULEAPP);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, ruleApp.getName());
            IlrVersion version = ruleApp.getVersion();
            statement.setInt(2, version.getMajor());
            statement.setInt(3, version.getMinor());
            statement.setLong(4, ruleApp.getCreationDate().getTime());
            statement.setString(5, ruleApp.getDisplayName());
            statement.setString(6, ruleApp.getDescription());
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(ruleApp.getName());
                parameterValues.add(String.valueOf(version.getMajor()));
                parameterValues.add(String.valueOf(version.getMinor()));
                parameterValues.add(String.valueOf(ruleApp.getCreationDate().getTime()));
                parameterValues.add(ruleApp.getDisplayName());
                parameterValues.add(ruleApp.getDescription());
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(IlrDAOConfigurator configurator, Connection connection, String name, IlrVersion version) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_RULEAPP);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, name);
            statement.setInt(2, version.getMajor());
            statement.setInt(3, version.getMinor());
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(name);
                parameterValues.add(String.valueOf(version.getMajor()));
                parameterValues.add(String.valueOf(version.getMinor()));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDisplayName(IlrDAOConfigurator configurator, Connection connection, IlrPath path, String displayName) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_UPDATE_RULEAPP_DISPLAY_NAME);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, displayName);
            statement.setString(2, path.getRuleAppName());
            IlrVersion version = path.getRuleAppVersion();
            statement.setInt(3, version.getMajor());
            statement.setInt(4, version.getMinor());
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(displayName);
                parameterValues.add(path.getRuleAppName());
                parameterValues.add(String.valueOf(version.getMajor()));
                parameterValues.add(String.valueOf(version.getMinor()));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDescription(IlrDAOConfigurator configurator, Connection connection, IlrPath path, String description) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_UPDATE_RULEAPP_DESCRIPTION);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, description);
            statement.setString(2, path.getRuleAppName());
            IlrVersion version = path.getRuleAppVersion();
            statement.setInt(3, version.getMajor());
            statement.setInt(4, version.getMinor());
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(description);
                parameterValues.add(path.getRuleAppName());
                parameterValues.add(String.valueOf(version.getMajor()));
                parameterValues.add(String.valueOf(version.getMinor()));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDisplayNameDescription(IlrDAOConfigurator configurator, Connection connection, int id, String displayName, String description) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_UPDATE_RULEAPP_DISPLAY_NAME_DESCRIPTION_WITH_ID);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, displayName);
            statement.setString(2, description);
            statement.setInt(3, id);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(displayName);
                parameterValues.add(description);
                parameterValues.add(String.valueOf(id));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    public static class RuleAppItem {
        private final int ruleAppId;
        private final IlrMutableRuleAppInformation ruleApp;

        private RuleAppItem(int ruleAppId, IlrMutableRuleAppInformation ruleApp) {
            this.ruleAppId = ruleAppId;
            this.ruleApp = ruleApp;
        }

        public int getRuleAppId() {
            return this.ruleAppId;
        }

        public IlrMutableRuleAppInformation getRuleApp() {
            return this.ruleApp;
        }
    }
}

