/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc.helper;

import com.ibm.rules.res.logging.internal.RESLogger;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public class IlrRulesetPropertiesTable {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");
    private static final String SQLST_SELECT_RULESET_PROPERTIES = "select_ruleset_properties";
    private static final String SQLST_DELETE_RULESET_PROPERTY = "delete_ruleset_property";
    private static final String SQLST_INSERT_RULESET_PROPERTY = "insert_ruleset_property";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> get(IlrDAOConfigurator configurator, Connection connection, int rulesetId) throws SQLException {
        HashMap<String, String> hashMap;
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RULESET_PROPERTIES);
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setInt(1, rulesetId);
            HashMap<String, String> props = new HashMap<String, String>();
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(rulesetId));
            }
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues);
            while (rs.next()) {
                String value = rs.getString(2);
                if (value == null) {
                    value = "";
                }
                props.put(rs.getString(1), value);
            }
            hashMap = props;
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insert(IlrDAOConfigurator configurator, Connection connection, int rulesetId, String key, String value) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_RULESET_PROPERTY);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setInt(1, rulesetId);
            statement.setString(2, key);
            statement.setString(3, value);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(rulesetId));
                parameterValues.add(key);
                parameterValues.add(value);
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(IlrDAOConfigurator configurator, Connection connection, int rulesetId, IlrRulesetArchiveProperties props) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_RULESET_PROPERTY);
        PreparedStatement statement = null;
        try {
            String uuid;
            ArrayList<String> lineValues;
            statement = connection.prepareStatement(sqlStatement);
            HashMap<Integer, List<String>> parameterValues = new HashMap<Integer, List<String>>();
            int line = 0;
            if (!props.keySet().contains("ruleset.status")) {
                statement.setInt(1, rulesetId);
                statement.setString(2, "ruleset.status");
                statement.setString(3, "enabled");
                statement.addBatch();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    lineValues = new ArrayList<String>();
                    lineValues.add(String.valueOf(rulesetId));
                    lineValues.add("ruleset.status");
                    lineValues.add("enabled");
                    parameterValues.put(line, lineValues);
                    ++line;
                }
            }
            for (Map.Entry entry : props.entrySet()) {
                statement.setInt(1, rulesetId);
                statement.setString(2, (String)entry.getKey());
                statement.setString(3, (String)entry.getValue());
                statement.addBatch();
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                ArrayList<String> lineValues2 = new ArrayList<String>();
                lineValues2.add(String.valueOf(rulesetId));
                lineValues2.add((String)entry.getKey());
                lineValues2.add((String)entry.getValue());
                parameterValues.put(line, lineValues2);
                ++line;
            }
            if (props.getEngineType().equals((Object)IlrEngineType.DE) && ((uuid = (String)props.get("ruleset.uuid")) == null || uuid.isEmpty())) {
                uuid = UUID.randomUUID().toString();
                statement.setInt(1, rulesetId);
                statement.setString(2, "ruleset.uuid");
                statement.setString(3, uuid);
                statement.addBatch();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    lineValues = new ArrayList();
                    lineValues.add(String.valueOf(rulesetId));
                    lineValues.add("ruleset.uuid");
                    lineValues.add(uuid);
                    parameterValues.put(line, lineValues);
                    ++line;
                }
            }
            IlrDatabaseUtility.executeBatch(statement, sqlStatement, parameterValues);
        }
        finally {
            statement.clearBatch();
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(IlrDAOConfigurator configurator, Connection connection, String key, int rulesetId) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_RULESET_PROPERTY);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, key);
            statement.setInt(2, rulesetId);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(key);
                parameterValues.add(String.valueOf(rulesetId));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }
}

