/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc.helper;

import com.ibm.rules.res.logging.internal.RESLogger;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

public class IlrRulesetsTable {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");
    private static final String SQLST_SELECT_RULESETS = "select_rulesets";
    private static final String SQLST_SELECT_RULESET_ID_WITH_RULEAPP_ID = "select_ruleset_id_with_ruleapp_id";
    private static final String SQLST_DELETE_RULESET = "delete_ruleset";
    private static final String SQLST_INSERT_RULESET = "insert_ruleset";
    private static final String SQLST_SELECT_RULESET_ID = "select_ruleset_id";
    private static final String SQLST_UPDATE_RULESET_DISPLAY_NAME = "update_ruleset_display_name";
    private static final String SQLST_UPDATE_RULESET_DESCRIPTION = "update_ruleset_description";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RulesetItem> load(IlrDAOConfigurator configurator, Connection connection, IlrRepositoryFactory repositoryFactory) throws SQLException, IlrFormatException {
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RULESETS);
        ArrayList<RulesetItem> rulesets = new ArrayList<RulesetItem>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, new ArrayList<String>());
            while (rs.next()) {
                int ruleAppId = rs.getInt(1);
                String name = rs.getString(2);
                IlrVersion version = new IlrVersion(rs.getInt(3), rs.getInt(4));
                Date creationDate = new Date(rs.getLong(5));
                IlrMutableRulesetArchiveInformation ruleset = repositoryFactory.createRuleset(name, version, creationDate);
                ruleset.setDisplayName(rs.getString(6));
                ruleset.setDescription(rs.getString(7));
                rulesets.add(new RulesetItem(ruleAppId, ruleset));
            }
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return rulesets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getId(IlrDAOConfigurator configurator, Connection connection, IlrPath path) throws SQLException {
        ResultSet rs;
        PreparedStatement statement;
        block4: {
            int n;
            String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RULESET_ID);
            statement = null;
            rs = null;
            try {
                statement = connection.prepareStatement(sqlStatement);
                statement.setString(1, path.getRuleAppName());
                IlrVersion raversion = path.getRuleAppVersion();
                statement.setInt(2, raversion.getMajor());
                statement.setInt(3, raversion.getMinor());
                statement.setString(4, path.getRulesetName());
                IlrVersion rsversion = path.getRulesetVersion();
                statement.setInt(5, rsversion.getMajor());
                statement.setInt(6, rsversion.getMinor());
                ArrayList<String> parameterValues = new ArrayList<String>();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    parameterValues.add(path.getRuleAppName());
                    parameterValues.add(String.valueOf(raversion.getMajor()));
                    parameterValues.add(String.valueOf(raversion.getMinor()));
                    parameterValues.add(path.getRulesetName());
                    parameterValues.add(String.valueOf(rsversion.getMajor()));
                    parameterValues.add(String.valueOf(rsversion.getMinor()));
                }
                if (!(rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues)).next()) break block4;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                IlrDatabaseUtility.closeStatement(statement);
                IlrDatabaseUtility.closeResultSet(rs);
                throw throwable;
            }
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            return n;
        }
        int n = -1;
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getId(IlrDAOConfigurator configurator, Connection connection, String name, IlrVersion version, int ruleAppId) throws SQLException {
        ResultSet rs;
        PreparedStatement statement;
        block4: {
            int n;
            String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RULESET_ID_WITH_RULEAPP_ID);
            statement = null;
            rs = null;
            try {
                statement = connection.prepareStatement(sqlStatement);
                statement.setString(1, name);
                statement.setInt(2, version.getMajor());
                statement.setInt(3, version.getMinor());
                statement.setInt(4, ruleAppId);
                ArrayList<String> parameterValues = new ArrayList<String>();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    parameterValues.add(name);
                    parameterValues.add(String.valueOf(version.getMajor()));
                    parameterValues.add(String.valueOf(version.getMinor()));
                    parameterValues.add(String.valueOf(ruleAppId));
                }
                if (!(rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues)).next()) break block4;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                IlrDatabaseUtility.closeStatement(statement);
                IlrDatabaseUtility.closeResultSet(rs);
                throw throwable;
            }
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            return n;
        }
        int n = -1;
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insert(IlrDAOConfigurator configurator, Connection connection, String name, IlrVersion version, int ruleAppId, IlrMutableRulesetArchiveInformation ruleset) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_RULESET);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, name);
            statement.setInt(2, version.getMajor());
            statement.setInt(3, version.getMinor());
            statement.setLong(4, ruleset.getCreationDate().getTime());
            statement.setString(5, ruleset.getDisplayName());
            statement.setString(6, ruleset.getDescription());
            statement.setInt(7, ruleAppId);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(name);
                parameterValues.add(String.valueOf(version.getMajor()));
                parameterValues.add(String.valueOf(version.getMinor()));
                parameterValues.add(String.valueOf(ruleset.getCreationDate().getTime()));
                parameterValues.add(ruleset.getDisplayName());
                parameterValues.add(ruleset.getDescription());
                parameterValues.add(String.valueOf(ruleAppId));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(IlrDAOConfigurator configurator, Connection connection, IlrPath path) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_RULESET);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, path.getRuleAppName());
            IlrVersion raversion = path.getRuleAppVersion();
            statement.setInt(2, raversion.getMajor());
            statement.setInt(3, raversion.getMinor());
            statement.setString(4, path.getRulesetName());
            IlrVersion rsversion = path.getRulesetVersion();
            statement.setInt(5, rsversion.getMajor());
            statement.setInt(6, rsversion.getMinor());
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(path.getRuleAppName());
                parameterValues.add(String.valueOf(raversion.getMajor()));
                parameterValues.add(String.valueOf(raversion.getMinor()));
                parameterValues.add(path.getRulesetName());
                parameterValues.add(String.valueOf(rsversion.getMajor()));
                parameterValues.add(String.valueOf(rsversion.getMinor()));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDisplayName(IlrDAOConfigurator configurator, Connection connection, IlrPath path, String displayName) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_UPDATE_RULESET_DISPLAY_NAME);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, displayName);
            statement.setString(2, path.getRuleAppName());
            IlrVersion raversion = path.getRuleAppVersion();
            statement.setInt(3, raversion.getMajor());
            statement.setInt(4, raversion.getMinor());
            statement.setString(5, path.getRulesetName());
            IlrVersion rsversion = path.getRulesetVersion();
            statement.setInt(6, rsversion.getMajor());
            statement.setInt(7, rsversion.getMinor());
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(displayName);
                parameterValues.add(path.getRuleAppName());
                parameterValues.add(String.valueOf(raversion.getMajor()));
                parameterValues.add(String.valueOf(raversion.getMinor()));
                parameterValues.add(path.getRulesetName());
                parameterValues.add(String.valueOf(rsversion.getMajor()));
                parameterValues.add(String.valueOf(rsversion.getMinor()));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDescription(IlrDAOConfigurator configurator, Connection connection, IlrPath path, String description) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_UPDATE_RULESET_DESCRIPTION);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, description);
            statement.setString(2, path.getRuleAppName());
            IlrVersion raversion = path.getRuleAppVersion();
            statement.setInt(3, raversion.getMajor());
            statement.setInt(4, raversion.getMinor());
            statement.setString(5, path.getRulesetName());
            IlrVersion rsversion = path.getRulesetVersion();
            statement.setInt(6, rsversion.getMajor());
            statement.setInt(7, rsversion.getMinor());
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(description);
                parameterValues.add(path.getRuleAppName());
                parameterValues.add(String.valueOf(raversion.getMajor()));
                parameterValues.add(String.valueOf(raversion.getMinor()));
                parameterValues.add(path.getRulesetName());
                parameterValues.add(String.valueOf(rsversion.getMajor()));
                parameterValues.add(String.valueOf(rsversion.getMinor()));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    public static class RulesetItem {
        private final int ruleAppId;
        private final IlrMutableRulesetArchiveInformation ruleset;

        private RulesetItem(int ruleAppId, IlrMutableRulesetArchiveInformation ruleset) {
            this.ruleAppId = ruleAppId;
            this.ruleset = ruleset;
        }

        public int getRuleAppId() {
            return this.ruleAppId;
        }

        public IlrMutableRulesetArchiveInformation getRuleset() {
            return this.ruleset;
        }
    }
}

