/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace;

import com.ibm.rules.res.message.internal.LocalizedMessage;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import ilog.rules.res.util.lang.IlrClassPrivilegedAction;
import java.util.Locale;

public class IlrTraceDAOException
extends Exception
implements LocalizedMessage {
    private static final long serialVersionUID = 1L;
    private final String resourceBundleName;
    private final String messageCode;
    private final String[] messageParams;

    public IlrTraceDAOException() {
        this.resourceBundleName = null;
        this.messageCode = null;
        this.messageParams = null;
    }

    public IlrTraceDAOException(String s) {
        super(s);
        this.messageCode = s;
        this.resourceBundleName = null;
        this.messageParams = null;
    }

    public IlrTraceDAOException(String s, Throwable throwable) {
        super(s, throwable);
        this.messageCode = s;
        this.resourceBundleName = null;
        this.messageParams = null;
    }

    public IlrTraceDAOException(Throwable throwable) {
        super(throwable);
        this.messageCode = null;
        this.resourceBundleName = null;
        this.messageParams = null;
    }

    public IlrTraceDAOException(String resourceBundleName, String messageCode, String[] messageParams, Throwable cause) {
        super(messageCode, cause);
        this.resourceBundleName = resourceBundleName;
        this.messageCode = messageCode;
        this.messageParams = messageParams;
    }

    public IlrTraceDAOException(String resourceBundleName, String messageCode, String[] messageParams) {
        super(messageCode);
        this.resourceBundleName = resourceBundleName;
        this.messageCode = messageCode;
        this.messageParams = messageParams;
    }

    @Override
    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    @Override
    public String getMessageCode() {
        return this.messageCode;
    }

    public String[] getMessageParameters() {
        return this.messageParams;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        if (this.resourceBundleName != null) {
            ClassLoader cl = IlrClassPrivilegedAction.getClassLoader(this.getClass());
            return LocalizedMessageHelper.getLocalizedMessage(this.resourceBundleName, this.messageCode, this.messageParams, locale, cl);
        }
        return this.messageCode != null ? this.messageCode : super.getMessage();
    }
}

