/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl.jdbc;

import ilog.rules.res.model.trace.IlrDWTrace;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrDiagnosticResult;
import ilog.rules.res.persistence.impl.IlrDiagnosticResultImpl;
import ilog.rules.res.persistence.impl.IlrTraceQueryImpl;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.IlrGenericDAOBase;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCTransaction;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDiagnostic;
import ilog.rules.res.persistence.trace.IlrTraceDAO;
import ilog.rules.res.persistence.trace.IlrTraceDAOException;
import ilog.rules.res.persistence.trace.IlrTraceIterator;
import ilog.rules.res.persistence.trace.IlrTraceQuery;
import ilog.rules.res.persistence.trace.impl.IlrTraceLocalization;
import ilog.rules.res.persistence.trace.impl.jdbc.IlrTracesTable;
import ilog.rules.res.session.IlrSessionRequest;
import ilog.rules.res.session.IlrSessionResponse;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class IlrGenericTraceDAO
extends IlrGenericDAOBase
implements IlrTraceDAO {
    protected final IlrTracesTable table;
    protected IlrJDBCTransaction transaction;

    public IlrGenericTraceDAO(IlrDAOConfigurator configurator, IlrJDBCConnectionProvider connectionProvider) {
        super(configurator, connectionProvider, "trace_");
        boolean isSybase = configurator == null ? false : "sybase".equals(this.getMatchingSchemaName());
        this.table = this.createTraceTable(isSybase);
    }

    protected IlrTracesTable createTraceTable(boolean isSybase) {
        return new IlrTracesTable(isSybase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IlrDiagnosticResult executeDiagnostic() {
        Connection connection = null;
        try {
            connection = this.connectionProvider.getConnection();
            DatabaseMetaData metadata = connection.getMetaData();
            Properties props = IlrDiagnostic.fillMetaData(this.getClass(), metadata);
            boolean c1 = IlrDiagnostic.checkTracesTable(this.configurator, metadata, props);
            IlrDiagnosticResultImpl ilrDiagnosticResultImpl = new IlrDiagnosticResultImpl(props, c1);
            return ilrDiagnosticResultImpl;
        }
        catch (Exception e) {
            IlrDiagnosticResultImpl ilrDiagnosticResultImpl = new IlrDiagnosticResultImpl(e);
            return ilrDiagnosticResultImpl;
        }
        finally {
            IlrDatabaseUtility.closeConnection(connection);
        }
    }

    @Override
    public void saveTrace(IlrDWTrace trace, IlrSessionRequest request, IlrSessionResponse response) throws IlrTraceDAOException {
        try {
            this.table.insert(this.configurator, this.getTransaction().getConnection(), trace);
        }
        catch (IlrTraceDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.SAVE_TRACE_ERROR, e);
        }
    }

    @Override
    public IlrTraceIterator findAllTraces() throws IlrTraceDAOException {
        try {
            List<String> allTraceIDs = this.table.selectAll(this.configurator, this.getTransaction().getConnection());
            return new IlrJDBCTraceIterator(allTraceIDs);
        }
        catch (SQLException e) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.FIND_ALL_TRACES_ERROR, e);
        }
    }

    @Override
    public void deleteAllTraces() throws IlrTraceDAOException {
        try {
            this.table.deleteAll(this.configurator, this.getTransaction().getConnection());
        }
        catch (SQLException e) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.DELETE_TRACES_ERROR, e);
        }
    }

    @Override
    public void deleteTraces(IlrTraceQuery query) throws IlrTraceDAOException {
        if (!(query instanceof IlrTraceQueryImpl)) {
            String queryClass = query.getClass().getName();
            String daoToString = this.toString();
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.INVALID_QUERY_TYPE, new String[]{queryClass, daoToString});
        }
        try {
            this.table.delete((IlrTraceQueryImpl)query, this.configurator, this.getTransaction().getConnection());
        }
        catch (Exception e) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.DELETE_TRACES_ERROR, e);
        }
    }

    @Override
    public IlrTraceQuery createQuery() {
        return new IlrTraceQueryImpl();
    }

    @Override
    public IlrTraceIterator findTraces(IlrTraceQuery query) throws IlrTraceDAOException {
        if (!(query instanceof IlrTraceQueryImpl)) {
            String queryClass = query.getClass().getName();
            String daoToString = this.toString();
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.INVALID_QUERY_TYPE, new String[]{queryClass, daoToString});
        }
        try {
            List<String> traceIDs = this.table.findTraces((IlrTraceQueryImpl)query, this.configurator, this.getTransaction().getConnection());
            return new IlrJDBCTraceIterator(traceIDs);
        }
        catch (SQLException e) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.FIND_TRACES_ERROR, e);
        }
    }

    @Override
    public IlrDWTrace findByExecutionId(String executionId) throws IlrTraceDAOException {
        if (executionId == null) {
            return null;
        }
        try {
            return this.table.findTraceById(executionId, this.configurator, this.getTransaction().getConnection());
        }
        catch (SQLException e) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.FIND_TRACES_ERROR, e);
        }
    }

    @Override
    public void beginTransaction() throws IlrTraceDAOException {
        IlrJDBCTransaction transaction = null;
        try {
            transaction = new IlrJDBCTransaction(this.connectionProvider);
            transaction.begin();
        }
        catch (IlrDAOException e) {
            if (transaction != null) {
                transaction.close();
            }
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.UNABLE_TO_CREATE_TRANSACTION, e);
        }
        this.transaction = transaction;
    }

    @Override
    public void executeSQL(String sqlStatement) throws IlrDAOException {
        try {
            this.beginTransaction();
        }
        catch (IlrTraceDAOException e) {
            throw IlrTraceLocalization.newIlrDAOException(IlrTraceLocalization.UNABLE_TO_CREATE_TRANSACTION, e);
        }
        Statement statement = null;
        try {
            statement = this.transaction.getConnection().createStatement();
            statement.execute(sqlStatement);
            this.commit();
        }
        catch (Exception e) {
            try {
                this.rollback();
                throw IlrTraceLocalization.newIlrDAOException(IlrTraceLocalization.EXECUTE_SQL_ERROR, new String[]{sqlStatement}, e);
            }
            catch (Throwable throwable) {
                IlrDatabaseUtility.closeStatement(statement);
                this.close();
                throw throwable;
            }
        }
        IlrDatabaseUtility.closeStatement(statement);
        this.close();
    }

    private IlrJDBCTransaction getTransaction() throws IlrTraceDAOException {
        if (this.transaction == null) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.NO_ENCLOSING_TRANSACTION);
        }
        return this.transaction;
    }

    @Override
    public void commit() throws IlrTraceDAOException {
        try {
            this.getTransaction().commit();
        }
        catch (IlrDAOException e) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.COMMIT_TRANSACTION_ERROR, e);
        }
        this.close();
    }

    @Override
    public void rollback() {
        if (this.transaction != null) {
            this.transaction.rollback();
        }
        this.close();
    }

    @Override
    public void close() {
        if (this.transaction != null) {
            this.transaction.close();
        }
        this.transaction = null;
    }

    private class IlrJDBCTraceIterator
    implements IlrTraceIterator {
        private final List<String> ids;
        private ListIterator<String> currentPos;

        public IlrJDBCTraceIterator(List<String> ids) {
            this.ids = ids;
            this.currentPos = ids.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentPos.hasNext();
        }

        @Override
        public IlrDWTrace next() {
            String id = this.currentPos.next();
            return this.getTrace(id);
        }

        public IlrDWTrace getTrace(String traceId) {
            IlrDWTrace trace = null;
            try {
                trace = IlrGenericTraceDAO.this.findByExecutionId(traceId);
            }
            catch (IlrTraceDAOException e) {
                throw new RuntimeException(e);
            }
            return trace;
        }

        @Override
        public boolean absolute(int index) {
            try {
                this.currentPos = this.ids.listIterator(index);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public boolean relative(int rows) {
            int index;
            int current = 0;
            if (this.currentPos.hasNext()) {
                current = this.currentPos.nextIndex();
            }
            if ((index = current + rows) < 0) {
                return false;
            }
            this.currentPos = this.ids.listIterator(index);
            return true;
        }

        @Override
        public int size() {
            return this.ids.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

