/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl.jdbc;

import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.persistence.trace.IlrTraceDAO;
import ilog.rules.res.persistence.trace.IlrTraceDAOException;
import ilog.rules.res.persistence.trace.IlrTraceDAOFactory;
import ilog.rules.res.persistence.trace.impl.IlrTraceLocalization;
import ilog.rules.res.persistence.trace.impl.jdbc.IlrGenericTraceDAO;
import java.util.Map;

public abstract class IlrGenericTraceDAOFactory
implements IlrTraceDAOFactory {
    public static final String TRACE_DAO_JDBC_DESCRIPTOR_FILE = "traceDAODescriptorFile";
    public static final String DEFAULT_TRACE_DAO_JDBC_DESCRIPTOR_FILE = "/ilog/rules/res/persistence/trace/impl/jdbc/TraceDAODescriptor.xml";
    protected IlrDAOConfigurator configurator;
    protected IlrJDBCConnectionProvider connectionProvider;
    protected Map<String, String> initProperties;

    @Override
    public void initialize(Map<String, String> properties) throws IlrTraceDAOException {
        this.initProperties = properties;
        try {
            this.connectionProvider = this.initializeConnectionProvider(properties);
            this.configurator = this.initializeConfigurator(properties);
        }
        catch (IlrDAOException e) {
            throw IlrTraceLocalization.newIlrTraceDAOException(e);
        }
    }

    protected abstract IlrJDBCConnectionProvider initializeConnectionProvider(Map<String, String> var1) throws IlrDAOException;

    protected IlrDAOConfigurator initializeConfigurator(Map<String, String> properties) throws IlrDAOException {
        return IlrDAOConfigurator.createInstance(this.getDAODescriptor(properties), this.connectionProvider);
    }

    @Override
    public IlrTraceDAO createDAO() throws IlrTraceDAOException {
        return new IlrGenericTraceDAO(this.configurator, this.connectionProvider);
    }

    protected String getDAODescriptor(Map<String, String> props) throws IlrDAOException {
        String descFromConfig = props.get(TRACE_DAO_JDBC_DESCRIPTOR_FILE);
        return descFromConfig != null ? descFromConfig : DEFAULT_TRACE_DAO_JDBC_DESCRIPTOR_FILE;
    }
}

