/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl.jdbc;

import ilog.rules.res.model.trace.IlrDWTrace;
import ilog.rules.res.session.ruleset.IlrExecutionEvent;
import ilog.rules.res.session.ruleset.IlrExecutionTrace;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.session.ruleset.impl.IlrExecutionTraceImpl;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class IlrTraceUtility {
    IlrTraceUtility() {
    }

    public static IlrExecutionTrace getExecTraceWithOnlyExcutionEvents(IlrExecutionTrace trace) {
        List<IlrExecutionEvent> events = trace.getExecutionEvents();
        if (events == null) {
            return null;
        }
        IlrExecutionTraceImpl result = new IlrExecutionTraceImpl();
        result.setExecutionEvents(events);
        return result;
    }

    public static IlrExecutionTrace getExecTraceWithAllExceptExecutionEvents(IlrDWTrace trace) {
        return new IlrExecutionTraceWithNoExecutionEvents(trace);
    }

    public static final class IlrExecutionTraceWithNoExecutionEvents
    implements IlrExecutionTrace {
        private final IlrDWTrace trace;
        private static final long serialVersionUID = 1L;

        private IlrExecutionTraceWithNoExecutionEvents(IlrDWTrace trace) {
            this.trace = trace;
        }

        @Override
        public Long getTotalRulesFired() {
            return this.trace.getTotalRulesFired();
        }

        @Override
        public Long getTotalRulesNotFired() {
            return this.trace.getTotalRulesNotFired();
        }

        @Override
        public Long getTotalTasksExecuted() {
            return this.trace.getTotalTasksExecuted();
        }

        @Override
        public Long getTotalTasksNotExecuted() {
            return this.trace.getTotalTasksNotExecuted();
        }

        @Override
        public Date getExecutionDate() {
            return this.trace.getExecutionDate();
        }

        @Override
        public Long getExecutionDuration() {
            return this.trace.getExecutionDuration();
        }

        @Override
        public Collection<Object> getWorkingMemory() {
            return this.trace.getWorkingMemory();
        }

        @Override
        public Set<IlrRuleInformation> getRulesNotFired() {
            return this.trace.getRulesNotFired();
        }

        @Override
        public Set<IlrTaskInformation> getTasksNotExecuted() {
            return this.trace.getTasksNotExecuted();
        }

        @Override
        public Map<String, IlrRuleInformation> getRules() {
            return this.trace.getRules();
        }

        @Override
        public Map<String, IlrTaskInformation> getTasks() {
            return this.trace.getTasks();
        }

        @Override
        public List<IlrExecutionEvent> getExecutionEvents() {
            return null;
        }

        @Override
        public InetAddress getInetAddress() {
            return this.trace.getInetAddress();
        }

        @Override
        public Properties getSystemProperties() {
            return this.trace.getSystemProperties();
        }
    }
}

