/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl.jdbc;

import com.ibm.rules.res.logging.internal.RESLogger;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.trace.IlrDWTrace;
import ilog.rules.res.persistence.impl.IlrTraceQueryImpl;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import ilog.rules.res.persistence.trace.impl.jdbc.IlrTraceUtility;
import ilog.rules.res.persistence.trace.impl.jdbc.TracesSQLWriter;
import ilog.rules.res.persistence.trace.impl.sql.IlrPreparedStatementPart;
import ilog.rules.res.session.ruleset.IlrExecutionTrace;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.session.ruleset.impl.IlrExecutionTraceImpl;
import ilog.rules.res.session.util.IlrXMLExecutionTraceDeserializer;
import ilog.rules.res.session.util.IlrXMLExecutionTraceSerializer;
import ilog.rules.res.trace.IlrDWTraceImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class IlrTracesTable {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");
    protected static final int EXECUTION_EVENTS_COLUMN_INDEX = 16;
    protected static final String UTF8 = "UTF-8";
    private static final String SQLST_INSERT_TRACE = "insert_trace";
    private static final String SQLST_DELETE_ALL_TRACES = "delete_all_traces";
    private static final String SQLST_SELECT_ALL_ID = "select_all_identifiers";
    private static final String SQLST_SELECT_ALL_ID_BEGIN = "select_all_identifiers_begin";
    private static final String SQLST_SELECT_ALL_ID_END = "select_all_identifiers_end";
    private static final String SQLST_SELECT_ALL_ID_ORDER = "select_all_identifiers_order";
    private static final String SQLST_SELECT_TRACE_BY_ID = "select_trace_by_id";
    private final boolean isSybase;

    public IlrTracesTable(boolean isSybase) {
        this.isSybase = isSybase;
    }

    public boolean insert(IlrDAOConfigurator configurator, Connection connection, IlrDWTrace trace) throws Exception {
        String rsPropsString = this.propertiesToString(trace.getRulesetProperties());
        String inputParams = this.mapToString(trace.getInputParameters());
        String outputParams = this.mapToString(trace.getOutputParameters());
        String allRules = this.toStringRules(trace.getRules());
        String allTasks = this.toStringTasks(trace.getTasks());
        Long execDateLong = this.computeExecDateMillis(trace);
        String inetAddressStr = this.compueInetAddressString(trace);
        String requestPathStr = this.computeRequestPathString(trace);
        String executedPathStr = this.computeExecutedPathString(trace);
        String xmlExecutionTraceNoEvents = new IlrXMLExecutionTraceSerializer(IlrTraceUtility.getExecTraceWithAllExceptExecutionEvents(trace)).getXMLString();
        IlrExecutionTrace traceWithEventsOnly = IlrTraceUtility.getExecTraceWithOnlyExcutionEvents(trace);
        String xmlExecutionEvents = traceWithEventsOnly == null ? null : new IlrXMLExecutionTraceSerializer(traceWithEventsOnly).getXMLString();
        return this.callInsertStatement(configurator, connection, trace, rsPropsString, inputParams, outputParams, allRules, allTasks, execDateLong, inetAddressStr, requestPathStr, executedPathStr, xmlExecutionEvents, xmlExecutionTraceNoEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean callInsertStatement(IlrDAOConfigurator configurator, Connection connection, IlrDWTrace trace, String rsPropsString, String inputParams, String outputParams, String allRules, String allTasks, Long execDateLong, String inetAddressStr, String requestPathStr, String executedPathStr, String xmlExecutionEvents, String xmlExecutionTraceNoEvents) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_TRACE);
        PreparedStatement statement = connection.prepareStatement(sqlStatement);
        try {
            this.setLongNullCheck(statement, execDateLong, 1);
            statement.setString(2, inetAddressStr);
            statement.setString(3, requestPathStr);
            statement.setString(4, executedPathStr);
            this.setCharacterStreamNullCheck(statement, rsPropsString, 5);
            this.setCharacterStreamNullCheck(statement, trace.getUserData(), 6);
            this.setLongNullCheck(statement, trace.getExecutionDuration(), 7);
            this.setLongNullCheck(statement, trace.getTotalRules(), 8);
            this.setLongNullCheck(statement, trace.getTotalRulesFired(), 9);
            this.setLongNullCheck(statement, trace.getTotalRulesNotFired(), 10);
            this.setLongNullCheck(statement, trace.getTotalTasks(), 11);
            this.setLongNullCheck(statement, trace.getTotalTasksExecuted(), 12);
            this.setLongNullCheck(statement, trace.getTotalTasksNotExecuted(), 13);
            this.setCharacterStreamNullCheck(statement, allRules, 14);
            this.setCharacterStreamNullCheck(statement, allTasks, 15);
            this.setExecutionEventsColumnValue(xmlExecutionEvents, statement);
            this.setCharacterStreamNullCheck(statement, trace.getExecutionOutput(), 17);
            this.setCharacterStreamNullCheck(statement, inputParams, 18);
            this.setCharacterStreamNullCheck(statement, outputParams, 19);
            statement.setString(20, trace.getExecutionId());
            this.setCharacterStreamNullCheck(statement, xmlExecutionTraceNoEvents, 21);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(execDateLong));
                parameterValues.add(inetAddressStr);
                parameterValues.add(requestPathStr);
                parameterValues.add(executedPathStr);
                parameterValues.add(rsPropsString);
                parameterValues.add(trace.getUserData());
                parameterValues.add(String.valueOf(trace.getExecutionDuration()));
                parameterValues.add(String.valueOf(trace.getTotalRules()));
                parameterValues.add(String.valueOf(trace.getTotalRulesFired()));
                parameterValues.add(String.valueOf(trace.getTotalRulesNotFired()));
                parameterValues.add(String.valueOf(trace.getTotalTasks()));
                parameterValues.add(String.valueOf(trace.getTotalTasksExecuted()));
                parameterValues.add(String.valueOf(trace.getTotalTasksNotExecuted()));
                parameterValues.add(allRules);
                parameterValues.add(allTasks);
                parameterValues.add(xmlExecutionEvents);
                parameterValues.add(trace.getExecutionOutput());
                parameterValues.add(inputParams);
                parameterValues.add(outputParams);
                parameterValues.add(trace.getExecutionId());
                parameterValues.add(xmlExecutionTraceNoEvents);
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    protected void setExecutionEventsColumnValue(String xmlExecutionEvents, PreparedStatement statement) throws SQLException {
        this.setCharacterStreamNullCheck(statement, xmlExecutionEvents, 16);
    }

    private String computeExecutedPathString(IlrDWTrace trace) {
        IlrPath executedPath = trace.getExecutedRulesetPath();
        String executedPathStr = null;
        executedPathStr = executedPath != null ? executedPath.toString() : "";
        return executedPathStr;
    }

    private String computeRequestPathString(IlrDWTrace trace) {
        IlrPath requestPath = trace.getRequestRulesetPath();
        String requestPathStr = null;
        requestPathStr = requestPath != null ? requestPath.toString() : "";
        return requestPathStr;
    }

    private String compueInetAddressString(IlrDWTrace trace) {
        InetAddress inetAddress = trace.getInetAddress();
        String inetAddressStr = inetAddress != null ? inetAddress.toString() : null;
        return inetAddressStr;
    }

    private Long computeExecDateMillis(IlrDWTrace trace) {
        Date execDate = trace.getExecutionDate();
        Long execDateLong = null;
        if (execDate != null) {
            execDateLong = execDate.getTime();
        }
        return execDateLong;
    }

    private void setLongNullCheck(PreparedStatement statement, Long value, int idx) throws SQLException {
        if (value != null) {
            statement.setLong(idx, value);
        } else {
            statement.setNull(idx, -5);
        }
    }

    private void setCharacterStreamNullCheck(PreparedStatement statement, String str, int indx) throws SQLException {
        if (str != null) {
            statement.setCharacterStream(indx, (Reader)new StringReader(str), str.length());
        } else if (this.isSybase) {
            statement.setNull(indx, 12);
        } else {
            statement.setNull(indx, 2005);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> select(IlrPreparedStatementPart preparedStatementPart, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<String> ids = new ArrayList<String>();
        try {
            statement = preparedStatementPart.createPreparedStatement(connection);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                for (Object object : preparedStatementPart.getValues()) {
                    parameterValues.add(String.valueOf(object));
                }
            }
            rs = IlrDatabaseUtility.executeQuery(statement, preparedStatementPart.getSQL(), parameterValues);
            while (rs.next()) {
                ids.add(rs.getString(2));
            }
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return ids;
    }

    private IlrPreparedStatementPart constructPreparedStatementPart(String sqlStatementBegin, String sqlStatementEnd, String sqlStatementOrder, IlrTraceQueryImpl traceQuery, boolean statementRequiresColumnNames) {
        IlrPreparedStatementPart returnedValue = new IlrPreparedStatementPart();
        StringBuffer sql = new StringBuffer(sqlStatementBegin);
        ArrayList<Object> values = new ArrayList<Object>();
        if (traceQuery == null || traceQuery.getCriteria() == null) {
            sql.append(sqlStatementEnd);
            sql.append(sqlStatementOrder);
        } else {
            TracesSQLWriter sqlWriter = new TracesSQLWriter();
            if (statementRequiresColumnNames) {
                this.appendColumnNamesToSQLStringBuffer(sql, traceQuery, sqlWriter);
            }
            sql.append(sqlStatementEnd);
            IlrPreparedStatementPart criteriaPreparedStatementPart = sqlWriter.toPreparedStatementPart(traceQuery.getCriteria());
            if (criteriaPreparedStatementPart != null && !criteriaPreparedStatementPart.isEmpty()) {
                sql.append(" WHERE ");
                sql.append(criteriaPreparedStatementPart.getSQL());
                values.addAll(criteriaPreparedStatementPart.getValues());
            }
            sql.append(sqlStatementOrder);
        }
        returnedValue.setSQL(sql.toString());
        returnedValue.setValues(values);
        return returnedValue;
    }

    private void appendColumnNamesToSQLStringBuffer(StringBuffer sql, IlrTraceQueryImpl traceQuery, TracesSQLWriter sqlWriter) {
        HashMap<String, String> exceptions = new HashMap<String, String>();
        exceptions.put("TIME_STAMP", "1");
        exceptions.put("EXECUTION_ID", "2");
        String critCol = sqlWriter.toColumnNameListSQL(traceQuery.getCriteria(), exceptions);
        if (critCol != null && !critCol.equals("")) {
            sql.append(critCol);
        }
    }

    private IlrPreparedStatementPart constructPreparedStatementPart(String sqlStatement, IlrTraceQueryImpl traceQuery) {
        return this.constructPreparedStatementPart(sqlStatement, "", "", traceQuery, false);
    }

    public List<String> selectAll(IlrDAOConfigurator configurator, Connection connection) throws SQLException {
        IlrPreparedStatementPart sqlStatement = new IlrPreparedStatementPart();
        sqlStatement.setSQL(configurator.getSQLStatement(SQLST_SELECT_ALL_ID));
        return this.select(sqlStatement, connection);
    }

    public List<String> findTraces(IlrTraceQueryImpl traceQuery, IlrDAOConfigurator configurator, Connection connection) throws SQLException {
        IlrPreparedStatementPart sqlStatement = this.constructSelectTracesStatement(traceQuery, configurator);
        return this.select(sqlStatement, connection);
    }

    IlrPreparedStatementPart constructSelectTracesStatement(IlrTraceQueryImpl traceQuery, IlrDAOConfigurator configurator) {
        IlrPreparedStatementPart sqlStatement = this.constructPreparedStatementPart(configurator.getSQLStatement(SQLST_SELECT_ALL_ID_BEGIN), configurator.getSQLStatement(SQLST_SELECT_ALL_ID_END), configurator.getSQLStatement(SQLST_SELECT_ALL_ID_ORDER), traceQuery, true);
        return sqlStatement;
    }

    public IlrDWTrace findTraceById(String executionId, IlrDAOConfigurator configurator, Connection connection) throws SQLException {
        if (executionId == null) {
            return null;
        }
        PreparedStatement statement = null;
        ResultSet rs = null;
        IlrDWTrace trace = null;
        try {
            String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_TRACE_BY_ID);
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, executionId);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(executionId));
            }
            if ((rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues)).next()) {
                trace = this.resultsetToTrace(rs);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IlrDatabaseUtility.closeStatement(statement);
                IlrDatabaseUtility.closeResultSet(rs);
                throw throwable;
            }
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(IlrDAOConfigurator configurator, Connection connection) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_ALL_TRACES);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            IlrDatabaseUtility.executeUpdate(statement, sqlStatement, new ArrayList<String>());
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(IlrTraceQueryImpl query, IlrDAOConfigurator configurator, Connection connection) throws SQLException {
        IlrPreparedStatementPart preparedStatementPart = this.constructDeleteTracesStatement(query, configurator);
        PreparedStatement statement = null;
        try {
            statement = preparedStatementPart.createPreparedStatement(connection);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                for (Object object : preparedStatementPart.getValues()) {
                    parameterValues.add(String.valueOf(object));
                }
            }
            IlrDatabaseUtility.executeUpdate(statement, preparedStatementPart.getSQL(), parameterValues);
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    IlrPreparedStatementPart constructDeleteTracesStatement(IlrTraceQueryImpl query, IlrDAOConfigurator configurator) {
        IlrPreparedStatementPart preparedStatementPart = this.constructPreparedStatementPart(configurator.getSQLStatement(SQLST_DELETE_ALL_TRACES), query);
        return preparedStatementPart;
    }

    private IlrDWTrace resultsetToTrace(ResultSet rs) throws Exception {
        IlrExecutionTraceImpl execTrace = null;
        String executionEventsXML = this.readExecutionEvents(rs);
        String executionTraceXML = this.readCLOB(rs, 21);
        try {
            execTrace = new IlrXMLExecutionTraceDeserializer(executionTraceXML).getExecutionTrace();
            if (executionEventsXML != null) {
                IlrExecutionTraceImpl execTraceWithEventsOnly = new IlrXMLExecutionTraceDeserializer(executionEventsXML).getExecutionTrace();
                execTrace.setExecutionEvents(execTraceWithEventsOnly.getExecutionEvents());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String requestPathStr = rs.getString(3);
        IlrPath requestPath = null;
        if (requestPathStr != null) {
            try {
                requestPath = new IlrPath(requestPathStr);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String executedPathStr = rs.getString(4);
        IlrPath executedPath = null;
        if (executedPathStr != null) {
            try {
                executedPath = new IlrPath(executedPathStr);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Map<String, String> rulesetProps = this.toPropertiesMap(rs.getCharacterStream(5));
        String userData = this.readCLOB(rs, 6);
        Long nbRules = this.readLong(rs, 8);
        Long nbTasks = this.readLong(rs, 11);
        String executionOutput = this.readCLOB(rs, 17);
        Map<String, String> inParams = this.stringToMap(this.readCLOB(rs, 18));
        Map<String, String> outParams = this.stringToMap(this.readCLOB(rs, 19));
        String executionId = rs.getString(20);
        return new IlrDWTraceImpl(execTrace, requestPath, executedPath, rulesetProps, userData, nbRules, nbTasks, executionOutput, inParams, outParams, executionId);
    }

    protected String readExecutionEvents(ResultSet rs) throws SQLException, IOException {
        return this.readCLOB(rs, 16);
    }

    private Long readLong(ResultSet rs, int idx) throws SQLException {
        long storedLong = rs.getLong(idx);
        Long result = rs.wasNull() ? null : Long.valueOf(storedLong);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> toPropertiesMap(Reader reader) throws InvalidPropertiesFormatException, IOException {
        if (reader == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, UTF8);
        try {
            char[] buffer = new char[1024];
            int i = 0;
            while ((i = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, i);
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e1) {}
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        Properties props = new Properties();
        props.load(bais);
        HashMap<String, String> rulesetProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            rulesetProperties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return rulesetProperties;
    }

    private String propertiesToString(Map<String, String> map) throws IOException {
        if (map == null) {
            return null;
        }
        Properties props = new Properties();
        props.putAll(map);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        return baos.toString(UTF8);
    }

    private String mapToString(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        StringBuffer res = new StringBuffer();
        res.append("[");
        for (String key : map.keySet()) {
            String val = map.get(key);
            res.append("[");
            res.append(key);
            res.append("=");
            if (val != null) {
                res.append(val);
            }
            res.append("]");
        }
        res.append("]");
        return res.toString();
    }

    private Map<String, String> stringToMap(String ss) {
        String[] params;
        if (ss == null) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        if (ss.startsWith("[[")) {
            ss = ss.substring(1);
        }
        if (ss.endsWith("]]")) {
            ss = ss.substring(0, ss.length() - 2);
        }
        for (String param : params = ss.split("\\]\\[")) {
            String key;
            String[] parts = param.split("=", 2);
            String string = key = parts[0].startsWith("[") ? parts[0].substring(1) : parts[0];
            if (parts.length <= 1) continue;
            m.put(key, parts[1]);
        }
        return m;
    }

    private String toStringRules(Map<String, IlrRuleInformation> rules) {
        if (rules == null) {
            return null;
        }
        return this.toString(rules.keySet());
    }

    private String toStringTasks(Map<String, IlrTaskInformation> tasks) {
        if (tasks == null) {
            return null;
        }
        return this.toString(tasks.keySet());
    }

    private String toString(Set<String> strings) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = strings.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readCLOB(ResultSet rs, int column) throws SQLException, IOException {
        Reader reader = rs.getCharacterStream(column);
        if (reader == null) {
            return null;
        }
        try {
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[1024];
            int i = 0;
            while ((i = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, i);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }
}

