/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session;

import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.session.IlrJ2SESessionFactory;
import ilog.rules.res.session.IlrRuleServiceException;
import ilog.rules.res.session.IlrSessionException;
import ilog.rules.res.session.IlrSessionFactory;
import ilog.rules.res.session.IlrSessionResponse;
import ilog.rules.res.session.internal.IlrRuleServiceBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;

public class IlrRuleService
extends IlrRuleServiceBase {
    public IlrRuleService(PrintWriter logWriter) {
        super(new IlrJ2SESessionFactory(logWriter));
    }

    public IlrSessionFactory getSessionFactory() {
        return this.factory;
    }

    public IlrSessionResponse executeRuleset(IlrPath rulesetPath, Map<String, Object> params, boolean trace) throws IlrRuleServiceException {
        return this.executeRuleset(rulesetPath, params, null, trace);
    }

    public boolean isRulesetDeployed(IlrPath rulesetPath) throws IlrRuleServiceException {
        try {
            this.rwLock.readLock().lock();
            IlrMutableRuleAppInformation ruleapp = rulesetPath.getRuleAppVersion() != null ? (IlrMutableRuleAppInformation)this.getRepository().getRuleApp(rulesetPath.getRuleAppName(), rulesetPath.getRuleAppVersion()) : (IlrMutableRuleAppInformation)this.getRepository().getGreatestRuleApp(rulesetPath.getRuleAppName());
            if (ruleapp == null) {
                boolean bl = false;
                return bl;
            }
            IlrMutableRulesetArchiveInformation ruleset = rulesetPath.getRulesetVersion() != null ? (IlrMutableRulesetArchiveInformation)ruleapp.getRuleset(rulesetPath.getRulesetName(), rulesetPath.getRulesetVersion()) : (IlrMutableRulesetArchiveInformation)ruleapp.getGreatestRuleset(rulesetPath.getRulesetName());
            boolean bl = ruleset != null;
            return bl;
        }
        catch (IlrSessionException e) {
            throw new IlrRuleServiceException(e);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean undeployRuleset(IlrPath rulesetPath) throws IlrRuleServiceException {
        try {
            this.rwLock.writeLock().lock();
            IlrMutableRuleAppInformation ruleapp = rulesetPath.getRuleAppVersion() != null ? (IlrMutableRuleAppInformation)this.getRepository().getRuleApp(rulesetPath.getRuleAppName(), rulesetPath.getRuleAppVersion()) : (IlrMutableRuleAppInformation)this.getRepository().getGreatestRuleApp(rulesetPath.getRuleAppName());
            if (ruleapp == null) {
                boolean bl = false;
                return bl;
            }
            IlrMutableRulesetArchiveInformation ruleset = rulesetPath.getRulesetVersion() != null ? (IlrMutableRulesetArchiveInformation)ruleapp.getRuleset(rulesetPath.getRulesetName(), rulesetPath.getRulesetVersion()) : (IlrMutableRulesetArchiveInformation)ruleapp.getGreatestRuleset(rulesetPath.getRulesetName());
            if (ruleset == null) {
                boolean bl = false;
                return bl;
            }
            IlrPath path = ruleset.getCanonicalPath();
            ruleapp.removeRuleset(ruleset);
            this.getManagementSession().invalidate(path);
            boolean bl = true;
            return bl;
        }
        catch (IlrSessionException e) {
            throw new IlrRuleServiceException(e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public IlrPath deployRuleset(IlrPath rulesetPath, InputStream archiveStream, Map<String, String> archiveProperties) throws IlrRuleServiceException {
        try {
            IlrMutableRulesetArchiveInformation ruleset;
            this.rwLock.writeLock().lock();
            IlrRepositoryFactory repoFactory = this.getRepositoryFactory();
            IlrMutableRepository repo = this.getRepository();
            IlrVersion ruleappV = rulesetPath.getRuleAppVersion();
            IlrVersion rulesetV = rulesetPath.getRulesetVersion();
            IlrMutableRuleAppInformation ruleapp = rulesetV != null ? (IlrMutableRuleAppInformation)repo.getRuleApp(rulesetPath.getRuleAppName(), ruleappV) : (IlrMutableRuleAppInformation)repo.getGreatestRuleApp(rulesetPath.getRuleAppName());
            if (ruleapp == null) {
                if (ruleappV == null) {
                    ruleappV = new IlrVersion(1, 0);
                }
                ruleapp = repoFactory.createRuleApp(rulesetPath.getRuleAppName(), ruleappV);
                repo.addRuleApp(ruleapp);
            }
            if ((ruleset = rulesetV != null ? (IlrMutableRulesetArchiveInformation)ruleapp.getRuleset(rulesetPath.getRulesetName(), rulesetV) : (IlrMutableRulesetArchiveInformation)ruleapp.getGreatestRuleset(rulesetPath.getRulesetName())) == null) {
                if (rulesetV == null) {
                    rulesetV = new IlrVersion(1, 0);
                }
                ruleset = repoFactory.createRuleset(rulesetPath.getRulesetName(), rulesetV);
                ruleset.setRESRulesetArchive(IlrEngineType.CRE, archiveStream);
                ruleapp.addRuleset(ruleset);
            } else {
                ruleset.setRESRulesetArchive(IlrEngineType.CRE, archiveStream);
            }
            if (archiveProperties != null) {
                for (Map.Entry<String, String> prop : archiveProperties.entrySet()) {
                    ruleset.setProperty(prop.getKey(), prop.getValue());
                }
            }
            this.getManagementSession().invalidate(ruleset.getCanonicalPath());
            IlrPath i$ = ruleset.getCanonicalPath();
            return i$;
        }
        catch (IlrSessionException e) {
            throw new IlrRuleServiceException(e);
        }
        catch (IlrFormatException e) {
            throw new IlrRuleServiceException(e);
        }
        catch (IlrAlreadyExistException e) {
            throw new IlrRuleServiceException(e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrPath deployRuleset(IlrPath rulesetPath, byte[] archive, Map<String, String> archiveProperties) throws IlrRuleServiceException {
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(archive);
            IlrPath ilrPath = this.deployRuleset(rulesetPath, stream, archiveProperties);
            return ilrPath;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

