/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.config.internal;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.xu.client.internal.jca.DescriptorException;
import com.ibm.rules.res.xu.client.internal.jca.DescriptorParser;
import ilog.rules.res.session.config.IlrConfigException;
import ilog.rules.res.session.util.IlrSessionLocalization;
import ilog.rules.res.util.classloader.IlrClassLoaderUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class IlrConfigFiles {
    public static final String DEFAULT_DESCRIPTOR_NAME = "META-INF/default_ra.xml";
    private static final String DESCRIPTOR_NAME = "ra.xml";
    private static final String DEFAULT_DVS_DW_PROPERTIES = "default-dvs-dw.properties";
    private static final String DVS_DW_PROPERTIES = "dvs-dw.properties";
    private static RESLogger log = IlrSessionLocalization.LOGGER;

    public static Map<String, Object> readDefaultXUDescriptor() throws IlrConfigException {
        InputStream descriptorStream = IlrConfigFiles.getDefaultXUDescriptorStream();
        return IlrConfigFiles.readXUDescriptor(descriptorStream);
    }

    public static Map<String, Object> readXUDescriptor(InputStream descriptorStream) throws IlrConfigException {
        try {
            DescriptorParser parser = new DescriptorParser();
            return parser.getConfigProperties(descriptorStream);
        }
        catch (DescriptorException e) {
            throw new IlrConfigException(e);
        }
    }

    public static InputStream findXUDescriptorStream() {
        InputStream descriptorStream = null;
        descriptorStream = ClassLoader.getSystemResourceAsStream(DESCRIPTOR_NAME);
        if (descriptorStream == null) {
            descriptorStream = IlrConfigFiles.getClassLoaderForResourceLookup().getResourceAsStream(DESCRIPTOR_NAME);
        }
        if (descriptorStream != null) {
            log.info(IlrSessionLocalization.FOUND_USER_SETTINGS_INFO, new String[]{DESCRIPTOR_NAME});
            return descriptorStream;
        }
        return IlrConfigFiles.getDefaultXUDescriptorStream();
    }

    public static InputStream getDefaultXUDescriptorStream() {
        InputStream descriptorStream = IlrConfigFiles.class.getClassLoader().getResourceAsStream(DEFAULT_DESCRIPTOR_NAME);
        if (descriptorStream != null) {
            log.info(IlrSessionLocalization.FOUND_DEFAULT_SETTINGS_INFO, new String[]{DEFAULT_DESCRIPTOR_NAME});
            return descriptorStream;
        }
        throw new IllegalStateException(IlrSessionLocalization.MESSAGE_HELPER.getLocalizedMessage(IlrSessionLocalization.MISSING_DESCRIPTOR, new String[]{DEFAULT_DESCRIPTOR_NAME}));
    }

    private static ClassLoader getClassLoaderForResourceLookup() {
        ClassLoader contextClassLoader = IlrClassLoaderUtil.getThreadClassLoader();
        return contextClassLoader != null ? contextClassLoader : IlrConfigFiles.class.getClassLoader();
    }

    public static Map<String, String> readTraceDAOConfiguration() {
        InputStream inStream = IlrConfigFiles.getResourceAsStream(IlrConfigFiles.getClassLoaderForResourceLookup(), DVS_DW_PROPERTIES);
        if (inStream != null) {
            return IlrConfigFiles.loadPropertiesAsMap(inStream);
        }
        return IlrConfigFiles.readDefaultTraceDAOConfiguration();
    }

    public static Map<String, String> readDefaultTraceDAOConfiguration() {
        InputStream inStream = IlrConfigFiles.getResourceAsStream(IlrConfigFiles.class.getClassLoader(), DEFAULT_DVS_DW_PROPERTIES);
        return IlrConfigFiles.loadPropertiesAsMap(inStream);
    }

    private static Map<String, String> loadPropertiesAsMap(InputStream inStream) {
        if (inStream == null) {
            return new HashMap<String, String>();
        }
        Properties prop = new Properties();
        try {
            prop.load(inStream);
        }
        catch (Exception ignored) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : prop.stringPropertyNames()) {
            result.put(key, prop.getProperty(key));
        }
        return result;
    }

    private static InputStream getResourceAsStream(ClassLoader classLoader, String dvsDwProperties) {
        InputStream inStream = classLoader.getResourceAsStream(dvsDwProperties);
        if (inStream == null) {
            inStream = classLoader.getResourceAsStream("/" + dvsDwProperties);
        }
        return inStream;
    }
}

