/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.config.internal;

import com.ibm.rules.res.util.internal.PropertiesConverter;
import ilog.rules.res.session.util.IlrSessionLocalization;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IlrPropertyMapConfig {
    private final Map<String, String> properties = new HashMap<String, String>();

    public IlrPropertyMapConfig(String propertyMapName, Map<String, Object> xuProperties, String ... keys) {
        Map<String, String> allProperties = IlrPropertyMapConfig.parsePropertyMap(propertyMapName, xuProperties);
        Map<String, String> subset = this.extractPropertiesSubset(allProperties, keys);
        this.properties.putAll(subset);
    }

    private Map<String, String> extractPropertiesSubset(Map<String, String> allProperties, String ... keys) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : keys) {
            if (!allProperties.containsKey(key)) continue;
            result.put(key, allProperties.get(key));
        }
        return result;
    }

    public IlrPropertyMapConfig(String propertyMapName, Map<String, Object> xuProperties) {
        this.properties.putAll(IlrPropertyMapConfig.parsePropertyMap(propertyMapName, xuProperties));
    }

    public static Map<String, String> parsePropertyMap(String propertyMapName, Map<String, Object> xuProperties) {
        return PropertiesConverter.toMap((String)xuProperties.get(propertyMapName));
    }

    public IlrPropertyMapConfig(Map<String, String> initProperties) {
        this.properties.putAll(initProperties);
    }

    public IlrPropertyMapConfig() {
    }

    public void setProperty(String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.properties.remove(key);
            return;
        }
        if ("tcpip.port".equals(key) && (value instanceof Integer && (Integer)value <= 0 || value instanceof String && Integer.parseInt((String)value) <= 0)) {
            String errorMessage = IlrSessionLocalization.getLocalizedMessage(IlrSessionLocalization.TCPIP_PORT_ERROR, new String[]{String.valueOf(value)});
            throw new IllegalArgumentException(errorMessage);
        }
        if ("tcpip.retryInterval".equals(key) && (value instanceof Long && (Long)value < 0L || value instanceof String && Long.parseLong((String)value) < 0L)) {
            String errorMessage = IlrSessionLocalization.getLocalizedMessage(IlrSessionLocalization.TCPIP_RETRY_INTERVAL_ERROR, new String[]{String.valueOf(value)});
            throw new IllegalArgumentException(errorMessage);
        }
        this.properties.put(key, String.valueOf(value));
    }

    public String getProperty(String key) {
        if (key == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void putProperties(Map<String, String> newProperties) {
        this.properties.putAll(newProperties);
    }

    public int getIntProperty(String key) {
        String str = this.properties.get(key);
        return Integer.parseInt(str);
    }

    public String setIntProperty(String key, int value) {
        return this.properties.put(key, Integer.toString(value));
    }

    public long getLongProperty(String key) {
        String str = this.properties.get(key);
        return Long.parseLong(str);
    }

    public String setLongProperty(String key, long value) {
        return this.properties.put(key, Long.toString(value));
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.properties.toString();
    }

    public void setBooleanProperty(String key, boolean value) {
        this.properties.put(key, Boolean.toString(value));
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String p = this.properties.get(key);
        if (p == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(p);
    }

    public boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, false);
    }

    public void clearProperties() {
        this.properties.clear();
    }
}

