/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.config.internal;

import ilog.rules.res.session.config.IlrPersistenceConfig;
import ilog.rules.res.session.config.IlrPersistenceType;
import ilog.rules.res.session.config.internal.IlrDatasourceXOMPersistenceConfigImpl;
import ilog.rules.res.session.config.internal.IlrFileXOMPersistenceConfigImpl;
import ilog.rules.res.session.config.internal.IlrJDBCXOMPersistenceConfigImpl;
import ilog.rules.res.session.config.internal.IlrPropertyMapConfig;
import java.util.Map;

public class IlrXOMPersistenceConfigImpl
implements IlrPersistenceConfig {
    public static final String PERSISTENCE_PROPERTIES = "persistenceProperties";
    private IlrPersistenceType persistenceType;
    private String customPersistenceType;
    private final IlrFileXOMPersistenceConfigImpl fileXOMPersistenceConfig;
    private final IlrDatasourceXOMPersistenceConfigImpl datasourceXOMPersistenceConfig;
    private final IlrJDBCXOMPersistenceConfigImpl jdbcXOMPersistenceConfig;

    IlrXOMPersistenceConfigImpl(Map<String, Object> xuProperties) {
        Map<String, String> persistenceProperties = IlrPropertyMapConfig.parsePropertyMap(PERSISTENCE_PROPERTIES, xuProperties);
        String persistenceTypeName = persistenceProperties.get("XOM_PERSISTENCE_TYPE");
        this.persistenceType = persistenceTypeName != null ? IlrPersistenceType.parse(persistenceTypeName) : null;
        this.fileXOMPersistenceConfig = new IlrFileXOMPersistenceConfigImpl(xuProperties);
        this.datasourceXOMPersistenceConfig = new IlrDatasourceXOMPersistenceConfigImpl(xuProperties);
        this.jdbcXOMPersistenceConfig = new IlrJDBCXOMPersistenceConfigImpl(xuProperties);
    }

    @Override
    public IlrPersistenceType getPersistenceType() {
        return this.persistenceType;
    }

    @Override
    public void setPersistenceType(IlrPersistenceType type) {
        this.persistenceType = type;
        this.customPersistenceType = null;
    }

    @Override
    public IlrFileXOMPersistenceConfigImpl getFilePersistenceConfig() {
        return this.fileXOMPersistenceConfig;
    }

    @Override
    public IlrJDBCXOMPersistenceConfigImpl getJDBCPersistenceConfig() {
        return this.jdbcXOMPersistenceConfig;
    }

    @Override
    public IlrDatasourceXOMPersistenceConfigImpl getDatasourcePersistenceConfig() {
        return this.datasourceXOMPersistenceConfig;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":{persistenceType=" + (Object)((Object)this.persistenceType) + "," + this.fileXOMPersistenceConfig + "," + this.jdbcXOMPersistenceConfig + "," + this.datasourceXOMPersistenceConfig + "}";
    }

    public String getCustomPersistenceType() {
        return this.customPersistenceType;
    }

    public void setCustomPersistenceType(String type) {
        this.persistenceType = null;
        this.customPersistenceType = type;
    }
}

