/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.config.internal;

import com.ibm.rules.res.xu.client.internal.jca.JCAPluginsPropertyParser;
import com.ibm.rules.res.xu.client.internal.jca.ParseException;
import com.ibm.rules.res.xu.config.internal.PluginConfig;
import ilog.rules.res.session.config.IlrConfigException;
import ilog.rules.res.session.config.IlrPluginConfig;
import ilog.rules.res.session.config.IlrXUConfig;
import ilog.rules.res.session.config.internal.IlrConfigFiles;
import ilog.rules.res.session.config.internal.IlrPersistenceConfigImpl;
import ilog.rules.res.session.config.internal.IlrPluginConfigImpl;
import ilog.rules.res.session.config.internal.IlrPluginConfigs;
import ilog.rules.res.session.config.internal.IlrPluginConfigsImpl;
import ilog.rules.res.session.config.internal.IlrPoolConfigImpl;
import ilog.rules.res.session.config.internal.IlrPropertyMapConfig;
import ilog.rules.res.session.config.internal.IlrRulesetCacheConfigImpl;
import ilog.rules.res.session.config.internal.IlrXOMPersistenceConfigImpl;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class IlrXUConfigImpl
implements IlrXUConfig {
    public static final String PLUGINS = "plugins";
    public static final String DEFAULT_CONNECTION_MANAGER_PROPERTIES = "defaultConnectionManagerProperties";
    public static final String TRANSFORMER_POOL_PROPERTIES = "transformerPoolProperties";
    public static final String DOCUMENT_BUILDER_POOL_PROPERTIES = "documentBuilderPoolProperties";
    public static final String RULESET_USAGE_MONITOR_ENABLED = "rulesetUsageMonitorEnabled";
    public static final String TRACE_LEVEL = "traceLevel";
    public static final String LOG_LEVEL = "logLevel";
    public static final String TRACE_AUTO_FLUSH = "traceAutoFlush";
    public static final String LOG_AUTO_FLUSH = "logAutoFlush";
    public static final String ASYNCHRONOUS_RULESET_PARSING = "asynchronousRulesetParsing";
    public static final String PERSISTENCE_CONCCURENT_MODE = "CONCURRENT_PERSISTENCE_ACCESS";
    private IlrPoolConfigImpl docBuilderPoolConfig;
    private IlrPoolConfigImpl transformerPoolConfig;
    private IlrPoolConfigImpl connectionPoolConfig;
    private IlrRulesetCacheConfigImpl rulesetCacheConfig;
    private List<IlrPluginConfig> pluginConfigs;
    private IlrPersistenceConfigImpl persistenceConfig;
    private IlrXOMPersistenceConfigImpl xomPersistenceConfig;
    private IlrPropertyMapConfig xuConfigProperties;
    private PrintWriter logWriter;

    protected IlrXUConfigImpl() {
        Map<String, Object> xuProperties;
        try {
            xuProperties = IlrConfigFiles.readDefaultXUDescriptor();
        }
        catch (IlrConfigException e) {
            throw new RuntimeException(e);
        }
        this.setAllAttributes(xuProperties);
    }

    private void setAllAttributes(Map<String, Object> xuProperties) {
        try {
            this.pluginConfigs = this.parsePluginConfigs(xuProperties);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        this.docBuilderPoolConfig = new IlrPoolConfigImpl(DOCUMENT_BUILDER_POOL_PROPERTIES, xuProperties, "pool.maxSize", 10, "pool.waitTimeout", 0L);
        this.transformerPoolConfig = new IlrPoolConfigImpl(TRANSFORMER_POOL_PROPERTIES, xuProperties, "pool.maxSize", 10, "pool.waitTimeout", 0L);
        this.connectionPoolConfig = new IlrPoolConfigImpl(DEFAULT_CONNECTION_MANAGER_PROPERTIES, xuProperties, "pool.maxSize", 10, "pool.waitTimeout", -1L);
        this.rulesetCacheConfig = new IlrRulesetCacheConfigImpl(xuProperties);
        this.persistenceConfig = new IlrPersistenceConfigImpl(xuProperties);
        this.xomPersistenceConfig = new IlrXOMPersistenceConfigImpl(xuProperties);
        this.xuConfigProperties = this.initXUConfigProperties(xuProperties);
    }

    private IlrPropertyMapConfig initXUConfigProperties(Map<String, Object> xuProperties) {
        boolean isLogAutoFlush = this.initLogAutoFlushValue(xuProperties);
        Level logLevel = this.initLogLevelValue(xuProperties);
        boolean asynchronousRulesetParsingEnabled = this.initAsynchronousRulesetParsingEnabledValue(xuProperties);
        boolean rulesetUsageMonitorEnabled = this.initRulesetUsageMonitorEnabledValue(xuProperties);
        IlrPropertyMapConfig result = new IlrPropertyMapConfig();
        result.setBooleanProperty(LOG_AUTO_FLUSH, isLogAutoFlush);
        result.setBooleanProperty(ASYNCHRONOUS_RULESET_PARSING, asynchronousRulesetParsingEnabled);
        result.setBooleanProperty(RULESET_USAGE_MONITOR_ENABLED, rulesetUsageMonitorEnabled);
        result.setProperty(LOG_LEVEL, logLevel.getName());
        return result;
    }

    private boolean initAsynchronousRulesetParsingEnabledValue(Map<String, Object> xuProperties) {
        return this.getXUBooleanProperty(ASYNCHRONOUS_RULESET_PARSING, xuProperties);
    }

    private List<IlrPluginConfig> parsePluginConfigs(Map<String, Object> xuProperties) throws ParseException {
        List<PluginConfig> configs = JCAPluginsPropertyParser.parsePluginConfigs((String)xuProperties.get(PLUGINS));
        LinkedList<IlrPluginConfig> result = new LinkedList<IlrPluginConfig>();
        for (PluginConfig config : configs) {
            IlrPluginConfigImpl pluginConfig = new IlrPluginConfigImpl(config.getPluginClassName());
            Map<String, String> properties = this.getPluginPropertiesExceptClassName(config);
            pluginConfig.putProperties(properties);
            result.add(pluginConfig);
        }
        return result;
    }

    private Map<String, String> getPluginPropertiesExceptClassName(PluginConfig config) {
        HashMap<String, String> properties = new HashMap<String, String>(config.getProperties());
        properties.remove("pluginClass");
        return properties;
    }

    private boolean initLogAutoFlushValue(Map<String, Object> xuProperties) {
        return this.getXUBooleanProperty(TRACE_AUTO_FLUSH, xuProperties);
    }

    private boolean initRulesetUsageMonitorEnabledValue(Map<String, Object> xuProperties) {
        return this.getXUBooleanProperty(RULESET_USAGE_MONITOR_ENABLED, xuProperties);
    }

    private boolean getXUBooleanProperty(String key, Map<String, Object> xuProperties) {
        Boolean result = (Boolean)xuProperties.get(key);
        return result;
    }

    private Level initLogLevelValue(Map<String, Object> xuProperties) {
        return Level.parse(String.valueOf(xuProperties.get(TRACE_LEVEL)));
    }

    public IlrPoolConfigImpl getTransformerPoolConfig() {
        return this.transformerPoolConfig;
    }

    @Override
    public Level getLoglevel() {
        String value = this.xuConfigProperties.getProperty(LOG_LEVEL);
        return Level.parse(value);
    }

    public IlrPoolConfigImpl getDocumentBuilderPoolConfig() {
        return this.docBuilderPoolConfig;
    }

    @Override
    public void setLogLevel(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("null");
        }
        this.xuConfigProperties.setProperty(LOG_LEVEL, level.getName());
    }

    @Override
    public void setPluginConfigs(List<IlrPluginConfig> pluginConfigs) {
        this.pluginConfigs.clear();
        if (pluginConfigs == null) {
            return;
        }
        this.pluginConfigs.addAll(this.createDeepCopy(pluginConfigs));
    }

    @Override
    public boolean isLogAutoFlushEnabled() {
        return this.xuConfigProperties.getBooleanProperty(LOG_AUTO_FLUSH);
    }

    @Override
    public void setLogAutoFlushEnabled(boolean enable) {
        this.xuConfigProperties.setBooleanProperty(LOG_AUTO_FLUSH, enable);
    }

    @Override
    public boolean isConcurrentAccessEnabled() {
        return this.xuConfigProperties.getBooleanProperty(PERSISTENCE_CONCCURENT_MODE);
    }

    @Override
    public void setConcurrentAccessEnabled(boolean enabled) {
        this.xuConfigProperties.setBooleanProperty(PERSISTENCE_CONCCURENT_MODE, enabled);
    }

    public IlrRulesetCacheConfigImpl getRulesetCacheConfig() {
        return this.rulesetCacheConfig;
    }

    @Override
    public IlrPersistenceConfigImpl getPersistenceConfig() {
        return this.persistenceConfig;
    }

    @Override
    public IlrPoolConfigImpl getConnectionPoolConfig() {
        return this.connectionPoolConfig;
    }

    public IlrPluginConfigs getPluginConfigs() {
        return this.createDeepCopy(this.pluginConfigs);
    }

    private IlrPluginConfigs createDeepCopy(List<IlrPluginConfig> pluginConfigs) {
        IlrPluginConfigsImpl result = new IlrPluginConfigsImpl();
        for (IlrPluginConfig pluginConfig : pluginConfigs) {
            result.add(new IlrPluginConfigImpl(pluginConfig));
        }
        return result;
    }

    @Override
    public boolean isAsynchronousRulesetParsingEnabled() {
        return this.xuConfigProperties.getBooleanProperty(ASYNCHRONOUS_RULESET_PARSING);
    }

    @Override
    public void setAsynchronousRulesetParsingEnabled(boolean enable) {
        this.xuConfigProperties.setBooleanProperty(ASYNCHRONOUS_RULESET_PARSING, enable);
    }

    @Override
    public boolean isRulesetUsageMonitorEnabled() {
        return this.xuConfigProperties.getBooleanProperty(RULESET_USAGE_MONITOR_ENABLED);
    }

    @Override
    public void setRulesetUsageMonitorEnabled(boolean enable) {
        this.xuConfigProperties.setBooleanProperty(RULESET_USAGE_MONITOR_ENABLED, enable);
    }

    @Override
    public IlrPluginConfig createPluginConfig(String pluginClassName) {
        if (pluginClassName == null) {
            throw new IllegalArgumentException("null");
        }
        IlrPluginConfigImpl result = new IlrPluginConfigImpl(pluginClassName);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IlrXUConfigImpl:{").append(this.toKeyEqualsValueString("xuConfigProperties", this.xuConfigProperties)).append(',').append(this.toKeyEqualsValueString(DEFAULT_CONNECTION_MANAGER_PROPERTIES, this.connectionPoolConfig)).append(',').append(this.toKeyEqualsValueString(DOCUMENT_BUILDER_POOL_PROPERTIES, this.docBuilderPoolConfig)).append(',').append(this.toKeyEqualsValueString(TRANSFORMER_POOL_PROPERTIES, this.transformerPoolConfig)).append(',').append(this.toKeyEqualsValueString("persistenceConfig", this.persistenceConfig)).append(',').append(this.toKeyEqualsValueString("xomPersistenceConfig", this.xomPersistenceConfig)).append(',').append(this.toKeyEqualsValueString("pluginConfigs", this.pluginConfigs)).append(',').append(this.rulesetCacheConfig).append('}');
        return sb.toString();
    }

    private String toKeyEqualsValueString(String name, Object config) {
        return name + '=' + config;
    }

    @Override
    public IlrXOMPersistenceConfigImpl getManagedXOMPersistenceConfig() {
        return this.xomPersistenceConfig;
    }

    @Override
    public void loadSettings(InputStream descriptorStream) throws IlrConfigException {
        Map<String, Object> xuProperties = IlrConfigFiles.readXUDescriptor(descriptorStream);
        this.setAllAttributes(xuProperties);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }
}

