/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl;

import com.ibm.rules.res.xu.client.internal.XUClient;
import com.ibm.rules.util.ffdc.FFDCLogger;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.persistence.trace.IlrTraceDAO;
import ilog.rules.res.persistence.trace.IlrTraceDAOException;
import ilog.rules.res.persistence.trace.IlrTraceDAOFactory;
import ilog.rules.res.persistence.trace.impl.IlrTraceLocalization;
import ilog.rules.res.session.IlrSessionCreationException;
import ilog.rules.res.session.IlrSessionFactory;
import ilog.rules.res.session.IlrSessionRequest;
import ilog.rules.res.session.IlrStatefulSession;
import ilog.rules.res.session.config.internal.IlrConfigFiles;
import ilog.rules.res.session.impl.IlrSessionRequestImpl;
import ilog.rules.res.util.classloader.IlrClassLoaderUtil;
import java.io.Serializable;
import java.util.Map;

public abstract class IlrSessionFactoryBase
implements IlrSessionFactory {
    private static final String CREATE_TRACE_DAO_FACTORY_FAILURE_ID = "113";
    private boolean interceptorEnabled = false;
    private IlrTraceDAOFactory traceDAOFactory = null;
    private ClassLoader xomClassLoader;

    public IlrSessionFactoryBase() {
    }

    public IlrSessionFactoryBase(ClassLoader xomCL) {
        this.xomClassLoader = xomCL;
    }

    @Override
    public boolean isInterceptorEnabled() {
        return this.interceptorEnabled;
    }

    @Override
    public void setInterceptorEnabled(boolean interceptorEnabled) {
        this.interceptorEnabled = interceptorEnabled;
    }

    protected ClassLoader getXOMClassLoader() {
        return this.xomClassLoader != null ? this.xomClassLoader : IlrClassLoaderUtil.getThreadClassLoader();
    }

    @Override
    public IlrSessionRequest createRequest() {
        IlrSessionRequestImpl requestImpl = new IlrSessionRequestImpl();
        requestImpl.setInterceptorEnabled(this.interceptorEnabled);
        return requestImpl;
    }

    protected abstract XUClient getXUClient() throws IlrSessionCreationException;

    public IlrTraceDAO getTraceDAO() throws IlrTraceDAOException {
        return this.getTraceDAOFactory().createDAO();
    }

    private synchronized IlrTraceDAOFactory getTraceDAOFactory() throws IlrTraceDAOException {
        if (this.traceDAOFactory == null) {
            try {
                this.traceDAOFactory = this.createTraceDAOFactory();
            }
            catch (Throwable t) {
                if (t instanceof IlrTraceDAOException) {
                    throw (IlrTraceDAOException)t;
                }
                throw new IlrTraceDAOException(t);
            }
        }
        return this.traceDAOFactory;
    }

    @Override
    public IlrTraceDAOFactory createTraceDAOFactory() throws IlrTraceDAOException {
        Map<String, String> configParams = this.getTraceDAOConfigurationMap();
        try {
            return this.createTraceDaoFactory(configParams);
        }
        catch (IlrTraceDAOException e) {
            FFDCLogger.log((Throwable)e, (Object)this, (String)this.getClass().getName(), (String)CREATE_TRACE_DAO_FACTORY_FAILURE_ID, (Object[])new Object[]{"daoFactoryConfigParams=" + String.valueOf(configParams)});
            throw e;
        }
    }

    private IlrTraceDAOFactory createTraceDaoFactory(Map<String, String> properties) throws IlrTraceDAOException {
        String factoryClassName = properties.get("factoryClassname");
        if (factoryClassName == null) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.NO_TRACE_DAO_FACTORY_ERROR);
        }
        try {
            factoryClassName = factoryClassName.trim();
            Class<?> clazz = Class.forName(factoryClassName, true, this.getXOMClassLoader());
            Object o = clazz.newInstance();
            IlrTraceDAOFactory result = (IlrTraceDAOFactory)o;
            result.initialize(properties);
            return result;
        }
        catch (Throwable t) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.TRACE_DAO_CREATION_ERROR, new String[]{factoryClassName}, t);
        }
    }

    protected String getFactoryClassName(ClassLoader classLoader) throws IlrTraceDAOException {
        String factoryClassName = this.getTraceDAOConfigurationMap().get("factoryClassname");
        if (factoryClassName == null) {
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.NO_TRACE_DAO_FACTORY_ERROR);
        }
        return factoryClassName.trim();
    }

    protected Map<String, String> getTraceDAOConfigurationMap() {
        return IlrConfigFiles.readTraceDAOConfiguration();
    }

    @Override
    public IlrStatefulSession createStatefulSession(IlrPath rulesetPath, Serializable userData, Map<String, Object> initParameters, boolean forceUptodate) throws IlrSessionCreationException {
        return this.createStatefulSession(rulesetPath, userData, initParameters, forceUptodate, this.isInterceptorEnabled());
    }
}

