/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl;

import com.ibm.rules.res.xu.client.internal.XUClient;
import com.ibm.rules.res.xu.client.internal.XURuleEngineSession;
import com.ibm.rules.res.xu.client.internal.XUSession;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.session.IlrSessionCreationException;
import ilog.rules.res.session.IlrSessionException;
import ilog.rules.res.session.IlrSessionRequest;
import ilog.rules.res.session.IlrSessionResponse;
import ilog.rules.res.session.IlrStatelessSession;
import ilog.rules.res.session.async.IlrAsyncExecutionObserver;
import ilog.rules.res.session.impl.IlrInternalAsyncRulesetExecutionListener;
import ilog.rules.res.session.impl.IlrSessionFactoryBase;
import ilog.rules.res.session.impl.IlrStatefulSessionBase;
import ilog.rules.res.util.classloader.IlrClassLoaderUtil;

public abstract class IlrStatelessSessionBase
implements IlrStatelessSession {
    protected final IlrSessionFactoryBase sessionFactory;
    protected final XUClient clientFactory;

    public IlrStatelessSessionBase(IlrSessionFactoryBase sessionFactory, XUClient clientFactory) {
        this.sessionFactory = sessionFactory;
        this.clientFactory = clientFactory;
    }

    protected ClassLoader getClassLoader() {
        return IlrClassLoaderUtil.getThreadClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IlrSessionResponse execute(IlrSessionRequest request) throws IlrSessionException {
        IlrStatefulSessionBase statefulSession = this.createStatefulSession(request);
        try {
            IlrSessionResponse ilrSessionResponse = statefulSession.execute(request.getInputParameters(), request.getTaskName(), request.isBOMAccess(), request.getExecutionId());
            return ilrSessionResponse;
        }
        finally {
            statefulSession.close();
        }
    }

    protected abstract IlrStatefulSessionBase createStatefulSession(IlrSessionRequest var1) throws IlrSessionCreationException;

    @Override
    public void executeAsynchronous(IlrSessionRequest request, IlrAsyncExecutionObserver observer, long timeout) throws IlrSessionException {
        XUSession sess = null;
        try {
            sess = this.clientFactory.createRuleEngineSession(request.getRulesetPath(), this.getClassLoader(), null, request.getUserData(), "8.7.1.0");
            if (request.isForceUptodate()) {
                ((XURuleEngineSession)sess).loadUptodateRuleset();
            }
            if (request.getInputParameters() != null) {
                ((XURuleEngineSession)sess).setParameters(request.getInputParameters());
            }
            ((XURuleEngineSession)sess).asynchronousExecute(new IlrInternalAsyncRulesetExecutionListener(observer, (XURuleEngineSession)sess));
        }
        catch (Throwable e) {
            if (sess != null) {
                try {
                    sess.close();
                }
                catch (XUException e2) {
                    // empty catch block
                }
            }
            throw new IlrSessionException(e);
        }
    }
}

