/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl.trace;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.xu.client.internal.XURuleEngineSession;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.trace.IlrDWTrace;
import ilog.rules.res.model.trace.IlrDWTraceFilter;
import ilog.rules.res.model.trace.IlrDWTraceFilterImpl;
import ilog.rules.res.persistence.trace.IlrTraceDAO;
import ilog.rules.res.session.IlrSessionException;
import ilog.rules.res.session.IlrSessionRequest;
import ilog.rules.res.session.IlrSessionResponse;
import ilog.rules.res.session.IlrTraceFilter;
import ilog.rules.res.session.IlrWarning;
import ilog.rules.res.session.impl.IlrSessionFactoryBase;
import ilog.rules.res.session.impl.IlrSessionWarningImpl;
import ilog.rules.res.session.impl.IlrTraceFilterBase;
import ilog.rules.res.session.impl.trace.IlrTraceOptionsParser;
import ilog.rules.res.session.impl.trace.IlrXUExecutionTraceConverter;
import ilog.rules.res.session.ruleset.IlrExecutionEvent;
import ilog.rules.res.session.ruleset.IlrExecutionTrace;
import ilog.rules.res.session.ruleset.IlrTaskEvent;
import ilog.rules.res.session.ruleset.impl.IlrExecutionTraceImpl;
import ilog.rules.res.session.util.IlrSessionLocalization;
import ilog.rules.res.session.util.IlrXMLExecutionTraceSerializer;
import ilog.rules.res.trace.IlrDWTraceImpl;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class IlrTraceBuilder {
    private final boolean traceEnabled;
    private final IlrTraceFilter traceFilter;
    private final boolean dwEnabled;
    private final IlrDWTraceFilter dwFilter;
    private final boolean bomSupportEnabled;
    private final List<String> inOutParamsSerializationFilters;
    private final IlrDWTraceFilter mergedFilter;
    private IlrExecutionTraceImpl executionTrace;
    private IlrDWTrace dwTrace;
    private Map<String, String> serializedInputParams;
    private final List<IlrWarning> dwRelatedWarnings = new LinkedList<IlrWarning>();
    private long startTime = -1L;
    public static final RESLogger LOGGER = IlrSessionLocalization.LOGGER;
    private static final String NL = "\n";
    static final String INDENT_INCREMENT = "  ";

    public List<IlrWarning> getWarningsRelatedToDW() {
        return this.dwRelatedWarnings;
    }

    private IlrTraceBuilder(boolean traceEnabled, IlrTraceFilter traceFilter, boolean dwEnabled, IlrDWTraceFilter dwFilter, boolean bomSupportEnabled, List<String> paramsSerializationFilters, IlrDWTraceFilter mergedFilter) {
        this.traceEnabled = traceEnabled;
        this.traceFilter = traceFilter;
        this.dwEnabled = dwEnabled;
        this.dwFilter = dwFilter;
        this.bomSupportEnabled = bomSupportEnabled;
        this.inOutParamsSerializationFilters = paramsSerializationFilters;
        this.mergedFilter = mergedFilter;
    }

    private static boolean isDWEnabled(Map<String, String> rsArchiveProperties) {
        String s = rsArchiveProperties.get("monitoring.enabled");
        return s != null && s.equals("true");
    }

    public boolean isInputParametersIncluded() {
        return this.dwFilter.isInfoInputParameters();
    }

    public static IlrTraceBuilder createFromTraceAndDWOptions(IlrSessionRequest request, Map<String, String> rulesetArchiveProperties) throws IlrSessionException {
        boolean dwEnabled = IlrTraceBuilder.isDWEnabled(rulesetArchiveProperties);
        IlrDWTraceFilterImpl dwFilter = null;
        List<String> paramsSerializationFilters = null;
        if (dwEnabled) {
            dwFilter = IlrTraceBuilder.parseDWFilter(rulesetArchiveProperties);
            paramsSerializationFilters = IlrTraceOptionsParser.parseInOutParametersSerializationFilters(rulesetArchiveProperties);
        }
        boolean traceEnabled = request.isTraceEnabled();
        IlrTraceFilter traceFilter = request.getTraceFilter();
        IlrDWTraceFilterImpl mergedFilter = IlrTraceBuilder.buildMergedFilter(traceEnabled, dwEnabled, traceFilter, dwFilter);
        boolean bomSupportEnabled = IlrTraceBuilder.parseBOMSupportRSArchiveProperty(rulesetArchiveProperties);
        return new IlrTraceBuilder(traceEnabled, traceFilter, dwEnabled, dwFilter, bomSupportEnabled, paramsSerializationFilters, mergedFilter);
    }

    private static boolean parseBOMSupportRSArchiveProperty(Map<String, String> rulesetArchiveProperties) {
        String bomSupportEnabledProp = rulesetArchiveProperties.get("ruleset.bom.enabled");
        boolean bomSupportEnabled = Boolean.parseBoolean(bomSupportEnabledProp);
        return bomSupportEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistDWTrace(IlrSessionRequest request, IlrSessionResponse response, IlrSessionFactoryBase sessionFactory) throws IlrSessionException {
        IlrTraceDAO traceDAO;
        block10: {
            traceDAO = null;
            try {
                this.logTrace(this.dwTrace, request, response);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.INFO)) break block10;
                LOGGER.log(Level.INFO, IlrSessionLocalization.LOGGING_SAVE_TRACE_ERROR, new String[]{this.dwTrace.getExecutionId()}, t);
            }
        }
        try {
            traceDAO = sessionFactory.getTraceDAO();
        }
        catch (Exception e) {
            this.addWarningRelatedToDW(IlrSessionLocalization.DW_TRACE_DAO_CREATION_EXCEPTION, new String[]{e.toString()}, e);
            LOGGER.log(Level.SEVERE, IlrSessionLocalization.GET_TRACE_DAO_ERROR, null, e);
            return;
        }
        if (traceDAO == null) {
            this.addWarningRelatedToDW(IlrSessionLocalization.DW_TRACE_DAO_NULL, null, null);
            return;
        }
        try {
            traceDAO.beginTransaction();
            traceDAO.saveTrace(this.dwTrace, request, response);
            traceDAO.commit();
        }
        catch (Exception e) {
            this.addWarningRelatedToDW(IlrSessionLocalization.DW_TRACE_DAO_SAVE_EXCEPTION, new String[]{e.toString()}, e);
            traceDAO.rollback();
            LOGGER.log(Level.SEVERE, IlrSessionLocalization.SAVE_TRACE_ERROR, null, e);
        }
        finally {
            traceDAO.close();
        }
    }

    private IlrDWTrace toDWTrace(IlrDWTraceFilter traceFilter, IlrExecutionTraceImpl execInfos, IlrSessionRequest request, IlrSessionResponse response, XURuleEngineSession xuSession) throws IlrSessionException {
        IlrPath requestRulesetPath = request.getRulesetPath();
        IlrPath executedRulesetPath = response.getCanonicalRulesetPath();
        HashMap<String, String> rsProperties = this.dwFilter.isInfoRulesetProperties() ? this.rulesetPropertiesToMap(response) : null;
        String userData = traceFilter.isInfoUserData() && request.getUserData() != null ? request.getUserData().toString() : null;
        Long nbRules = traceFilter.isInfoTotalRules() ? Long.valueOf(execInfos.getRules().size()) : null;
        Long nbTasks = traceFilter.isInfoTotalTasks() ? Long.valueOf(execInfos.getTasks().size()) : null;
        String executionOutput = traceFilter.isInfoExecutionOutput() ? response.getRulesetExecutionOutput() : null;
        String executionId = response.getExecutionId();
        HashMap<String, Object> outputParameters = this.createParametersCopyAndRemoveRulesCount(response.getOutputParameters());
        Map<String, String> serializedOutputParams = this.serializeOutputParameters(outputParameters, xuSession);
        IlrExecutionTraceImpl nestedTrace = this.applyFilter(execInfos, traceFilter);
        return new IlrDWTraceImpl(nestedTrace, requestRulesetPath, executedRulesetPath, rsProperties, userData, nbRules, nbTasks, executionOutput, this.serializedInputParams, serializedOutputParams, executionId);
    }

    private HashMap<String, Object> createParametersCopyAndRemoveRulesCount(Map<String, Object> parameters) {
        HashMap<String, Object> result = new HashMap<String, Object>(parameters);
        result.remove("ilog.rules.firedRulesCount");
        return result;
    }

    private HashMap<String, String> rulesetPropertiesToMap(IlrSessionResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties properties = response.getRulesetProperties();
        for (String name : properties.stringPropertyNames()) {
            result.put(name, properties.getProperty(name));
        }
        return result;
    }

    public void serializeInputParametersAndKeepResult(Map<String, Object> in, XURuleEngineSession xuEngineSession) {
        this.serializedInputParams = this.serializeParameters(in, xuEngineSession, true);
    }

    private Map<String, String> serializeParameters(Map<String, Object> in, XURuleEngineSession xuEngineSession, boolean inIfTrueElseOut) {
        Map<String, String> result = null;
        if (!this.bomSupportEnabled) {
            result = this.serializeParametersUsing_toString_(in);
            this.addBOMNotEnabledWarningIfNotAlreadyThere();
        } else {
            try {
                result = this.serializeParametersUsingBOMSerialization(xuEngineSession, inIfTrueElseOut);
            }
            catch (XUException e) {
                result = this.serializeParametersUsing_toString_(in);
                try {
                    String error = IlrTraceBuilder.printStackTrace(e);
                    result.put("error", error);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                this.addWarningRelatedToDW(IlrSessionLocalization.DW_BOM_SERIALIZATION_FAILURE, new String[]{e.toString()}, e);
            }
        }
        return result;
    }

    private Map<String, String> serializeOutputParameters(Map<String, Object> out, XURuleEngineSession xuSession) {
        if (!this.dwFilter.isInfoOutputParameters()) {
            return null;
        }
        return this.serializeParameters(out, xuSession, false);
    }

    public static String printStackTrace(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        if (t != null) {
            try {
                IlrTraceBuilder.printStackTrace(t, pw);
            }
            catch (Exception e) {
                t.printStackTrace(pw);
                pw.flush();
            }
            pw.flush();
        }
        try {
            baos.close();
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            return baos.toString();
        }
    }

    private static void printStackTrace(Throwable t, PrintStream ps) throws UnsupportedEncodingException, IOException {
        if (t instanceof IlrErrorException) {
            IlrErrorException ex = (IlrErrorException)t;
            Collection<IlrError> errors = ex.getErrors();
            for (IlrError e : errors) {
                String message = e.getMessage() + NL;
                ps.write(message.getBytes("UTF-8"));
                if (e.getSourceException() == null) continue;
                StackTraceElement[] trace = e.getSourceException().getStackTrace();
                for (int j = 0; j < trace.length; ++j) {
                    ps.println("\tat " + trace[j]);
                }
                Throwable ourCause = t.getCause();
                if (ourCause == null) continue;
                IlrTraceBuilder.printStackTrace(ourCause, ps);
            }
            Collection<ilog.rules.util.issue.IlrWarning> warnings = ex.getWarnings();
            for (ilog.rules.util.issue.IlrWarning w : warnings) {
                String message = w.getMessage() + NL;
                ps.write(message.getBytes("UTF-8"));
                if (w.getSourceException() == null) continue;
                StackTraceElement[] trace = w.getSourceException().getStackTrace();
                for (int j = 0; j < trace.length; ++j) {
                    ps.println("\tat " + trace[j]);
                }
                Throwable ourCause = t.getCause();
                if (ourCause == null) continue;
                IlrTraceBuilder.printStackTrace(ourCause, ps);
            }
            return;
        }
        String message = t.getMessage();
        if (message != null) {
            ps.write(message.getBytes("UTF-8"));
        } else {
            ps.write(t.toString().getBytes("UTF-8"));
        }
        ps.println();
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            ps.println("\tat " + trace[i]);
        }
        Throwable ourCause = t.getCause();
        if (ourCause != null) {
            IlrTraceBuilder.printStackTrace(ourCause, ps);
        }
    }

    private static IlrDWTraceFilterImpl parseDWFilter(Map<String, String> rulesetProps) throws IlrSessionException {
        IlrDWTraceFilterImpl dwFilter = new IlrDWTraceFilterImpl();
        dwFilter.setInfoAllFilters(false);
        String bamFilters = rulesetProps.get("monitoring.filters");
        if (bamFilters == null) {
            dwFilter.setInfoAllFilters(true);
        } else if (bamFilters.length() > 0) {
            Map<String, String> filtersAsInRSProperties = IlrTraceOptionsParser.extractBAMFiltersProperties(bamFilters);
            dwFilter.loadFromProperties(filtersAsInRSProperties);
            IlrTraceBuilder.addInputOutputFiltersIfNotExplicitelyFilteredOut(filtersAsInRSProperties, dwFilter);
        }
        return dwFilter;
    }

    private static IlrDWTraceFilterImpl buildMergedFilter(boolean traceEnabled, boolean dwEnabled, IlrTraceFilter traceFilter, IlrDWTraceFilterImpl dwFilter) {
        IlrDWTraceFilterImpl mergedFilter = new IlrDWTraceFilterImpl(false);
        if (traceEnabled) {
            IlrTraceBuilder.addEnabledBooleanFilters(mergedFilter, traceFilter);
            mergedFilter.setWorkingMemoryFilter(traceFilter.getWorkingMemoryFilter());
        }
        if (dwEnabled) {
            IlrTraceBuilder.addEnabledBooleanFilters(mergedFilter, dwFilter);
            IlrTraceBuilder.addRulesIfTotalRulesEnabled(dwFilter, mergedFilter);
            IlrTraceBuilder.addTaksIfTotalTasksEnabled(dwFilter, mergedFilter);
            IlrTraceBuilder.noWorkingMemoryfilterForDWAsWeDontStoreAnyWMTrace();
        }
        return mergedFilter;
    }

    private static void noWorkingMemoryfilterForDWAsWeDontStoreAnyWMTrace() {
    }

    private static void addEnabledBooleanFilters(IlrDWTraceFilterImpl mergedFilter, IlrTraceFilter traceFilter) {
        if (traceFilter instanceof IlrTraceFilterBase) {
            IlrTraceFilterBase filterSrc = (IlrTraceFilterBase)traceFilter;
            mergedFilter.setFilters(filterSrc);
            return;
        }
        Map<String, String> apiFilters = traceFilter.toMap();
        for (Map.Entry<String, String> entry : apiFilters.entrySet()) {
            String filterName = entry.getKey();
            String filterValue = entry.getValue();
            if (!Boolean.parseBoolean(filterValue)) continue;
            mergedFilter.setFilter(filterName, filterValue);
        }
    }

    private static void addTaksIfTotalTasksEnabled(IlrDWTraceFilter dwFilter, IlrDWTraceFilter result) {
        if (dwFilter.isInfoTotalTasks()) {
            result.setInfoTasks(true);
        }
    }

    private static void addRulesIfTotalRulesEnabled(IlrDWTraceFilter dwFilter, IlrDWTraceFilter result) {
        if (dwFilter.isInfoTotalRules()) {
            result.setInfoRules(true);
        }
    }

    private static void addInputOutputFiltersIfNotExplicitelyFilteredOut(Map<String, String> filtersAsInRSProperties, IlrDWTraceFilter mergedFilter) {
        if (!filtersAsInRSProperties.containsKey("INFO_INPUT_PARAMETERS")) {
            mergedFilter.setInfoInputParameters(true);
        }
        if (!filtersAsInRSProperties.containsKey("INFO_OUTPUT_PARAMETERS")) {
            mergedFilter.setInfoOutputParameters(true);
        }
    }

    private void addBOMNotEnabledWarningIfNotAlreadyThere() {
        String key = IlrSessionLocalization.BOM_NOT_ENABLED_FOR_DW_TRACE_WARNING;
        for (IlrWarning warning : this.dwRelatedWarnings) {
            if (!key.equals(warning.getMessageCode())) continue;
            return;
        }
        this.addWarningRelatedToDW(key, null, null);
    }

    private void addWarningRelatedToDW(String messageCode, String[] messageParams, Throwable errorCause) {
        IlrSessionWarningImpl w = new IlrSessionWarningImpl("ilog.rules.res.session.messages", messageCode, (Object[])messageParams, errorCause);
        this.dwRelatedWarnings.add(w);
    }

    private IlrExecutionTraceImpl applyFilter(IlrExecutionTraceImpl trace, IlrTraceFilter traceFilter) {
        return IlrExecutionTraceImpl.newInstance(trace, traceFilter);
    }

    public void configureTraceInXUSession(XURuleEngineSession xuSession) throws IlrSessionException {
        if (this.isSomeTracingEnabled()) {
            try {
                xuSession.resetRulesetExecutionTrace();
                int filterMask = this.convertToFilterMask(this.mergedFilter);
                Properties filterProperties = this.convertToXUFilterProperties(this.mergedFilter);
                xuSession.enableRulesetExecutionInformation(filterMask, filterProperties);
            }
            catch (XUException re) {
                throw new IlrSessionException(re);
            }
        }
    }

    private int convertToFilterMask(IlrDWTraceFilter filter) {
        int filterMask = 0;
        if (filter.isInfoInetAddress().booleanValue()) {
            filterMask |= 0x4000;
        }
        if (filter.isInfoRules().booleanValue() || filter.isInfoTotalRules()) {
            filterMask |= 4;
        }
        if (filter.isInfoTasks().booleanValue() || filter.isInfoTotalTasks()) {
            filterMask |= 8;
        }
        if (filter.isInfoTotalRulesNotFired().booleanValue()) {
            filterMask |= 0x10;
        }
        if (filter.isInfoTotalTasksExecuted().booleanValue()) {
            filterMask |= 1;
        }
        if (filter.isInfoTotalTasksNotExecuted().booleanValue()) {
            filterMask |= 0x20;
        }
        if (filter.isInfoExecutionEvents().booleanValue()) {
            filterMask |= 2;
            filterMask |= 0x800;
            filterMask |= 0x1000;
        }
        if (filter.isInfoRulesNotFired().booleanValue()) {
            filterMask |= 0x40;
        }
        if (filter.isInfoTasksNotExecuted().booleanValue()) {
            filterMask |= 0x80;
        }
        if (!filter.isInfoExecutionEvents().booleanValue() && filter.isInfoTasksNotExecuted().booleanValue()) {
            filterMask |= 0x1000;
        }
        if (!filter.isInfoExecutionEvents().booleanValue() && filter.isInfoRulesNotFired().booleanValue()) {
            filterMask |= 0x800;
        }
        if (filter.isInfoWorkingMemory().booleanValue()) {
            filterMask |= 0x200;
        }
        if (filter.isInfoTotalRulesFired().booleanValue()) {
            filterMask |= 0x400;
        }
        if (filter.isInfoSystemProperties().booleanValue()) {
            filterMask |= 0x2000;
        }
        return filterMask;
    }

    protected Properties convertToXUFilterProperties(IlrTraceFilter filter) {
        String wmFilter;
        Properties filterProperties = new Properties();
        if (filter.isInfoWorkingMemory().booleanValue() && (wmFilter = filter.getWorkingMemoryFilter()) != null) {
            filterProperties.setProperty("WORKING_MEMORY_CLASS_NAMES", wmFilter);
        }
        if (filter.isInfoBoundObjectByRule().booleanValue()) {
            filterProperties.setProperty("BOUND_OBJECTS", "true");
        } else {
            filterProperties.setProperty("BOUND_OBJECTS", "false");
        }
        return filterProperties;
    }

    public boolean isSomeTracingEnabled() {
        return this.traceEnabled || this.dwEnabled;
    }

    public void buildResults(IlrSessionRequest request, IlrSessionResponse response, XURuleEngineSession xuSession) throws IlrSessionException {
        if (this.isSomeTracingEnabled()) {
            IlrExecutionTraceImpl mergedExecutionTrace = this.createMergedExecutionTrace(xuSession);
            this.executionTrace = this.traceEnabled ? this.applyFilter(mergedExecutionTrace, this.traceFilter) : null;
            this.dwTrace = this.dwEnabled ? this.toDWTrace(this.dwFilter, mergedExecutionTrace, request, response, xuSession) : null;
        }
    }

    protected IlrExecutionTraceImpl createMergedExecutionTrace(XURuleEngineSession xuSession) throws IlrSessionException {
        IlrExecutionTraceImpl mergedExecutionTrace;
        try {
            mergedExecutionTrace = IlrXUExecutionTraceConverter.convertXUSessionTrace(xuSession.getRulesetExecutionTrace(), this.mergedFilter);
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
        if (this.mergedFilter.isInfoExecutionDuration().booleanValue()) {
            mergedExecutionTrace.setExecutionDuration(System.currentTimeMillis() - this.startTime);
        }
        if (this.mergedFilter.isInfoExecutionDate().booleanValue()) {
            mergedExecutionTrace.setExecutionDate(new Date(this.startTime));
        }
        return mergedExecutionTrace;
    }

    public IlrExecutionTrace getExecutionTrace() {
        return this.executionTrace;
    }

    public boolean isDWEnabled() {
        return this.dwEnabled;
    }

    private Map<String, String> serializeParametersUsingBOMSerialization(XURuleEngineSession xuEngineSession, boolean inIfTrueElseOut) throws XUException {
        HashMap<String, String> serializedParams = new HashMap<String, String>();
        Map<String, String> inParamsAsBOM = xuEngineSession.getParametersAsXMLBOM(inIfTrueElseOut ? (byte)1 : 2, this.inOutParamsSerializationFilters, true);
        for (String k : inParamsAsBOM.keySet()) {
            String v = inParamsAsBOM.get(k);
            serializedParams.put(k, String.valueOf(v));
        }
        return serializedParams;
    }

    private Map<String, String> serializeParametersUsing_toString_(Map<String, Object> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : params.keySet()) {
            Object value = params.get(key);
            String s = value == null ? null : value.toString();
            map.put(key, s);
        }
        return map;
    }

    public void startExecutionStopwatch() {
        if (this.mergedFilter.isInfoExecutionDuration().booleanValue() || this.mergedFilter.isInfoExecutionDate().booleanValue()) {
            this.startTime = System.currentTimeMillis();
        }
    }

    private void logTrace(IlrDWTrace trace, IlrSessionRequest request, IlrSessionResponse response) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuffer sb = new StringBuffer();
            sb.append("\nruleset execution id: ");
            sb.append(trace.getExecutionId() + NL);
            sb.append("executed ruleset path: ");
            sb.append(trace.getExecutedRulesetPath() + NL);
            sb.append("execution duration: ");
            sb.append(trace.getExecutionDuration());
            sb.append("ms\n");
            sb.append("total rules fired: ");
            sb.append(trace.getTotalRulesFired() + NL);
            String fullXmlTrace = null;
            try {
                fullXmlTrace = new IlrXMLExecutionTraceSerializer(trace).getXMLString();
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, IlrSessionLocalization.SERIALIZING_TRACE_TO_XML_ERROR, null, e);
            }
            if (fullXmlTrace != null) {
                sb.append("full execution trace length: ");
                sb.append(fullXmlTrace.length() + NL);
            }
            this.logExecutionEvents(trace.getExecutionEvents(), sb, "> ");
            LOGGER.info(IlrSessionLocalization.DECISION_WAREHOUSE_TRACE_INSTRUMENTATION, new String[]{sb.toString()});
            if (LOGGER.isLoggable(Level.FINEST)) {
                String execId = trace.getExecutionId();
                for (IlrWarning warning : response.getWarnings()) {
                    LOGGER.log(Level.FINEST, IlrSessionLocalization.SESSION_RESPONSE_WARNING, new String[]{execId, warning.getMessage()}, warning.getErrorCause());
                }
                StringBuffer sb2 = new StringBuffer();
                sb2.append("\nruleset execution id: ");
                sb2.append(trace.getExecutionId() + NL);
                sb2.append(fullXmlTrace == null ? "NO XML TRACE" : fullXmlTrace);
                LOGGER.log(Level.FINEST, IlrSessionLocalization.DECISION_WAREHOUSE_WARNING_INSTRUMENTATION, new String[]{sb2.toString()}, null);
            }
        }
    }

    private void logExecutionEvents(List<IlrExecutionEvent> eventList, StringBuffer sb, String indent) {
        for (IlrExecutionEvent event : eventList) {
            sb.append(indent + event.getName() + NL);
            if (!(event instanceof IlrTaskEvent)) continue;
            this.logExecutionEvents(((IlrTaskEvent)event).getSubExecutionEvents(), sb, indent + INDENT_INCREMENT);
        }
    }
}

