/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.internal;

import ilog.rules.archive.IlrJarArchiveLoader;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.archive.IlrRulesetArchiveLoader;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.session.IlrManagementSession;
import ilog.rules.res.session.IlrRuleServiceException;
import ilog.rules.res.session.IlrSessionCreationException;
import ilog.rules.res.session.IlrSessionException;
import ilog.rules.res.session.IlrSessionFactory;
import ilog.rules.res.session.IlrSessionResponse;
import ilog.rules.res.session.IlrStatefulSession;
import ilog.rules.res.session.IlrStatelessSession;
import ilog.rules.res.session.internal.IlrParametersProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.JarInputStream;

public abstract class IlrRuleServiceBase {
    protected IlrSessionFactory factory;
    protected IlrStatelessSession session;
    protected IlrManagementSession mgtSession;
    protected IlrMutableRepository repository;
    protected IlrRepositoryFactory repositoryFactory;
    protected ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    public IlrRuleServiceBase(IlrSessionFactory factory) {
        this.factory = factory;
    }

    protected synchronized IlrStatelessSession getStatelessSession() throws IlrSessionCreationException {
        if (this.session == null) {
            this.session = this.factory.createStatelessSession();
        }
        return this.session;
    }

    protected synchronized IlrManagementSession getManagementSession() throws IlrSessionCreationException {
        if (this.mgtSession == null) {
            this.mgtSession = this.factory.createManagementSession();
        }
        return this.mgtSession;
    }

    protected synchronized IlrRepositoryFactory getRepositoryFactory() throws IlrSessionCreationException, IlrSessionException {
        if (this.repositoryFactory == null) {
            this.repositoryFactory = this.getManagementSession().getRepositoryFactory();
        }
        return this.repositoryFactory;
    }

    protected synchronized IlrMutableRepository getRepository() throws IlrSessionCreationException, IlrSessionException {
        if (this.repository == null) {
            this.repository = this.getRepositoryFactory().createRepository();
        }
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IlrRulesetArchive loadRulesetArchive(InputStream inputStream) throws IOException {
        JarInputStream archiveStream = new JarInputStream(inputStream);
        try {
            IlrRulesetArchive ilrRulesetArchive = IlrRulesetArchive.extractArchive((IlrRulesetArchiveLoader)new IlrJarArchiveLoader(archiveStream));
            return ilrRulesetArchive;
        }
        finally {
            try {
                archiveStream.close();
            }
            catch (IOException e) {}
        }
    }

    protected IlrSessionResponse executeRuleset(IlrPath rulesetPath, Map<String, Object> params, IlrParametersProvider paramsProvider, boolean trace) throws IlrRuleServiceException {
        Map<String, Object> engineIParams = null;
        IlrStatefulSession session = null;
        try {
            Map<String, Object> respParams;
            Map<String, Object> nparams;
            this.rwLock.readLock().lock();
            session = this.factory.createStatefulSession(rulesetPath, null, null, true);
            if (trace) {
                session.setTraceEnabled(true);
                session.getTraceFilter().setInfoExecutionDuration(true);
                session.getTraceFilter().setInfoRules(true);
                session.getTraceFilter().setInfoTasks(true);
                session.getTraceFilter().setInfoTotalRulesFired(true);
                session.getTraceFilter().setInfoExecutionEvents(true);
            }
            engineIParams = paramsProvider == null ? params : paramsProvider.getInputParameters(params, session);
            IlrSessionResponse resp = session.execute(engineIParams);
            if (paramsProvider != null && (nparams = paramsProvider.getOutputParameters(respParams = resp.getOutputParameters(), session)) != respParams) {
                respParams.clear();
                respParams.putAll(nparams);
            }
            IlrSessionResponse ilrSessionResponse = resp;
            return ilrSessionResponse;
        }
        catch (IlrSessionException e) {
            throw new IlrRuleServiceException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
            this.rwLock.readLock().unlock();
        }
    }
}

