/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.ruleset;

import ilog.rules.res.session.ruleset.IlrExecutionEvent;
import ilog.rules.res.session.ruleset.IlrExecutionTrace;
import ilog.rules.res.session.ruleset.IlrRuleEvent;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.IlrTaskEvent;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.util.IlrIdConverter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class IlrBusinessExecutionTrace
implements IlrExecutionTrace {
    private static final long serialVersionUID = 1L;
    protected IlrExecutionTrace trace;

    public IlrBusinessExecutionTrace(IlrExecutionTrace trace) {
        this.trace = trace;
    }

    public Set<String> getTaskNotExecutedBusinessNames() {
        Set<IlrTaskInformation> notExecutedTasks = this.trace.getTasksNotExecuted();
        if (notExecutedTasks == null) {
            return null;
        }
        HashSet<String> notExecutedTaskBusinessNames = new HashSet<String>(notExecutedTasks.size());
        for (IlrTaskInformation notExecutedTask : notExecutedTasks) {
            notExecutedTaskBusinessNames.add(notExecutedTask.getBusinessName());
        }
        return notExecutedTaskBusinessNames;
    }

    public Set<String> getdRuleNotFiredBusinessNames() {
        Set<IlrRuleInformation> notFiredRules = this.trace.getRulesNotFired();
        if (notFiredRules == null) {
            return null;
        }
        HashSet<String> notFiredRuleBusinessNames = new HashSet<String>(notFiredRules.size());
        for (IlrRuleInformation notFiredRule : notFiredRules) {
            notFiredRuleBusinessNames.add(notFiredRule.getBusinessName());
        }
        return notFiredRuleBusinessNames;
    }

    public Set<String> getAllRuleBusinessNames() {
        Map<String, IlrRuleInformation> allRules = this.trace.getRules();
        if (allRules == null) {
            return null;
        }
        HashSet<String> allRuleBusinessNames = new HashSet<String>(allRules.size());
        for (IlrRuleInformation rule : allRules.values()) {
            allRuleBusinessNames.add(rule.getBusinessName());
        }
        return allRuleBusinessNames;
    }

    public Set<String> getAllTaskBusinessNames() {
        Map<String, IlrTaskInformation> allTasks = this.trace.getTasks();
        if (allTasks == null) {
            return null;
        }
        HashSet<String> allTaskBusinessNames = new HashSet<String>(allTasks.size());
        for (IlrTaskInformation task : allTasks.values()) {
            allTaskBusinessNames.add(task.getBusinessName());
        }
        return allTaskBusinessNames;
    }

    public List<String> getRuleFiredBusinessNames() {
        List<IlrExecutionEvent> events = this.trace.getExecutionEvents();
        if (events == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(events.size());
        this.addRuleFiredBusinessNames(events, result);
        return result;
    }

    public List<String> getTaskExecutedBusinessNames() {
        List<IlrExecutionEvent> events = this.trace.getExecutionEvents();
        if (events == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(events.size());
        this.addTaskExecutedBusinessNames(events, result);
        return result;
    }

    protected void addRuleFiredBusinessNames(List<IlrExecutionEvent> executionEvents, List<String> firedRuleBusinessNames) {
        Map<String, IlrRuleInformation> allRules = this.trace.getRules();
        if (executionEvents != null && allRules != null) {
            for (IlrExecutionEvent event : executionEvents) {
                if (event instanceof IlrRuleEvent) {
                    IlrRuleEvent revt = (IlrRuleEvent)event;
                    String bname = revt.getRuleInformation() != null ? revt.getRuleInformation().getBusinessName() : null;
                    if (bname == null && allRules.get(event.getName()) != null) {
                        bname = allRules.get(event.getName()).getBusinessName();
                    }
                    if (bname == null) {
                        bname = IlrIdConverter.getBusinessIdentifier(revt.getName());
                    }
                    firedRuleBusinessNames.add(bname);
                    continue;
                }
                List<IlrExecutionEvent> subEvents = ((IlrTaskEvent)event).getSubExecutionEvents();
                this.addRuleFiredBusinessNames(subEvents, firedRuleBusinessNames);
            }
        }
    }

    protected void addTaskExecutedBusinessNames(List<IlrExecutionEvent> events, List<String> executedTaskBusinessNames) {
        Map<String, IlrTaskInformation> allTasks = this.trace.getTasks();
        if (allTasks != null && events != null) {
            for (IlrExecutionEvent event : events) {
                if (!(event instanceof IlrTaskEvent)) continue;
                List<IlrExecutionEvent> subEvents = ((IlrTaskEvent)event).getSubExecutionEvents();
                executedTaskBusinessNames.add(allTasks.get(event.getName()).getBusinessName());
                this.addTaskExecutedBusinessNames(subEvents, executedTaskBusinessNames);
            }
        }
    }

    @Override
    public Map<String, IlrRuleInformation> getRules() {
        return this.trace.getRules();
    }

    @Override
    public Map<String, IlrTaskInformation> getTasks() {
        return this.trace.getTasks();
    }

    @Override
    public Date getExecutionDate() {
        return this.trace.getExecutionDate();
    }

    @Override
    public Long getExecutionDuration() {
        return this.trace.getExecutionDuration();
    }

    @Override
    public List<IlrExecutionEvent> getExecutionEvents() {
        return this.trace.getExecutionEvents();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.trace.getInetAddress();
    }

    @Override
    public Set<IlrRuleInformation> getRulesNotFired() {
        return this.trace.getRulesNotFired();
    }

    @Override
    public Properties getSystemProperties() {
        return this.trace.getSystemProperties();
    }

    @Override
    public Set<IlrTaskInformation> getTasksNotExecuted() {
        return this.trace.getTasksNotExecuted();
    }

    @Override
    public Long getTotalRulesFired() {
        return this.trace.getTotalRulesFired();
    }

    @Override
    public Long getTotalRulesNotFired() {
        return this.trace.getTotalRulesNotFired();
    }

    @Override
    public Long getTotalTasksExecuted() {
        return this.trace.getTotalTasksExecuted();
    }

    @Override
    public Long getTotalTasksNotExecuted() {
        return this.trace.getTotalTasksNotExecuted();
    }

    @Override
    public Collection<Object> getWorkingMemory() {
        return this.trace.getWorkingMemory();
    }
}

