/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.util;

import ilog.rules.res.session.ruleset.impl.IlrExecutionTraceImpl;
import ilog.rules.res.session.util.IlrXMLExecutionTraceConstants;
import ilog.rules.res.session.util.sax.IlrExecutionEventsSAXReader;
import ilog.rules.res.session.util.sax.IlrRulesNotFiredSAXReader;
import ilog.rules.res.session.util.sax.IlrRulesSAXReader;
import ilog.rules.res.session.util.sax.IlrSAXReaderHelper;
import ilog.rules.res.session.util.sax.IlrTasksNotExecutedSAXReader;
import ilog.rules.res.session.util.sax.IlrTasksSAXReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class IlrSAXExecTraceHandler
extends DefaultHandler
implements IlrXMLExecutionTraceConstants {
    private IlrExecutionTraceImpl executionTrace;
    private final CharArrayWriter text = new CharArrayWriter();
    private IlrSAXReaderHelper readerHelper = null;
    private int executionEventsCount = 0;

    IlrSAXExecTraceHandler() {
    }

    public String getText() {
        return this.text.toString().trim();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.text.reset();
        if (qName.equals("execution-trace")) {
            this.executionTrace = new IlrExecutionTraceImpl();
        } else if (qName.equals("rules")) {
            this.readerHelper = new IlrRulesSAXReader();
        } else if (qName.equals("tasks")) {
            this.readerHelper = new IlrTasksSAXReader();
        } else if (qName.equals("rules-not-fired")) {
            this.readerHelper = new IlrRulesNotFiredSAXReader();
        } else if (qName.equals("tasks-not-executed")) {
            this.readerHelper = new IlrTasksNotExecutedSAXReader();
        } else if (qName.equals("execution-events")) {
            if (this.executionEventsCount == 0) {
                this.readerHelper = new IlrExecutionEventsSAXReader();
            } else {
                this.readerHelper.startElement(qName, atts);
            }
            ++this.executionEventsCount;
        } else if (this.readerHelper != null) {
            this.readerHelper.startElement(qName, atts);
        }
    }

    private long getTextAsLong() {
        String txt = this.getText();
        if (txt != null && txt.length() > 0) {
            try {
                return Long.parseLong(txt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("total-rules-fired")) {
            this.executionTrace.setTotalRulesFired(this.getTextAsLong());
        } else if (qName.equals("total-rules-not-fired")) {
            this.executionTrace.setTotalRulesNotFired(this.getTextAsLong());
        } else if (qName.equals("total-tasks-executed")) {
            this.executionTrace.setTotalTasksExecuted(this.getTextAsLong());
        } else if (qName.equals("total-tasks-not-executed")) {
            this.executionTrace.setTotalTasksNotExecuted(this.getTextAsLong());
        } else if (qName.equals("execution-duration")) {
            this.executionTrace.setExecutionDuration(this.getTextAsLong());
        } else if (qName.equals("execution-date")) {
            String tstampStr = this.getText();
            if (tstampStr != null) {
                try {
                    long tstamp = Long.parseLong(tstampStr);
                    this.executionTrace.setExecutionDate(new Date(tstamp));
                }
                catch (NumberFormatException nfex) {
                    throw new SAXException(nfex);
                }
            }
        } else if (qName.equals("inet-address")) {
            try {
                this.executionTrace.setInetAddress(InetAddress.getByName(this.getText()));
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        } else if (qName.equals("system-properties")) {
            Properties prop = new Properties();
            try {
                StringReader reader = new StringReader(this.getText());
                prop.load(reader);
            }
            catch (UnsupportedEncodingException e) {
                throw new SAXException(e);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            this.executionTrace.setSystemProperties(prop);
        } else if (qName.equals("rules")) {
            this.executionTrace.setRules(((IlrRulesSAXReader)this.readerHelper).getRules());
            this.readerHelper = null;
        } else if (qName.equals("tasks")) {
            this.executionTrace.setTasks(((IlrTasksSAXReader)this.readerHelper).getTasks());
            this.readerHelper = null;
        } else if (qName.equals("rules-not-fired")) {
            this.executionTrace.setRulesNotFired(((IlrRulesNotFiredSAXReader)this.readerHelper).getRulesNotFired());
            this.readerHelper = null;
        } else if (qName.equals("tasks-not-executed")) {
            this.executionTrace.setTasksNotExecuted(((IlrTasksNotExecutedSAXReader)this.readerHelper).getTasksNotExecuted());
            this.readerHelper = null;
        } else if (qName.equals("execution-events")) {
            --this.executionEventsCount;
            if (this.executionEventsCount == 0) {
                this.executionTrace.setExecutionEvents(((IlrExecutionEventsSAXReader)this.readerHelper).getExecutionEvents());
                this.readerHelper = null;
            } else {
                this.readerHelper.endElement(qName, this.getText());
            }
        } else if (this.readerHelper != null) {
            this.readerHelper.endElement(qName, this.getText());
        }
    }

    @Override
    public void characters(char[] chars, int start, int len) throws SAXException {
        this.text.write(chars, start, len);
    }

    public IlrExecutionTraceImpl getExecutionTrace() {
        return this.executionTrace;
    }
}

