/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.util;

import ilog.rules.res.session.ruleset.impl.IlrExecutionTraceImpl;
import ilog.rules.res.session.util.IlrSAXExecTraceHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IlrXMLExecutionTraceDeserializer {
    private final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private final IlrExecutionTraceImpl executionTrace;

    public static Date parseDateNullSafe(String strTstamp) {
        if (strTstamp == null) {
            return null;
        }
        try {
            long l = Long.parseLong(strTstamp);
            return new Date(l);
        }
        catch (NumberFormatException nfex) {
            return null;
        }
    }

    public IlrXMLExecutionTraceDeserializer(String xmlExecutionTrace) throws IOException, ParserConfigurationException, SAXException {
        this(new InputSource(new StringReader(xmlExecutionTrace)));
    }

    public IlrXMLExecutionTraceDeserializer(InputStream xmlExecutionTrace) throws IOException, ParserConfigurationException, SAXException {
        this(new InputSource(xmlExecutionTrace));
    }

    public IlrXMLExecutionTraceDeserializer(InputSource xmlExecutionTrace) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = this.saxParserFactory.newSAXParser();
        IlrSAXExecTraceHandler handler = new IlrSAXExecTraceHandler();
        saxParser.parse(xmlExecutionTrace, (DefaultHandler)handler);
        this.executionTrace = handler.getExecutionTrace();
    }

    public IlrExecutionTraceImpl getExecutionTrace() {
        return this.executionTrace;
    }
}

