/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.util;

import ilog.rules.res.session.ruleset.IlrExecutionEvent;
import ilog.rules.res.session.ruleset.IlrExecutionTrace;
import ilog.rules.res.session.ruleset.IlrRuleAction;
import ilog.rules.res.session.ruleset.IlrRuleEvent;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.IlrTaskEvent;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.session.util.IlrXMLExecutionTraceConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IlrXMLExecutionTraceSerializer
implements IlrXMLExecutionTraceConstants {
    private final IlrExecutionTrace trace;
    private final Document document;
    private final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

    public IlrXMLExecutionTraceSerializer(IlrExecutionTrace trace) throws ParserConfigurationException {
        this.trace = trace;
        DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
        this.document = builder.getDOMImplementation().createDocument(null, "execution-trace", null);
        List<IlrExecutionEvent> events = trace.getExecutionEvents();
        if (events != null) {
            Element eventsNode = this.document.createElement("execution-events");
            for (IlrExecutionEvent event : events) {
                this.appendNode(eventsNode, this.getTagName(event), event);
            }
            this.document.getDocumentElement().appendChild(eventsNode);
        }
        this.appendFirstLevelNode("total-rules-fired");
        this.appendFirstLevelNode("total-rules-not-fired");
        this.appendFirstLevelNode("total-tasks-executed");
        this.appendFirstLevelNode("total-tasks-not-executed");
        this.appendFirstLevelNode("execution-date");
        this.appendFirstLevelNode("execution-duration");
        this.appendFirstLevelNode("inet-address");
        this.appendFirstLevelNode("system-properties");
        this.appendFirstLevelNode("rules");
        this.appendFirstLevelNode("tasks");
        this.appendFirstLevelNode("rules-not-fired");
        this.appendFirstLevelNode("tasks-not-executed");
    }

    public IlrExecutionTrace getExecutionTrace() {
        return this.trace;
    }

    private String getTagName(IlrExecutionEvent evt) {
        if (evt instanceof IlrRuleEvent) {
            return "rule";
        }
        return "task";
    }

    public Document getXMLDocument() {
        return this.document;
    }

    public String getXMLString() throws ParserConfigurationException, TransformerException {
        return this.toString(this.getXMLDocument());
    }

    private String toCamelCase(String toCamelCase) {
        StringBuffer result = new StringBuffer();
        int length = toCamelCase.length();
        boolean upperCase = true;
        for (int i = 0; i < length; ++i) {
            char c = toCamelCase.charAt(i);
            if (upperCase) {
                result.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            if (c == '-') {
                upperCase = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private Object extractTraceValue(String propertyName) {
        try {
            Method readMethod = this.trace.getClass().getDeclaredMethod("get" + this.toCamelCase(propertyName), new Class[0]);
            return readMethod.invoke((Object)this.trace, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void appendFirstLevelNode(String propertyName) {
        this.appendNode(this.document.getDocumentElement(), propertyName, this.extractTraceValue(propertyName));
    }

    private static void appendRuleAction(Document doc, Node parentNode, String actionName) {
        Element actionElt = doc.createElement("action");
        parentNode.appendChild(actionElt);
        actionElt.setAttribute("name", actionName);
    }

    private static void appendRuleActions(Document doc, Node parentNode, Collection<IlrRuleAction> actions) {
        Element elt = doc.createElement("actions");
        parentNode.appendChild(elt);
        for (IlrRuleAction a : actions) {
            IlrXMLExecutionTraceSerializer.appendRuleAction(doc, elt, a.getName());
        }
    }

    private Node appendNode(Node parent, String nodeName, Object value) {
        if (value != null) {
            Node n;
            if (nodeName != null) {
                n = this.document.createElement(nodeName);
                parent.appendChild(n);
            } else {
                n = parent;
            }
            if (value instanceof IlrExecutionEvent) {
                IlrExecutionEvent execEvt = (IlrExecutionEvent)value;
                this.appendNode(n, "name", execEvt.getName());
                this.appendNode(n, "start", execEvt.getStartDate());
                this.appendNode(n, "end", execEvt.getEndDate());
                if (execEvt instanceof IlrRuleEvent) {
                    IlrRuleEvent ruleEvt = (IlrRuleEvent)execEvt;
                    this.appendNode(n, null, ruleEvt.getRuleInformation());
                    this.appendBoundObjects(n, ruleEvt.getObjects());
                    String action = ruleEvt.getActionName();
                    if (action != null) {
                        IlrXMLExecutionTraceSerializer.appendRuleAction(this.document, n, action);
                    }
                } else {
                    IlrTaskEvent taskEvent = (IlrTaskEvent)execEvt;
                    this.appendNode(n, null, taskEvent.getTaskInformation());
                    List<IlrExecutionEvent> nestedEvents = taskEvent.getSubExecutionEvents();
                    if (nestedEvents != null && nestedEvents.size() > 0) {
                        Element subEventsNode = this.document.createElement("execution-events");
                        for (IlrExecutionEvent evt : nestedEvents) {
                            this.appendNode(subEventsNode, this.getTagName(evt), evt);
                        }
                        n.appendChild(subEventsNode);
                    }
                }
            } else if (value instanceof IlrRuleInformation) {
                IlrRuleInformation ruleInfo = (IlrRuleInformation)value;
                Element ruleInfoNode = this.document.createElement("rule-info");
                this.appendNode(ruleInfoNode, "uuid", ruleInfo.getUUID());
                this.appendNode(ruleInfoNode, "name", ruleInfo.getName());
                this.appendNode(ruleInfoNode, "business-name", ruleInfo.getBusinessName());
                this.appendNode(ruleInfoNode, "properties", ruleInfo.getProperties());
                Collection<IlrRuleAction> actions = ruleInfo.getActions();
                if (actions != null) {
                    IlrXMLExecutionTraceSerializer.appendRuleActions(this.document, ruleInfoNode, actions);
                }
                n.appendChild(ruleInfoNode);
            } else if (value instanceof IlrTaskInformation) {
                IlrTaskInformation taskInfo = (IlrTaskInformation)value;
                Element taskInfoNode = this.document.createElement("task-info");
                this.appendNode(taskInfoNode, "uuid", taskInfo.getUUID());
                this.appendNode(taskInfoNode, "name", taskInfo.getName());
                this.appendNode(taskInfoNode, "business-name", taskInfo.getBusinessName());
                this.appendNode(taskInfoNode, "properties", taskInfo.getProperties());
                n.appendChild(taskInfoNode);
            } else if (value instanceof Map) {
                if (value instanceof Properties) {
                    Properties props = (Properties)value;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        props.store(bos, null);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    String s = bos.toString();
                    if (s != null) {
                        n.setTextContent(s);
                    }
                } else {
                    Map m = (Map)value;
                    Element mapNode = this.document.createElement(Map.class.getSimpleName());
                    for (Object k : m.keySet()) {
                        Object v = m.get(k);
                        Element entryNode = this.document.createElement("entry");
                        Element kNode = this.document.createElement("key");
                        kNode.setTextContent(k.toString());
                        entryNode.appendChild(kNode);
                        this.appendNode(entryNode, "value", v);
                        mapNode.appendChild(entryNode);
                    }
                    n.appendChild(mapNode);
                }
            } else if (value instanceof Collection) {
                Collection c = (Collection)value;
                for (Object o : c) {
                    this.appendNode(n, null, o);
                }
            } else if (value instanceof Date) {
                n.setTextContent(Long.toString(((Date)value).getTime()));
            } else if (value instanceof InetAddress) {
                n.setTextContent(((InetAddress)value).getCanonicalHostName());
            } else {
                n.setTextContent(value.toString());
            }
            return n;
        }
        return null;
    }

    private void appendBoundObjects(Node n, List<Object> objects) {
        if (objects == null || objects.size() == 0) {
            return;
        }
        Element objectsNode = this.document.createElement("bound-objects");
        for (Object o : objects) {
            Element objectNode = this.document.createElement("bound-object");
            String xmlValid = IlrXMLExecutionTraceSerializer.escapeInvalidXmlCharacters(String.valueOf(o));
            CDATASection cdata = this.document.createCDATASection(xmlValid);
            objectNode.appendChild(cdata);
            objectsNode.appendChild(objectNode);
        }
        n.appendChild(objectsNode);
    }

    private static String escapeInvalidXmlCharacters(String s) {
        int codePoint;
        StringBuilder returnString = new StringBuilder();
        for (int i = 0; i < s.length(); i += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(i);
            if (codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF) {
                returnString.append(Character.toChars(codePoint));
                continue;
            }
            returnString.append(65533);
        }
        return returnString.toString();
    }

    private String toString(Document theDocument) throws TransformerException {
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(theDocument);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }
}

