/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.util.sax;

import ilog.rules.res.session.ruleset.IlrExecutionEvent;
import ilog.rules.res.session.util.sax.IlrExecutionEventSAXReaderHelper;
import ilog.rules.res.session.util.sax.IlrRuleSAXReader;
import ilog.rules.res.session.util.sax.IlrSAXReaderHelper;
import ilog.rules.res.session.util.sax.IlrTaskSAXReader;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class IlrExecutionEventsSAXReader
implements IlrSAXReaderHelper {
    private final List<IlrExecutionEvent> executionEvents = new ArrayList<IlrExecutionEvent>();
    private IlrExecutionEventSAXReaderHelper readerHelper;
    private int eventCount = 0;

    @Override
    public void startElement(String qName, Attributes atts) {
        if (qName.equals("task")) {
            if (this.eventCount == 0) {
                this.readerHelper = new IlrTaskSAXReader();
            } else {
                this.readerHelper.startElement(qName, atts);
            }
            ++this.eventCount;
        } else if (qName.equals("rule")) {
            if (this.eventCount == 0) {
                this.readerHelper = new IlrRuleSAXReader();
            } else {
                this.readerHelper.startElement(qName, atts);
            }
            ++this.eventCount;
        } else if (this.readerHelper != null) {
            this.readerHelper.startElement(qName, atts);
        }
    }

    @Override
    public void endElement(String qName, String content) {
        if (qName.equals("task") || qName.equals("rule")) {
            --this.eventCount;
            if (this.eventCount == 0) {
                if (this.readerHelper != null) {
                    this.executionEvents.add(this.readerHelper.getExecutionEvent());
                }
            } else if (this.readerHelper != null) {
                this.readerHelper.endElement(qName, content);
            }
        } else if (this.readerHelper != null) {
            this.readerHelper.endElement(qName, content);
        }
    }

    public List<IlrExecutionEvent> getExecutionEvents() {
        return this.executionEvents;
    }
}

