/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.util.sax;

import ilog.rules.res.session.ruleset.IlrExecutionEvent;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.impl.IlrRuleEventImpl;
import ilog.rules.res.session.util.IlrXMLExecutionTraceDeserializer;
import ilog.rules.res.session.util.sax.IlrBoundObjectsSAXReader;
import ilog.rules.res.session.util.sax.IlrExecutionEventSAXReaderHelper;
import ilog.rules.res.session.util.sax.IlrRuleInformationSAXReader;
import java.util.Date;
import java.util.List;
import org.xml.sax.Attributes;

public class IlrRuleSAXReader
implements IlrExecutionEventSAXReaderHelper {
    private String name;
    private Date start;
    private Date end;
    private IlrRuleInformationSAXReader ruleInfoReader;
    private IlrBoundObjectsSAXReader boundObjectsReader;
    private List<Object> boundObjects;
    private IlrRuleInformation ruleInformation;
    private String action;

    @Override
    public final void startElement(String qName, Attributes atts) {
        if (qName.equals("rule-info")) {
            this.ruleInfoReader = new IlrRuleInformationSAXReader();
        } else if (qName.equals("bound-objects")) {
            this.boundObjectsReader = new IlrBoundObjectsSAXReader();
        } else if (qName.equals("action")) {
            this.action = atts.getValue("name");
        } else if (this.ruleInfoReader != null) {
            this.ruleInfoReader.startElement(qName, atts);
        } else if (this.boundObjectsReader != null) {
            this.boundObjectsReader.startElement(qName, atts);
        }
    }

    @Override
    public final void endElement(String qName, String content) {
        if (qName.equals("name")) {
            this.name = content;
        } else if (qName.equals("start")) {
            this.start = IlrXMLExecutionTraceDeserializer.parseDateNullSafe(content);
        } else if (qName.equals("end")) {
            this.end = IlrXMLExecutionTraceDeserializer.parseDateNullSafe(content);
        } else if (qName.equals("bound-objects")) {
            this.boundObjects = this.boundObjectsReader.getObjects();
            this.boundObjectsReader = null;
        } else if (qName.equals("rule-info")) {
            this.ruleInformation = this.ruleInfoReader.getRuleInformation();
            this.ruleInfoReader = null;
        } else if (this.boundObjectsReader != null) {
            this.boundObjectsReader.endElement(qName, content);
        } else if (this.ruleInfoReader != null) {
            this.ruleInfoReader.endElement(qName, content);
        }
    }

    @Override
    public final IlrExecutionEvent getExecutionEvent() {
        return new IlrRuleEventImpl(this.name, this.start, this.end, 0, this.boundObjects, this.action, this.ruleInformation);
    }
}

