/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.util.sax;

import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.util.sax.IlrRulesEntrySAXReader;
import ilog.rules.res.session.util.sax.IlrSAXReaderHelper;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class IlrRulesSAXReader
implements IlrSAXReaderHelper {
    private final Map<String, IlrRuleInformation> rules = new HashMap<String, IlrRuleInformation>();
    private IlrRulesEntrySAXReader currentEntry;
    private int entryCount = 0;

    public Map<String, IlrRuleInformation> getRules() {
        return this.rules;
    }

    @Override
    public void startElement(String qName, Attributes atts) {
        if (qName.equals("entry")) {
            if (this.entryCount == 0) {
                this.currentEntry = new IlrRulesEntrySAXReader();
            }
            ++this.entryCount;
        } else if (this.currentEntry != null) {
            this.currentEntry.startElement(qName, atts);
        }
    }

    @Override
    public void endElement(String qName, String content) {
        if (qName.equals("entry")) {
            --this.entryCount;
        }
        if (this.entryCount == 0 && this.currentEntry != null) {
            this.rules.put(this.currentEntry.getKey(), this.currentEntry.getRuleInformation());
        } else if (this.currentEntry != null) {
            this.currentEntry.endElement(qName, content);
        }
    }
}

