/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.util.sax;

import ilog.rules.res.session.ruleset.IlrExecutionEvent;
import ilog.rules.res.session.ruleset.impl.IlrTaskEventImpl;
import ilog.rules.res.session.util.IlrXMLExecutionTraceDeserializer;
import ilog.rules.res.session.util.sax.IlrExecutionEventSAXReaderHelper;
import ilog.rules.res.session.util.sax.IlrExecutionEventsSAXReader;
import ilog.rules.res.session.util.sax.IlrTaskInformationSAXReader;
import java.util.Date;
import org.xml.sax.Attributes;

public class IlrTaskSAXReader
implements IlrExecutionEventSAXReaderHelper {
    private String name;
    private Date start;
    private Date end;
    private int executionEventsCount = 0;
    private IlrTaskInformationSAXReader taskInfoReader;
    private IlrExecutionEventsSAXReader executionEventsReader;

    @Override
    public void startElement(String qName, Attributes atts) {
        if (this.executionEventsReader == null && qName.equals("task-info")) {
            this.taskInfoReader = new IlrTaskInformationSAXReader();
        } else if (qName.equals("execution-events")) {
            if (this.executionEventsCount == 0) {
                this.executionEventsReader = new IlrExecutionEventsSAXReader();
            } else {
                this.executionEventsReader.startElement(qName, atts);
            }
            ++this.executionEventsCount;
        } else if (this.executionEventsReader == null) {
            if (this.taskInfoReader != null) {
                this.taskInfoReader.startElement(qName, atts);
            }
        } else {
            this.executionEventsReader.startElement(qName, atts);
        }
    }

    @Override
    public void endElement(String qName, String content) {
        if (qName.equals("name") && this.taskInfoReader == null) {
            this.name = content;
        } else if (qName.equals("start") && this.taskInfoReader == null) {
            this.start = IlrXMLExecutionTraceDeserializer.parseDateNullSafe(content);
        } else if (qName.equals("end") && this.taskInfoReader == null) {
            this.end = IlrXMLExecutionTraceDeserializer.parseDateNullSafe(content);
        } else if (this.executionEventsReader == null) {
            if (this.taskInfoReader != null) {
                this.taskInfoReader.endElement(qName, content);
            }
        } else if (qName.equals("execution-events")) {
            --this.executionEventsCount;
            if (this.executionEventsCount > 0) {
                this.executionEventsReader.endElement(qName, content);
            }
        } else {
            this.executionEventsReader.endElement(qName, content);
        }
    }

    @Override
    public IlrExecutionEvent getExecutionEvent() {
        return new IlrTaskEventImpl(this.name, this.start, this.end, this.executionEventsReader == null ? null : this.executionEventsReader.getExecutionEvents(), this.taskInfoReader == null ? null : this.taskInfoReader.getTaskInformation());
    }
}

