/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.util.sax;

import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.session.util.sax.IlrSAXReaderHelper;
import ilog.rules.res.session.util.sax.IlrTasksEntrySAXReader;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class IlrTasksSAXReader
implements IlrSAXReaderHelper {
    private final Map<String, IlrTaskInformation> tasks = new HashMap<String, IlrTaskInformation>();
    private IlrTasksEntrySAXReader currentEntry;
    private int entryCount = 0;

    public Map<String, IlrTaskInformation> getTasks() {
        return this.tasks;
    }

    @Override
    public void startElement(String qName, Attributes atts) {
        if (qName.equals("entry")) {
            if (this.entryCount == 0) {
                this.currentEntry = new IlrTasksEntrySAXReader();
            }
            ++this.entryCount;
        } else if (this.currentEntry != null) {
            this.currentEntry.startElement(qName, atts);
        }
    }

    @Override
    public void endElement(String qName, String content) {
        if (qName.equals("entry")) {
            --this.entryCount;
        }
        if (this.entryCount == 0 && this.currentEntry != null) {
            this.tasks.put(this.currentEntry.getKey(), this.currentEntry.getTaskInformation());
        } else if (this.currentEntry != null) {
            this.currentEntry.endElement(qName, content);
        }
    }
}

