/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.util;

import com.ibm.rules.res.message.internal.LocalizedMessage;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import java.lang.reflect.Method;
import java.util.Locale;

public class IlrRemoteException
extends Exception
implements LocalizedMessage {
    private static final long serialVersionUID = 1L;
    private final String exceptionClass;
    private final String resourceBundleName;
    private final String messageCode;
    private final Object[] messageParams;

    public IlrRemoteException(Throwable t) {
        super(t.getMessage());
        this.exceptionClass = t.getClass().getName();
        if (t instanceof LocalizedMessage) {
            LocalizedMessage lm = (LocalizedMessage)((Object)t);
            this.resourceBundleName = lm.getResourceBundleName();
            this.messageCode = lm.getMessageCode();
            this.messageParams = lm.getMessageParameters();
        } else {
            String tmpResourceBundleName = null;
            String tmpMessageCode = null;
            Object[] tmpMessageParams = null;
            try {
                Class<?> exceptionClass = t.getClass();
                Method getResourceBundleNameMethod = exceptionClass.getMethod("getResourceBundleName", new Class[0]);
                Method getMessageCodeMethod = exceptionClass.getMethod("getMessageCode", new Class[0]);
                Method getMessageParametersMethod = exceptionClass.getMethod("getMessageParameters", new Class[0]);
                tmpResourceBundleName = (String)getResourceBundleNameMethod.invoke((Object)t, new Object[0]);
                tmpMessageCode = (String)getMessageCodeMethod.invoke((Object)t, new Object[0]);
                tmpMessageParams = (Object[])getMessageParametersMethod.invoke((Object)t, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tmpResourceBundleName != null && tmpMessageCode != null && tmpMessageParams != null) {
                this.resourceBundleName = tmpResourceBundleName;
                this.messageCode = tmpMessageCode;
                this.messageParams = tmpMessageParams;
            } else {
                this.resourceBundleName = null;
                this.messageCode = null;
                this.messageParams = null;
            }
        }
        this.setStackTrace(t.getStackTrace());
        if (t.getCause() != null) {
            IlrRemoteException cause = new IlrRemoteException(t.getCause());
            this.initCause(cause);
        }
    }

    @Override
    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    @Override
    public String getMessageCode() {
        return this.messageCode;
    }

    @Override
    public Object[] getMessageParameters() {
        return this.messageParams;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return this.getLocalizedMessage(locale, this.getClass().getClassLoader());
    }

    public String getLocalizedMessage(Locale locale, ClassLoader cl) {
        if (this.resourceBundleName != null) {
            return LocalizedMessageHelper.getLocalizedMessage(this.resourceBundleName, this.messageCode, this.messageParams, locale, cl);
        }
        return super.getMessage();
    }

    @Override
    public String toString() {
        if (this.exceptionClass != null) {
            String s = this.exceptionClass;
            String message = this.getLocalizedMessage();
            return message != null ? s + ": " + message : s;
        }
        return super.toString();
    }
}

