/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.util.classloader;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class IlrClassLoaderUtil {
    public static ClassLoader getThreadClassLoader() {
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return cl;
    }

    public static Class<?> loadClassNoException(String className, ClassLoader classLoader) {
        try {
            if (classLoader == null) {
                return Class.forName(className);
            }
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

