/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public abstract class IlrFileStreamPrivilegedAction<T>
implements PrivilegedExceptionAction<T> {
    protected File file;

    public IlrFileStreamPrivilegedAction(File file) {
        this.file = file;
    }

    public static InputStream newInputStream(File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new IlrFileStreamPrivilegedAction<InputStream>(file){

                @Override
                public InputStream run() throws FileNotFoundException {
                    return new FileInputStream(this.file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    public static OutputStream newOutputStream(File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new IlrFileStreamPrivilegedAction<OutputStream>(file){

                @Override
                public OutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(this.file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }
}

