/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.util.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class IlrXMLSerializer {
    public static final String ENCODING_CHARSET_NAME = "UTF-8";
    private static final int WHITESPACES_PER_TAB = 2;
    private static final String WHITE_SPACES = "                             ";
    private Writer writer = null;
    private int depth = 0;
    private boolean beginingOfLine = true;

    public IlrXMLSerializer(Writer writer) {
        this.writer = writer;
    }

    public void writeXMLDeclaration() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    public void writeTag(String tagName, Map<String, String> attributes, boolean newline) throws IOException {
        this.writeTag(tagName, attributes, newline, true);
    }

    public void writeStartTag(String tagName, Map<String, String> attributes, boolean newline) throws IOException {
        this.writeTag(tagName, attributes, newline, false);
    }

    protected void writeTag(String tagName, Map<String, String> attributes, boolean newline, boolean closeTag) throws IOException {
        this.writeWhiteSpaces(this.depth * 2);
        this.writer.write("<");
        this.writer.write(tagName);
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.writer.write(" ");
                this.writer.write(entry.getKey());
                this.writer.write("=\"");
                this.writer.write(entry.getValue());
                this.writer.write("\"");
            }
        }
        if (closeTag) {
            this.writer.write("/>");
        } else {
            this.writer.write(">");
            ++this.depth;
        }
        if (newline) {
            this.writer.write("\n");
            this.beginingOfLine = true;
        }
    }

    public void writeStartTag(String tagName, boolean newline) throws IOException {
        this.writeStartTag(tagName, null, newline);
    }

    public void writeEndTag(String tagName) throws IOException {
        if (this.beginingOfLine) {
            this.writeWhiteSpaces((this.depth - 1) * 2);
        }
        this.writer.write("</");
        this.writer.write(tagName);
        this.writer.write(">\n");
        this.beginingOfLine = true;
        --this.depth;
    }

    public void writeBody(String body) throws IOException {
        if (body.length() == 0) {
            this.beginingOfLine = false;
        } else {
            for (int i = 0; i < body.length(); ++i) {
                char c = body.charAt(i);
                if (c == '&') {
                    this.writer.write("&amp;");
                } else if (c == '<') {
                    this.writer.write("&lt;");
                } else {
                    this.writer.write(c);
                }
                this.beginingOfLine = c == '\n';
            }
        }
    }

    private void writeWhiteSpaces(int count) throws IOException {
        int n = count / WHITE_SPACES.length();
        int r = count % WHITE_SPACES.length();
        for (int i = 0; i < n; ++i) {
            this.writer.write(WHITE_SPACES);
        }
        this.writer.write(WHITE_SPACES, 0, r);
    }
}

