/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.cci;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.bom.internal.BOMConverter;
import com.ibm.rules.res.xu.client.internal.RulesetExecutionListener;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.client.internal.XUWarning;
import com.ibm.rules.res.xu.client.internal.XUWarningListener;
import com.ibm.rules.res.xu.client.internal.jca.JCAWarning;
import com.ibm.rules.res.xu.client.internal.jca.XUInteraction;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.internal.LocalizedNotSupportedException;
import com.ibm.rules.res.xu.internal.LocalizedResourceException;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.log.internal.XULogRecordFactory;
import ilog.rules.bres.xu.event.IlrProfilingConnectionEvent;
import ilog.rules.bres.xu.event.IlrWarningEvent;
import ilog.rules.bres.xu.event.IlrWarningEventListener;
import ilog.rules.bres.xu.profiling.IlrProfilingHelper;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.cci.IlrConnectionContext;
import ilog.rules.res.xu.cci.IlrConnectionId;
import ilog.rules.res.xu.cci.IlrConnectionInformation;
import ilog.rules.res.xu.cci.IlrInteractionExtension;
import ilog.rules.res.xu.cci.IlrXUConnectionMetaData;
import ilog.rules.res.xu.cci.IlrXUConnectionSpec;
import ilog.rules.res.xu.cci.ruleset.IlrRulesetExecutionTrace;
import ilog.rules.res.xu.event.internal.IlrConnectionEventImpl;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import ilog.rules.res.xu.spi.IlrManagedConnectionContext;
import ilog.rules.res.xu.spi.IlrManagedXUConnection;
import ilog.rules.res.xu.spi.IlrManagedXUConnectionFactory;
import ilog.rules.xml.IlrXmlObject;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import javax.resource.cci.ResultSetInfo;

public final class IlrXUConnection
implements Connection,
IlrWarningEventListener,
XUWarningListener {
    public static final byte STATE_ACTIVE = 1;
    public static final byte STATE_CLOSED = 2;
    private byte state;
    private IlrManagedXUConnection spiConn;
    private IlrProfilingHelper profilingHelper;
    private IlrProfilingConnectionEvent profilingEvent;
    private final LogHandler logger;
    private final IlrConnectionInformation information;
    private final IlrConnectionContext context;
    private final boolean isFinestLoggable;
    private final boolean isFinerLoggable;
    private final boolean isFineLoggable;
    private final IlrXUEventDispatcher dispatcher;
    private ResourceWarning warning;
    private final IlrConnectionId id;
    private final int hashCode;
    private EngineManager engineMgr;

    public IlrXUConnection(IlrConnectionId id, IlrManagedXUConnection spiConn, IlrXUConnectionSpec spec) {
        this.id = id;
        this.hashCode = id.id;
        this.logger = spiConn.getLogHandler();
        this.isFinestLoggable = this.logger.isLoggable(Level.FINEST);
        this.isFinerLoggable = this.logger.isLoggable(Level.FINER);
        this.isFineLoggable = this.logger.isLoggable(Level.FINE);
        IlrManagedXUConnectionFactory managedFactory = spiConn.getFactory();
        this.dispatcher = managedFactory.getEventDispatcher();
        this.information = new IlrConnectionInformation(id, spiConn.getId(), spec);
        this.context = new IlrConnectionContext(this.information);
        this.setManagedConnection(spiConn);
        this.profilingHelper = spiConn.getProfiling();
        this.profilingEvent = this.profilingHelper.startConnectionMeasure(1, this.context);
        this.state = 1;
        IlrConnectionEventImpl event = new IlrConnectionEventImpl(0, (Object)this, this.context);
        this.dispatcher.connectionEventRaised(event);
        this.dispatcher.addListener(this, 4L);
    }

    public final EngineManager getEngineManager() {
        return this.engineMgr;
    }

    public final void setEngineManager(EngineManager engineMgr) {
        this.engineMgr = engineMgr;
    }

    public final boolean isFinestLoggable() {
        return this.isFinestLoggable;
    }

    public final IlrInteractionExtension[] getInteractionExtensions() {
        return this.spiConn.getInteractionExtensions();
    }

    public final IlrConnectionContext getContext() {
        return this.context;
    }

    public final IlrXUConnectionSpec getSpec() {
        return this.information.getConnectionSpec();
    }

    public final LogHandler getLogHandler() {
        return this.logger;
    }

    public final IlrManagedXUConnection getManagedConnection() {
        return this.spiConn;
    }

    public final IlrConnectionId getId() {
        return this.id;
    }

    public final void setManagedConnection(IlrManagedXUConnection managedConnection) {
        this.spiConn = managedConnection;
        this.information.setSPIConnectionId(managedConnection.getId());
    }

    private synchronized void checkConnectionActive() throws XUException {
        if (this.state == 2) {
            throw new XUException("XU.ERROR.10044");
        }
    }

    private final void checkConnection(byte type) throws XUException {
        this.checkConnectionActive();
        if (type == -1) {
            return;
        }
        byte connType = this.spiConn.getType();
        if (connType != -1 && connType != type) {
            throw new XUException("XU.ERROR.10043");
        }
    }

    public final boolean executeInteractionExtension(IlrInteractionExtension interaction, InteractionSpec interactionSpec, Record input, Record output) throws XUException {
        this.checkConnection(interaction.getConnectionType());
        return interaction.execute(this, interactionSpec, input, output);
    }

    public final void writeLog(String[] messages) throws XUException {
        try {
            this.checkConnection((byte)-1);
            this.spiConn.writeLog(messages);
        }
        catch (XUException e) {
            this.logException("writeLog", e);
            throw e;
        }
    }

    public final void setUserData(Serializable userData) throws XUException {
        try {
            this.checkConnection((byte)-1);
            this.getContext().getConnectionInformation().getConnectionSpec().setUserData(userData);
        }
        catch (XUException e) {
            this.logException("setUserData", e);
            throw e;
        }
    }

    public final String solveRulesetPath(String rulesetPath) throws XUException {
        try {
            this.checkConnection((byte)1);
            return this.spiConn.solveRulesetPath(rulesetPath);
        }
        catch (XUException e) {
            this.logException("solveRulesetPath", e);
            throw e;
        }
    }

    public final void notifyRulesetArchiveChanged(String canonicalRulesetPath) throws XUException {
        try {
            this.checkConnection((byte)1);
            this.spiConn.notifyRulesetArchiveChanged(canonicalRulesetPath, this.context);
        }
        catch (XUException e) {
            this.logException("notifyRulesetArchiveChanged", e);
            throw e;
        }
    }

    public final void startProfilingSession(Properties parameters) throws XUException {
        try {
            this.checkConnection((byte)1);
            this.spiConn.startProfilingSession(parameters, this.context);
        }
        catch (XUException e) {
            this.logException("startProfilingSession", e);
            throw e;
        }
    }

    public final void stopProfilingSession(Properties parameters) throws XUException {
        try {
            this.checkConnection((byte)1);
            this.spiConn.stopProfilingSession(parameters, this.context);
        }
        catch (XUException e) {
            this.logException("stopProfilingSession", e);
            throw e;
        }
    }

    public final void enableRulesetExecutionInformation(int filter, Map<String, String> props) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.enableRulesetExecutionInformation(this, filter, props);
        }
        catch (XUException e) {
            this.logException("enableRulesetExecutionInformation", e);
            throw e;
        }
    }

    public final int engineGetFiredRulesCount() throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.engineGetFiredRulesCount(this);
        }
        catch (XUException e) {
            this.logException("engineGetFiredRulesCount", e);
            throw e;
        }
    }

    public final Object[] engineGetWorkingMemory() throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.contextGetWorkingMemory(this);
        }
        catch (XUException e) {
            this.logException("engineGetWorkingMemory", e);
            throw e;
        }
    }

    public final Map<Object, Object> engineGetWorkingMemoryWithId() throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.contextGetWorkingMemoryWithId(this);
        }
        catch (XUException e) {
            this.logException("engineGetWorkingMemoryWithId", e);
            throw e;
        }
    }

    public final void engineAsyncExecute(RulesetExecutionListener listener) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.asynchronousExecuteRuleset(listener, this);
        }
        catch (XUException e) {
            this.logException("engineAsyncExecute", e);
            throw e;
        }
    }

    public final Map<String, Object> getXUProperties() throws XUException {
        try {
            this.checkConnection((byte)-1);
            return this.spiConn.getConnectorConfigProperties();
        }
        catch (XUException e) {
            this.logException("getXUProperties", e);
            throw e;
        }
    }

    public final IlrRulesetUsageInformationImpl getRulesetUsageInformation(String canonicalRulesetPath) throws XUException {
        try {
            this.checkConnection((byte)1);
            return this.spiConn.getRulesetUsageInformation(canonicalRulesetPath);
        }
        catch (XUException e) {
            this.logException("getRulesetUsageInformation", e);
            throw e;
        }
    }

    public final void startMaintenanceTasks() throws XUException {
        try {
            this.checkConnection((byte)1);
            this.spiConn.startMaintenanceTasks();
        }
        catch (XUException e) {
            this.logException("startMaintenanceTasks", e);
            throw e;
        }
    }

    public final void loadUptodateRuleset() throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.loadUptodateRuleset(this);
        }
        catch (XUException e) {
            this.logException("loadUptodateRuleset", e);
            throw e;
        }
    }

    private void logException(String interactionName, XUException e) {
        this.logger.severe("XU.ERROR.10001", e, new Object[]{interactionName}, null);
    }

    public final void engineExecute(Map<String, Object> params) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineExecute(this, params);
        }
        catch (XUException e) {
            this.logException("engineExecute", e);
            throw e;
        }
    }

    public final void engineGetParameters(byte direction, Map<String, Object> params) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.contextGetParameters(this, direction, params);
        }
        catch (XUException e) {
            this.logException("engineGetParameters", e);
            throw e;
        }
    }

    public final void engineGetXOMParameters(byte direction, Map<String, Object> params) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineGetXOMParameters(this, direction, params);
        }
        catch (XUException e) {
            this.logException("engineGetParameters", e);
            throw e;
        }
    }

    private static BOMConverter.ObjectKind getBOMParameterKind(int kind) {
        switch (kind) {
            case 1: {
                return BOMConverter.ObjectKind.KIND_JSON;
            }
            case 0: {
                return BOMConverter.ObjectKind.KIND_XML;
            }
        }
        throw new IllegalArgumentException();
    }

    public final Map<String, String> engineGetParametersAsBOM(byte dir, List<String> filters, boolean roAtts, int kind) throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.engineGetParametersAsBOM(this, dir, filters, roAtts, IlrXUConnection.getBOMParameterKind(kind));
        }
        catch (XUException e) {
            this.logException("engineGetParametersAsBOM", e);
            throw e;
        }
    }

    public final Object engineExecuteMain(Object param) throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.engineExecuteMain(this, param);
        }
        catch (XUException e) {
            this.logException("engineExecuteMain", e);
            throw e;
        }
    }

    public final void engineExecuteTask(String taskName, Map<String, Object> params) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.contextExecuteTask(this, taskName, params);
        }
        catch (XUException e) {
            this.logException("engineExecuteTask", e);
            throw e;
        }
    }

    public final String[] engineToBOM(List<Object> objs, int kind) throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.engineToBOM(this, objs, IlrXUConnection.getBOMParameterKind(kind));
        }
        catch (XUException e) {
            this.logException("engineToBOM", e);
            throw e;
        }
    }

    public final IlrXmlObject[] engineToXMLObjects(List<String> xmls) throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.engineToXMLObjects(this, xmls);
        }
        catch (XUException e) {
            this.logException("engineToXMLObjects", e);
            throw e;
        }
    }

    public final void engineInsert(List<Object> objects) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineInsert(this, objects);
        }
        catch (XUException e) {
            this.logException("engineInsert", e);
            throw e;
        }
    }

    public final void engineInsertWithId(List<Object> objects) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineInsertWithId(this, objects);
        }
        catch (XUException e) {
            this.logException("engineInsertWithId", e);
            throw e;
        }
    }

    public final void engineRetract(Object[] objects) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineRetract(this, objects);
        }
        catch (XUException e) {
            this.logException("engineRetract", e);
            throw e;
        }
    }

    public void engineRetractById(Object[] ids) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineRetractById(this, ids);
        }
        catch (XUException e) {
            this.logException("engineRetractById", e);
            throw e;
        }
    }

    public final void engineUpdate(Object[] objects) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineUpdate(this, objects);
        }
        catch (XUException e) {
            this.logException("engineUpdate", e);
            throw e;
        }
    }

    public final Object engineInvokeFunction(String name, Object[] objects) throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.engineInvokeFunction(this, name, objects);
        }
        catch (XUException e) {
            this.logException("engineInvokeFunction", e);
            throw e;
        }
    }

    public final void engineUpdateById(Object[] objects) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineUpdateById(this, objects);
        }
        catch (XUException e) {
            this.logException("engineUpdateById", e);
            throw e;
        }
    }

    public final void engineSetParameters(Map<String, Object> parameters) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineSetParameters(this, parameters);
        }
        catch (XUException e) {
            this.logException("engineSetParameters", e);
            throw e;
        }
    }

    public final void engineSetParametersAsBOM(Map<String, String> parameters, int kind) throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineSetParametersAsBOM(this, parameters, IlrXUConnection.getBOMParameterKind(kind));
        }
        catch (XUException e) {
            this.logException("engineSetParametersAsBOM", e);
            throw e;
        }
    }

    public final String engineGetOutput() throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.engineGetOutput(this);
        }
        catch (XUException e) {
            this.logException("engineGetOutput", e);
            throw e;
        }
    }

    public final void engineReset() throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineReset(this);
        }
        catch (XUException e) {
            this.logException("engineReset", e);
            throw e;
        }
    }

    public final void resetRulesetExecutionTrace() throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.resetRulesetExecutionTrace(this);
        }
        catch (XUException e) {
            this.logException("resetRulesetExecutionTrace", e);
            throw e;
        }
    }

    public final void engineRuleflowReset() throws XUException {
        try {
            this.checkConnection((byte)0);
            this.spiConn.engineRuleflowReset(this);
        }
        catch (XUException e) {
            this.logException("engineRuleflowReset", e);
            throw e;
        }
    }

    public final XURulesetParameter[] getRulesetParameters() throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.getRulesetParameters(this);
        }
        catch (XUException e) {
            this.logException("getRulesetParameters", e);
            throw e;
        }
    }

    public final IlrRulesetExecutionTrace getRulesetExecutionTrace() throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.getRulesetExecutionTrace(this);
        }
        catch (XUException e) {
            this.logException("getRulesetExecutionTrace", e);
            throw e;
        }
    }

    public final IlrXURulesetArchiveInformation getXURulesetArchiveInformation() throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.getXURulesetArchiveInformation(this);
        }
        catch (XUException e) {
            this.logException("getXURulesetArchiveInformation", e);
            throw e;
        }
    }

    public final Interaction createInteraction() throws ResourceException {
        try {
            this.checkConnectionActive();
            return new XUInteraction(this);
        }
        catch (XUException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public final LocalTransaction getLocalTransaction() throws ResourceException {
        throw new LocalizedNotSupportedException(XUMessageCode.ERROR_TRANSACTION_NOT_SUPPORTED);
    }

    public final ConnectionMetaData getMetaData() throws ResourceException {
        return new IlrXUConnectionMetaData();
    }

    public final ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new LocalizedNotSupportedException("XU.ERROR.10002", new String[]{"Connection.getResultSetInfo()"});
    }

    public final synchronized void close() throws ResourceException {
        if (this.isFinerLoggable) {
            this.getLogHandler().finer("XU.FINER.4101", new Object[]{this}, this.context);
        }
        try {
            if (this.state == 1) {
                this.spiConn.close(this);
            } else if (this.state == 2) {
                throw new LocalizedResourceException("XU.ERROR.10044", null);
            }
        }
        catch (ResourceException e) {
            LocalizedResourceException exception = new LocalizedResourceException("XU.ERROR.10037", null, e);
            this.getLogHandler().severe("XU.ERROR.10037", (Throwable)((Object)exception), null, this.context);
            throw exception;
        }
    }

    public final synchronized byte getState() {
        return this.state;
    }

    public final void closed() throws ResourceException {
        if (this.isFinestLoggable) {
            this.getLogHandler().finest(this.getClass().getName() + ".closed() " + this, null, this.context);
        }
        if (this.state == 2) {
            throw new LocalizedResourceException("XU.ERROR.10044", null);
        }
        this.state = (byte)2;
        IlrConnectionEventImpl event = new IlrConnectionEventImpl(1, (Object)this, this.context);
        this.dispatcher.connectionEventRaised(event);
        this.dispatcher.removeListener(this, 4L);
        this.profilingHelper.stopConnectionMeasure(this.profilingEvent);
        this.profilingHelper.sendConnectionEvent(this.profilingEvent);
        this.spiConn = null;
        this.profilingHelper = null;
        this.profilingEvent = null;
        if (this.isFineLoggable) {
            this.getLogHandler().fine("XU.FINER.4102", new Object[]{this.id}, this.context);
        }
    }

    public final int hashCode() {
        return this.hashCode;
    }

    private static String[] stringify(Object[] objs) {
        if (objs == null) {
            return null;
        }
        if (objs instanceof String[]) {
            return (String[])objs;
        }
        String[] strings = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            strings[i] = objs[i] == null || objs[i] instanceof String ? (String)objs[i] : objs[i].toString();
        }
        return strings;
    }

    @Override
    public final synchronized void warningRaised(IlrWarningEvent event) {
        IlrXUContext ctx;
        IlrConnectionContext cciCtx;
        if (this.state == 2) {
            return;
        }
        if (this.isFinestLoggable) {
            this.logger.finest("CCI interaction Received: " + event, null, this.getContext());
        }
        if ((cciCtx = (ctx = event.getXUContext()) instanceof IlrConnectionContext ? (IlrConnectionContext)ctx : (ctx instanceof IlrManagedConnectionContext ? ((IlrManagedConnectionContext)ctx).getConnectionContext() : null)) != null && this.getId().equals(cciCtx.getConnectionInformation().getConnectionId())) {
            if (this.isFinestLoggable) {
                this.logger.finest("CCI interaction Received: " + event + " concerning: " + cciCtx.getConnectionInformation().getConnectionId(), null, this.getContext());
            }
            String[] params = IlrXUConnection.stringify(event.getMessageVariableValues());
            this.warning = new JCAWarning(event.getMessageCode(), params, (Throwable)this.warning);
        }
    }

    @Override
    public final synchronized void xuWarningRaised(XUWarning xuwarning) {
        if (this.state == 2) {
            return;
        }
        String[] params = IlrXUConnection.stringify(xuwarning.getMessageParameters());
        this.warning = new JCAWarning(xuwarning.getMessageCode(), params, (Throwable)this.warning);
        this.logger.log(XULogRecordFactory.createXULogRecord(Level.WARNING, xuwarning.getMessageCode(), xuwarning.getCause(), xuwarning.getMessageParameters(), null));
    }

    public final synchronized ResourceWarning getWarnings() {
        return this.warning;
    }

    public final synchronized void clearWarnings() {
        if (this.isFinestLoggable) {
            this.logger.finest(this.getClass().getName() + ".clearWarnings()");
        }
        this.warning = null;
    }

    public final Object isRulesetUptodate() throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.isRulesetUptodate(this);
        }
        catch (XUException e) {
            this.logException("isRulesetUptodate", e);
            throw e;
        }
    }

    public final List<Object> engineToNodes(List<Object> xom) throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.engineToNodes(this, xom);
        }
        catch (XUException e) {
            this.logException("engineToNodes", e);
            throw e;
        }
    }

    public final List<Object> engineNodesToXOMObjects(List<Object> nodes) throws XUException {
        try {
            this.checkConnection((byte)0);
            return this.spiConn.engineNodesToXOMObjects(this, nodes);
        }
        catch (XUException e) {
            this.logException("engineNodesToXOMObjects", e);
            throw e;
        }
    }
}

