/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.cci;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.client.info.internal.XUInfo;
import com.ibm.rules.res.xu.client.internal.jca.XURecordFactory;
import com.ibm.rules.res.xu.internal.LocalizedResourceException;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import ilog.rules.res.xu.cci.IlrXUConnection;
import ilog.rules.res.xu.cci.IlrXUConnectionSpec;
import ilog.rules.res.xu.cci.IlrXUResourceAdapterMetaData;
import ilog.rules.res.xu.cci.diagnostic.internal.IlrXUDiagnosticResult;
import ilog.rules.res.xu.spi.IlrManagedXUConnectionFactory;
import ilog.rules.res.xu.spi.IlrXUConnectionRequestInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class IlrXUConnectionFactory
implements ConnectionFactory {
    private static final long serialVersionUID = 1L;
    protected Reference reference;
    protected IlrManagedXUConnectionFactory spiFactory;
    protected ConnectionManager connManager;
    protected transient RecordFactory recordFactory = new XURecordFactory();
    protected ResourceAdapterMetaData resourceAdapterMetaData = new IlrXUResourceAdapterMetaData();
    protected LogHandler logger;

    public IlrXUConnectionFactory() {
    }

    public IlrXUConnectionFactory(IlrManagedXUConnectionFactory spiFactory, ConnectionManager connManager) {
        this.spiFactory = spiFactory;
        this.connManager = connManager;
        this.logger = spiFactory.getLogHandler();
    }

    public final ConnectionManager getConnectionManager() {
        return this.connManager;
    }

    public final IlrManagedXUConnectionFactory getManagedConnectionFactory() {
        return this.spiFactory;
    }

    public final Connection getConnection() throws ResourceException {
        throw new LocalizedResourceException("XU.ERROR.10002", new String[]{"ConnectionFactory.getConnection()"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IlrXUConnection allocateConnection(IlrXUConnectionRequestInfo rq) throws XUException, ResourceException {
        if (this.spiFactory.isConcurrentOpenClose().booleanValue()) {
            return (IlrXUConnection)this.connManager.allocateConnection((ManagedConnectionFactory)this.spiFactory, (ConnectionRequestInfo)rq);
        }
        Object object = this.spiFactory.connectionManagerLock;
        synchronized (object) {
            return (IlrXUConnection)this.connManager.allocateConnection((ManagedConnectionFactory)this.spiFactory, (ConnectionRequestInfo)rq);
        }
    }

    public final Connection getConnection(ConnectionSpec connSpec) throws ResourceException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("IlrXUConnectionFactory.getConnection: " + connSpec);
        }
        try {
            IlrXUConnectionSpec xuConnSpec = this.createConnectionSpec(connSpec);
            this.checkConnectionSpec(xuConnSpec);
            IlrXUConnectionRequestInfo rq = IlrXUConnectionFactory.createConnectionRequestInfo(xuConnSpec);
            IlrXUConnection conn = rq.getType() == 2 ? this.spiFactory.getConnection(rq.getConnectionId()) : this.allocateConnection(rq);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(XUMessageCode.INFO_CCI_CONNECTION_OPEN, new Object[]{conn.getId(), rq.getType(), rq.getRulesetPath(), rq.getXOMClassLoader()}, null);
            }
            return conn;
        }
        catch (XUException e) {
            this.logger.severe("XU.ERROR.10011", e, new Object[]{connSpec}, null);
            throw new LocalizedResourceException("XU.ERROR.10011", new String[]{connSpec.toString()}, e);
        }
        catch (ResourceException e) {
            this.logger.severe("XU.ERROR.10011", e, new Object[]{connSpec}, null);
            throw e;
        }
    }

    public final RecordFactory getRecordFactory() throws ResourceException {
        return this.recordFactory;
    }

    public final ResourceAdapterMetaData getMetaData() throws ResourceException {
        return this.resourceAdapterMetaData;
    }

    public final void setReference(Reference reference) {
        this.reference = reference;
    }

    public final Reference getReference() throws NamingException {
        return this.reference;
    }

    protected final IlrXUConnectionSpec createConnectionSpec(ConnectionSpec connSpec) throws ResourceException {
        if (connSpec instanceof IlrXUConnectionSpec) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Client connection spec in the same classloader");
            }
            return (IlrXUConnectionSpec)connSpec;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Client connection spec not in the same classloader");
        }
        try {
            IlrXUConnectionSpec result = new IlrXUConnectionSpec();
            result.init(connSpec);
            return result;
        }
        catch (Exception e) {
            throw new LocalizedResourceException("XU.ERROR.10010", new String[]{connSpec.toString()}, e);
        }
    }

    protected static final IlrXUConnectionRequestInfo createConnectionRequestInfo(IlrXUConnectionSpec connSpec) throws ResourceException {
        return new IlrXUConnectionRequestInfo(connSpec.type, connSpec.rulesetPath, connSpec.xomClassLoader, connSpec.connectionId, connSpec.userData, connSpec.clientJRulesImplementationVersion, connSpec.reconnectSupportEnabled, connSpec.dataConnectorFactory);
    }

    protected final void checkConnectionSpec(IlrXUConnectionSpec connSpec) throws ResourceException {
        boolean valid;
        String clVersion = connSpec.clientJRulesImplementationVersion;
        if (clVersion == null || !clVersion.equals("8.7.1.0")) {
            this.logger.warning(XUMessageCode.WARNING_WRONG_CLIENT_VERSION, null, new Object[]{"8.7.1.0", clVersion}, this, null, true);
        }
        switch (connSpec.type) {
            case 0: {
                valid = connSpec.rulesetPath != null && connSpec.connectionId == null;
                break;
            }
            case 1: {
                valid = connSpec.rulesetPath == null && connSpec.connectionId == null && connSpec.xomClassLoader == null;
                break;
            }
            case 2: {
                valid = connSpec.rulesetPath == null && connSpec.connectionId != null && connSpec.xomClassLoader == null;
                break;
            }
            default: {
                valid = false;
            }
        }
        if (!valid) {
            throw new LocalizedResourceException("XU.ERROR.10010", new String[]{connSpec.toString()});
        }
    }

    public final LogHandler getLogHandler() {
        return this.logger;
    }

    public final XUInfo getXUInfo() throws XUException {
        return this.spiFactory.getXUDump();
    }

    public final List<IlrXUDiagnosticResult> diagnostic() throws ResourceException {
        return this.spiFactory.diagnostic();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.recordFactory = new XURecordFactory();
    }
}

