/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.dataconnector.internal;

import com.ibm.rules.engine.connector.DataConnectorException;
import com.ibm.rules.engine.connector.DataConnectorFactory;
import ilog.rules.res.xu.dataconnector.internal.IlrDataConnectorFactoryWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class IlrDataConnectorHelper {
    public static final String KEY_DATA_CONNECTOR_FACTORY_CLASS_NAME = "class";

    public static DataConnectorFactory createDataConnectorFactory(String className, ClassLoader cl) throws DataConnectorException {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        try {
            Class<?> factoryClass = cl.loadClass(className);
            Class<?> lutFactoryClass = cl.loadClass(DataConnectorFactory.class.getCanonicalName());
            if (!lutFactoryClass.isAssignableFrom(factoryClass)) {
                throw new DataConnectorException();
            }
            Object factory = factoryClass.newInstance();
            if (factory instanceof DataConnectorFactory) {
                return (DataConnectorFactory)factory;
            }
            return new IlrDataConnectorFactoryWrapper(factory);
        }
        catch (ClassNotFoundException e) {
            throw new DataConnectorException((Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new DataConnectorException((Exception)e);
        }
        catch (InstantiationException e) {
            throw new DataConnectorException((Exception)e);
        }
    }

    public static DataConnectorFactory createDataConnectorFactory(Map<String, String> properties, ClassLoader cl) throws DataConnectorException {
        return IlrDataConnectorHelper.createDataConnectorFactory(properties.get(KEY_DATA_CONNECTOR_FACTORY_CLASS_NAME), cl);
    }

    public static DataConnectorFactory createDataConnectorFactory(Properties properties, ClassLoader cl) throws DataConnectorException {
        return IlrDataConnectorHelper.createDataConnectorFactory(properties.getProperty(KEY_DATA_CONNECTOR_FACTORY_CLASS_NAME), cl);
    }

    protected static Map<String, String> toMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            String skey = key.toString();
            String value = properties.getProperty(skey);
            map.put(skey, value.toString());
        }
        return map;
    }

    public static DataConnectorFactory createDataConnectorFactoryFromResource(String resourceName, boolean initialize, ClassLoader resourceCL, ClassLoader factoryCL) throws DataConnectorException {
        if (resourceCL == null) {
            resourceCL = Thread.currentThread().getContextClassLoader();
        }
        InputStream input = null;
        try {
            input = resourceCL.getResourceAsStream(resourceName);
            if (input == null) {
                throw new DataConnectorException();
            }
            Properties props = new Properties();
            props.load(input);
            DataConnectorFactory factory = IlrDataConnectorHelper.createDataConnectorFactory(props, factoryCL);
            if (initialize) {
                factory.initialize(IlrDataConnectorHelper.toMap(props));
            }
            DataConnectorFactory dataConnectorFactory = factory;
            return dataConnectorFactory;
        }
        catch (IOException e) {
            throw new DataConnectorException((Exception)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Map<String, String> extractProperties(String prefix, Map<String, String> properties) {
        HashMap<String, String> factoryProps = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            String key = entry.getKey().substring(prefix.length());
            factoryProps.put(key, entry.getValue());
        }
        return factoryProps;
    }
}

