/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.event.internal;

import com.ibm.rules.res.message.internal.LocalizedIllegalArgumentException;
import ilog.rules.res.xu.event.internal.IlrXUEventMask;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class IlrXUEventMaskParser {
    protected Map<String, Long> maskNames = new HashMap<String, Long>();
    protected Map<Long, String> maskValues = new HashMap<Long, String>();

    public void initialize() {
        try {
            Class<IlrXUEventMask> clazz = IlrXUEventMask.class;
            Field[] fields = clazz.getFields();
            for (int i = 0; i < fields.length; ++i) {
                String maskName = fields[i].getName();
                Long maskValue = new Long(fields[i].getLong(null));
                this.maskNames.put(maskName, maskValue);
                this.maskValues.put(maskValue, maskName);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public long parseMask(String input) {
        Long maskValue = this.maskNames.get(input);
        if (maskValue != null) {
            return maskValue;
        }
        throw new LocalizedIllegalArgumentException("com.ibm.rules.res.xu.messages", "XU.ERROR.10101", new Object[]{input});
    }

    public long parseMasks(String input) {
        long masks = 0L;
        StringTokenizer st = new StringTokenizer(input, "|");
        while (st.hasMoreTokens()) {
            masks |= this.parseMask(st.nextToken());
        }
        return masks;
    }

    public String maskToString(long mask) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (Long maskValue : this.maskNames.values()) {
            if ((mask & maskValue) <= 0L) continue;
            if (first) {
                first = false;
            } else {
                result.append('|');
            }
            result.append(this.maskValues.get(maskValue));
        }
        return result.toString();
    }
}

