/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.management;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.logging.Level;

public class IlrXULogEvent {
    private static final int TIMESTAMP = 0;
    private static final int LEVEL = 1;
    private static final int MSG = 2;
    private static final int STACK = 3;
    private final Object[] message;
    private String messageCode;
    private Serializable[] messageVariables;

    public IlrXULogEvent(Object[] message) {
        this.message = message;
    }

    public IlrXULogEvent(Level level, String messageCode, Serializable[] messageVariables, Throwable t) {
        String stack = null;
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            stack = sw.toString();
        }
        this.message = new Object[]{System.currentTimeMillis(), level, null, stack};
        this.messageCode = messageCode;
        this.messageVariables = messageVariables;
    }

    public long getTimestamp() {
        return (Long)this.message[0];
    }

    public Level getLevel() {
        return (Level)this.message[1];
    }

    public String getMessage() {
        return (String)this.message[2];
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public Serializable[] getMessageVariables() {
        return this.messageVariables;
    }

    public String getStackTrace() {
        return (String)this.message[3];
    }

    public Object[] toObject(String msg) {
        Object[] result = new Object[4];
        System.arraycopy(this.message, 0, result, 0, this.message.length);
        result[2] = msg;
        return result;
    }
}

