/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.management;

import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.management.XUMonitoringPlugin;
import ilog.rules.res.xu.management.IlrMBeanExceptionHelper;
import ilog.rules.res.xu.management.IlrXUMonitoringMBean;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.Map;
import javax.management.OperationsException;

public class IlrXUMonitoring
implements IlrXUMonitoringMBean {
    protected WeakReference<XUMonitoringPlugin> plugin = null;

    public IlrXUMonitoring(XUMonitoringPlugin plugin) {
        this.plugin = new WeakReference<XUMonitoringPlugin>(plugin);
    }

    protected synchronized XUMonitoringPlugin getPlugin() {
        XUMonitoringPlugin p = (XUMonitoringPlugin)this.plugin.get();
        if (p == null) {
            System.err.println("XUMonitoringPlugin.getPlugin: plugin has been released");
            throw new IllegalStateException();
        }
        return p;
    }

    @Override
    public String getAdapterName() {
        return this.getPlugin().getAdapterName();
    }

    @Override
    public String getAdapterVersion() {
        return this.getPlugin().getAdapterVersion();
    }

    @Override
    public String getAdapterShortDescription() {
        return this.getPlugin().getAdapterShortDescription();
    }

    @Override
    public String getAdapterVendorName() {
        return this.getPlugin().getAdapterVendorName();
    }

    @Override
    public Object[] getGlobalLogs(Locale locale) {
        return this.getPlugin().getLogs(locale);
    }

    @Override
    public Object[] getLogs(Locale locale, String canonicalRulesetPath) {
        return this.getPlugin().getLogs(locale, canonicalRulesetPath);
    }

    @Override
    public void resetGlobalLogs() {
        this.getPlugin().resetLogs();
    }

    @Override
    public void resetLogs(String canonicalRulesetPath) {
        this.getPlugin().resetLogs(canonicalRulesetPath);
    }

    @Override
    public long getWarningCount() {
        return this.getPlugin().getWarningCount();
    }

    @Override
    public long getErrorCount() {
        return this.getPlugin().getErrorCount();
    }

    @Override
    public void resetWarningCount() {
        this.getPlugin().resetWarnings();
    }

    @Override
    public void resetErrorCount() {
        this.getPlugin().resetErrors();
    }

    @Override
    public Map<String, long[]> getStatistics(String canonicalRulesetPath) {
        return this.getPlugin().getStatistics(canonicalRulesetPath);
    }

    @Override
    public void resetStatistics(String canonicalRulesetPath) {
        this.getPlugin().removeStatistics(canonicalRulesetPath);
    }

    @Override
    public String getDebugInfos() throws OperationsException {
        try {
            return this.getPlugin().getXUDump();
        }
        catch (XUException e) {
            throw IlrMBeanExceptionHelper.createOperationException("XU.ERROR.10601", new Object[]{e.getMessage()});
        }
    }

    @Override
    public String executionTest() throws OperationsException {
        try {
            Map<String, Object> output = this.getPlugin().executeRuleset("/test_ruleapp/1.0/test_ruleset/1.0");
            return (String)output.get("result");
        }
        catch (XUException e) {
            throw IlrMBeanExceptionHelper.createOperationException("XU.ERROR.10023", new Object[]{e.getMessage()});
        }
    }
}

