/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.persistence.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.persistence.internal.PersistencePropertiesConverter;
import com.ibm.rules.res.xu.persistence.internal.Persistence;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.IlrResourceNotFoundDAOException;
import ilog.rules.res.xu.persistence.IlrPersistenceException;
import ilog.rules.res.xu.ruleset.archive.internal.IlrRulesetArchiveInformationNotFoundException;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetPathException;
import java.util.Map;
import java.util.logging.Level;

public abstract class IlrDAOXUPersistence
extends Persistence {
    private static final long serialVersionUID = 1L;
    protected transient IlrRepositoryDAO dataProvider;
    protected boolean managedXOMLazyLoadEnabled = false;

    protected abstract IlrRepositoryDAO createDataProvider() throws IlrPersistenceException;

    protected synchronized IlrRepositoryDAO getDataProvider() throws IlrPersistenceException {
        if (this.dataProvider == null) {
            this.dataProvider = this.createDataProvider();
            if (this.getProperties() != null) {
                try {
                    this.dataProvider.setConfigParameters(this.getProperties());
                }
                catch (IlrDAOException e) {
                    Map<String, String> obfuscatedProps = PersistencePropertiesConverter.obfuscate(this.getProperties());
                    throw new IlrPersistenceException("XU.ERROR.21001", new String[]{obfuscatedProps.toString()}, (Throwable)e);
                }
            }
        }
        return this.dataProvider;
    }

    @Override
    public void setProperties(Map<String, String> providerProperties) throws IlrPersistenceException {
        super.setProperties(providerProperties);
        String lazyMode = providerProperties.get("XOM_PERSISTENCE_LAZYLOAD");
        this.managedXOMLazyLoadEnabled = lazyMode == null ? false : Boolean.valueOf(lazyMode);
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(new XUSourceLogRecord(Level.FINEST, "managedXOMLazyLoadEnabled=" + this.managedXOMLazyLoadEnabled, new Object[0]));
        }
        this.dataProvider = null;
    }

    @Override
    protected String solveCanonicalRulesetPath(String rulesetPath) throws IlrRulesetPathException, IlrPersistenceException, IlrRulesetArchiveInformationNotFoundException {
        IlrRepositoryDAO repositoryDAO = this.getDataProvider();
        try {
            IlrPath parsedRulesetPath = IlrPath.parsePath(rulesetPath);
            IlrPath canonicalRulesetPath = repositoryDAO.getCanonicalRulesetPath(parsedRulesetPath);
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().log(new XUSourceLogRecord(Level.FINEST, "canonicalRulesetPath=" + canonicalRulesetPath, new Object[0]));
            }
            return canonicalRulesetPath.toString();
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw new IlrRulesetArchiveInformationNotFoundException("XU.ERROR.10008", new String[]{rulesetPath}, (Throwable)e);
        }
        catch (IlrDAOException e) {
            throw new IlrPersistenceException("XU.ERROR.10059", new String[]{rulesetPath}, (Throwable)e);
        }
        catch (IlrFormatException e) {
            throw new IlrRulesetPathException("XU.ERROR.10048", new String[]{rulesetPath}, (Throwable)e);
        }
    }

    @Override
    protected IlrRESRulesetArchive retrieveRESRulesetArchive(IlrPath canonicalRulesetPath) throws IlrPersistenceException {
        try {
            IlrRepositoryDAO repositoryDAO = this.getDataProvider();
            return repositoryDAO.getRESRulesetArchive(canonicalRulesetPath);
        }
        catch (IlrPersistenceException e) {
            throw new IlrPersistenceException("XU.ERROR.10059", new String[]{canonicalRulesetPath.toString()}, (Throwable)e);
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw new IlrPersistenceException("XU.ERROR.10008", new String[]{canonicalRulesetPath.toString()}, (Throwable)e);
        }
        catch (IlrDAOException e) {
            throw new IlrPersistenceException("XU.ERROR.10059", new String[]{canonicalRulesetPath.toString()}, (Throwable)e);
        }
    }

    @Override
    protected Map<String, String> retrieveRulesetArchiveProperties(String rulesetPath) throws IlrRulesetArchiveInformationNotFoundException, IlrPersistenceException {
        IlrRepositoryDAO repositoryDAO = this.getDataProvider();
        try {
            IlrPath path = IlrPath.parsePath(rulesetPath);
            Map<String, String> result = repositoryDAO.getProperties(path);
            return result;
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw new IlrRulesetArchiveInformationNotFoundException("XU.ERROR.10008", new String[]{rulesetPath}, (Throwable)e);
        }
        catch (IlrDAOException e) {
            throw new IlrPersistenceException("XU.ERROR.10059", new String[]{rulesetPath}, (Throwable)e);
        }
        catch (IlrFormatException e) {
            throw new IlrPersistenceException("XU.ERROR.10048", new String[]{rulesetPath}, (Throwable)e);
        }
    }

    @Override
    protected ClassLoader getManagedXOMClassLoader(IlrPath path, ClassLoader mXOMCL) throws IlrRulesetArchiveInformationNotFoundException, IlrPersistenceException {
        try {
            return this.dataProvider.getManagedXOMClassLoader(path, mXOMCL, true, this.managedXOMLazyLoadEnabled);
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw new IlrRulesetArchiveInformationNotFoundException("XU.ERROR.10008", new String[]{path.toString()}, (Throwable)e);
        }
        catch (IlrDAOException e) {
            throw new IlrPersistenceException("XU.ERROR.10059", new String[]{path.toString()}, (Throwable)e);
        }
    }
}

