/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.persistence.internal;

import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.impl.IlrRepositoryDAOFactoryImpl;
import ilog.rules.res.xu.persistence.IlrPersistenceException;
import ilog.rules.res.xu.persistence.internal.IlrDAOXUPersistence;
import java.util.Map;
import java.util.logging.Level;

public class IlrDatasourcePersistenceImpl
extends IlrDAOXUPersistence {
    private static final long serialVersionUID = 1L;
    protected String jndiName = null;

    @Override
    protected IlrRepositoryDAO createDataProvider() throws IlrPersistenceException {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest("IlrDatasourcePersistence.createDataProvider jndiname=" + this.jndiName);
        }
        IlrRepositoryDAOFactoryImpl daoFactory = new IlrRepositoryDAOFactoryImpl();
        try {
            return daoFactory.getDataSourceRepositoryDAO(this.jndiName, false);
        }
        catch (IlrDAOException e) {
            throw new IlrPersistenceException("XU.ERROR.10050", new String[]{"datasource"}, (Throwable)e);
        }
    }

    @Override
    public void setProperties(Map<String, String> providerProperties) throws IlrPersistenceException {
        super.setProperties(providerProperties);
        String jndiNameStr = providerProperties.get("JNDI_NAME");
        if (jndiNameStr != null && jndiNameStr.length() > 0) {
            this.jndiName = jndiNameStr;
        }
    }
}

