/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.persistence.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.log.internal.XULogRecordFactory;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.impl.IlrRepositoryDAOFactoryImpl;
import ilog.rules.res.persistence.impl.file.IlrFileRepositoryDAO;
import ilog.rules.res.xu.persistence.IlrPersistenceException;
import ilog.rules.res.xu.persistence.internal.IlrDAOXUPersistence;
import java.util.Map;
import java.util.logging.Level;

public class IlrFilePersistenceImpl
extends IlrDAOXUPersistence {
    private static final long serialVersionUID = 1L;
    protected String repositoryDir = null;
    protected boolean rulesetArchiveExpanded = false;

    @Override
    protected IlrRepositoryDAO createDataProvider() throws IlrPersistenceException {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(new XUSourceLogRecord(Level.FINEST, "repositoryDir=" + this.repositoryDir, new Object[0]));
        }
        IlrRepositoryDAOFactoryImpl daoFactory = new IlrRepositoryDAOFactoryImpl();
        try {
            if (this.rulesetArchiveExpanded) {
                this.getLogger().log(XULogRecordFactory.createXULogRecord(Level.WARNING, XUMessageCode.WARNING_DEPRECATED_FILE_PERSISTENCE, null, null, null));
                return new IlrFileRepositoryDAO(null, this.repositoryDir, true);
            }
            return daoFactory.getFileRepositoryDAO(this.repositoryDir);
        }
        catch (IlrDAOException e) {
            throw new IlrPersistenceException("XU.ERROR.10050", new String[]{"file"}, (Throwable)e);
        }
    }

    @Override
    public void setProperties(Map<String, String> providerProperties) throws IlrPersistenceException {
        String rulesetArchiveExpandedStr;
        super.setProperties(providerProperties);
        String repositoryDirStr = providerProperties.get("DIRECTORY");
        if (repositoryDirStr != null && repositoryDirStr.length() > 0) {
            this.repositoryDir = repositoryDirStr;
        }
        if ((rulesetArchiveExpandedStr = providerProperties.get("rulesetArchiveExpanded")) != null && rulesetArchiveExpandedStr.length() > 0) {
            this.rulesetArchiveExpanded = true;
        }
    }
}

