/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.persistence.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.impl.IlrRepositoryDAOFactoryImpl;
import ilog.rules.res.xu.persistence.IlrPersistenceException;
import ilog.rules.res.xu.persistence.internal.IlrDAOXUPersistence;
import java.util.Map;
import java.util.logging.Level;

public class IlrJDBCPersistenceImpl
extends IlrDAOXUPersistence {
    private static final long serialVersionUID = 1L;
    protected String user;
    protected String password;
    protected String cryptedPassword;
    protected String url;
    protected String driverClassName;

    @Override
    protected IlrRepositoryDAO createDataProvider() throws IlrPersistenceException {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            String msg = "user=" + this.user + " url=" + this.url + " driverClassName=" + this.driverClassName;
            if (this.password != null) {
                msg = msg + " password=********";
            }
            if (this.cryptedPassword != null) {
                msg = msg + " cryptedPassword=********";
            }
            this.getLogger().log(new XUSourceLogRecord(Level.FINEST, msg, new Object[0]));
        }
        IlrRepositoryDAOFactoryImpl daoFactory = new IlrRepositoryDAOFactoryImpl();
        try {
            return daoFactory.getDriverRepositoryDAO(this.getClass().getClassLoader(), this.driverClassName, this.url, this.user, this.password, this.cryptedPassword);
        }
        catch (IlrDAOException e) {
            throw new IlrPersistenceException("XU.ERROR.10050", new String[]{"jdbc"}, (Throwable)e);
        }
    }

    @Override
    public void setProperties(Map<String, String> providerProperties) throws IlrPersistenceException {
        String driverClassNameStr;
        String urlStr;
        String cryptedPasswordStr;
        String passwordStr;
        super.setProperties(providerProperties);
        String userStr = providerProperties.get("USER");
        if (userStr != null && userStr.length() > 0) {
            this.user = userStr;
        }
        if ((passwordStr = providerProperties.get("PASSWORD")) != null && passwordStr.length() > 0) {
            this.password = passwordStr;
        }
        if ((cryptedPasswordStr = providerProperties.get("CRYPTED_PASSWORD")) != null && cryptedPasswordStr.length() > 0) {
            this.cryptedPassword = cryptedPasswordStr;
        }
        if ((urlStr = providerProperties.get("URL")) != null && urlStr.length() > 0) {
            this.url = urlStr;
        }
        if ((driverClassNameStr = providerProperties.get("DRIVER_CLASS_NAME")) != null && driverClassNameStr.length() > 0) {
            this.driverClassName = driverClassNameStr;
        }
    }
}

